/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app.common;

import android.app.Application;
import android.content.SharedPreferences;

public class PrefUtil {
    private static Application app;

    public static void init(Application app) {
        PrefUtil.app = app;
    }

    private static SharedPreferences getPreference(String preferenceName) {
        if (app == null) {
            throw new NullPointerException("\u8bf7\u521d\u59cb\u5316 PrefUtil");
        }
        return app.getSharedPreferences(preferenceName, 0);
    }

    public static SharedPreferences.Editor getEditor(String preferenceName) {
        if (app == null) {
            throw new NullPointerException("\u8bf7\u521d\u59cb\u5316 PrefUtil");
        }
        SharedPreferences preferences = app.getSharedPreferences(preferenceName, 0);
        return preferences.edit();
    }

    public static boolean isKeyAvailable(String preferenceName, String key) {
        return PrefUtil.getPreference(preferenceName).contains(key);
    }

    public static void removeKey(String preferenceName, String key) {
        if (PrefUtil.isKeyAvailable(preferenceName, key)) {
            SharedPreferences.Editor editor = PrefUtil.getEditor(preferenceName);
            editor.remove(key);
            editor.commit();
        }
    }

    public static long getConfigParams(String preferenceName, String key, long defValue) {
        SharedPreferences preferences = PrefUtil.getPreference(preferenceName);
        return preferences.getLong(key, defValue);
    }

    public static void setConfigParams(String preferenceName, String key, long value) {
        SharedPreferences.Editor editor = PrefUtil.getEditor(preferenceName);
        editor.putLong(key, value);
        editor.commit();
    }

    public static void setConfigParams(String preferenceName, String key, int value) {
        SharedPreferences.Editor editor = PrefUtil.getEditor(preferenceName);
        editor.putInt(key, value);
        editor.commit();
    }

    public static int getConfigParams(String preferenceName, String key, int defValue) {
        SharedPreferences preferences = PrefUtil.getPreference(preferenceName);
        return preferences.getInt(key, defValue);
    }

    public static float getConfigParams(String preferenceName, String key, float defValue) {
        SharedPreferences preferences = PrefUtil.getPreference(preferenceName);
        return preferences.getFloat(key, defValue);
    }

    public static void setConfigParams(String preferenceName, String key, float value) {
        SharedPreferences.Editor editor = PrefUtil.getEditor(preferenceName);
        editor.putFloat(key, value);
        editor.commit();
    }

    public static void setConfigParams(String preferenceName, String key, boolean value) {
        SharedPreferences.Editor editor = PrefUtil.getEditor(preferenceName);
        editor.putBoolean(key, value);
        editor.commit();
    }

    public static boolean getConfigParams(String preferenceName, String key, boolean defValue) {
        SharedPreferences preferences = PrefUtil.getPreference(preferenceName);
        return preferences.getBoolean(key, defValue);
    }

    public static String getConfigParams(String preferenceName, String key, String defValue) {
        SharedPreferences preferences = PrefUtil.getPreference(preferenceName);
        return preferences.getString(key, defValue);
    }

    public static void setConfigParams(String preferenceName, String key, String value) {
        SharedPreferences.Editor editor = PrefUtil.getEditor(preferenceName);
        editor.putString(key, value);
        editor.commit();
    }
}

