/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app.common;

import android.content.Context;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SaveObjectUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveObjToCache(Context context, String fileName, Object obj) {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            File opf = new File(context.getCacheDir(), fileName + ".tmp");
            fos = new FileOutputStream(opf);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(obj);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getObjectFromCache(Context context, String fileName) {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            File opf = new File(context.getCacheDir(), fileName + ".tmp");
            if (!opf.exists()) {
                T t = null;
                return t;
            }
            fis = new FileInputStream(opf);
            ois = new ObjectInputStream(fis);
            Object object = ois.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            T t = null;
            return t;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveObjectToFile(Context context, String fileName, Object obj) {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = context.openFileOutput(fileName, 0);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(obj);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getObjectFromFile(Context context, String fileName) {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = context.openFileInput(fileName);
            ois = new ObjectInputStream(fis);
            Object object = ois.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            T t = null;
            return t;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean deleteObjectFromFile(Context context, String fileName) {
        return context.deleteFile(fileName);
    }

    public static boolean deleteObjectFromCache(Context context, String fileName) {
        File opf = new File(context.getCacheDir(), fileName + ".tmp");
        return opf.delete();
    }
}

