/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app.common;

import android.content.Context;
import android.text.TextPaint;
import android.text.TextUtils;
import android.widget.TextView;
import java.util.Locale;

public class UnitUtil {
    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dp(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int calTextLineInTextView(String text, TextView tv) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return 1;
        }
        TextPaint paint = tv.getPaint();
        float textWidth = paint.measureText(text);
        int tvContentWidth = tv.getMeasuredWidth() - tv.getPaddingLeft() - tv.getPaddingRight();
        if (tvContentWidth == 0) {
            return 1;
        }
        int lines = 0;
        do {
            ++lines;
        } while ((textWidth -= (float)tvContentWidth) > 0.0f);
        return lines;
    }

    public static String humanReadableByte(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format(Locale.getDefault(), "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static long humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes;
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return (long)((double)bytes / Math.pow(unit, exp));
    }

    public static String humanReadableByteUnit(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        return (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
    }
}

