/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app.common.log;

import cn.tianqu.libs.app.common.log.ILog;
import cn.tianqu.libs.app.common.log.LogConfig;
import cn.tianqu.libs.app.common.log.PrintToLogCat;
import java.util.HashMap;
import java.util.Map;

public class LogUtil {
    private static HashMap<String, ILog> loggerHashMap = new HashMap();
    private static final ILog defaultLogger = new PrintToLogCat();

    public static void addLogger(ILog logger) {
        String loggerName = logger.getClass().getName();
        String defaultLoggerName = defaultLogger.getClass().getName();
        if (!loggerHashMap.containsKey(loggerName) && !defaultLoggerName.equalsIgnoreCase(loggerName)) {
            logger.open();
            loggerHashMap.put(loggerName, logger);
        }
    }

    public static void removeLogger(ILog logger) {
        String loggerName = logger.getClass().getName();
        if (loggerHashMap.containsKey(loggerName)) {
            logger.close();
            loggerHashMap.remove(loggerName);
        }
    }

    public static void d(boolean nodeDebug, Object object, String msg) {
        LogUtil.printLog(nodeDebug, 3, object, msg);
    }

    public static void e(boolean nodeDebug, Object object, String msg) {
        LogUtil.printLog(nodeDebug, 6, object, msg);
    }

    public static void i(boolean nodeDebug, Object object, String msg) {
        LogUtil.printLog(nodeDebug, 4, object, msg);
    }

    public static void v(boolean nodeDebug, Object object, String msg) {
        LogUtil.printLog(nodeDebug, 2, object, msg);
    }

    public static void w(boolean nodeDebug, Object object, String msg) {
        LogUtil.printLog(nodeDebug, 5, object, msg);
    }

    public static void d(boolean nodeDebug, String tag, String msg) {
        LogUtil.printLog(nodeDebug, 3, tag, msg);
    }

    public static void e(boolean nodeDebug, String tag, String msg) {
        LogUtil.printLog(nodeDebug, 6, tag, msg);
    }

    public static void i(boolean nodeDebug, String tag, String msg) {
        LogUtil.printLog(nodeDebug, 4, tag, msg);
    }

    public static void v(boolean nodeDebug, String tag, String msg) {
        LogUtil.printLog(nodeDebug, 2, tag, msg);
    }

    public static void w(boolean nodeDebug, String tag, String msg) {
        LogUtil.printLog(nodeDebug, 5, tag, msg);
    }

    public static void println(boolean nodeDebug, int priority, String tag, String msg) {
        LogUtil.printLog(nodeDebug, priority, tag, msg);
    }

    private static void printLog(boolean nodeDebug, int priority, Object object, String msg) {
        Class<?> cls = object.getClass();
        String tag = cls.getName();
        String[] arrays = tag.split("\\.");
        tag = arrays[arrays.length - 1];
        LogUtil.printLog(nodeDebug, priority, tag, msg);
    }

    private static void printLog(boolean nodeDebug, int priority, String tag, String msg) {
        if (LogConfig.DEBUG && nodeDebug) {
            LogUtil.printLog(defaultLogger, priority, tag, msg);
            for (Map.Entry<String, ILog> entry : loggerHashMap.entrySet()) {
                ILog logger = entry.getValue();
                if (logger == null) continue;
                LogUtil.printLog(logger, priority, tag, msg);
            }
        }
    }

    private static void printLog(ILog log, int priority, String tag, String msg) {
        switch (priority) {
            case 2: {
                log.v(tag, msg);
                break;
            }
            case 3: {
                log.d(tag, msg);
                break;
            }
            case 4: {
                log.i(tag, msg);
                break;
            }
            case 5: {
                log.w(tag, msg);
                break;
            }
            case 6: {
                log.e(tag, msg);
                break;
            }
        }
    }
}

