/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app.common.net;

import android.content.DialogInterface;
import cn.tianqu.libs.app.common.net.ApiCallback;
import cn.tianqu.libs.app.common.net.Task;
import cn.tianqu.libs.app.ui.BaseP;
import cn.tianqu.libs.app.ui.BaseV;
import cn.tianqu.libs.app.ui.SimpleDialogListener;

public abstract class SimpleApiCallback<T>
implements ApiCallback<T> {
    protected BaseV baseV;
    protected BaseP baseP;
    protected SimpleApiCallback simpleApiCallback;
    protected Task task;

    public SimpleApiCallback() {
    }

    public SimpleApiCallback(SimpleApiCallback simpleApiCallback) {
        this.simpleApiCallback = simpleApiCallback;
    }

    public SimpleApiCallback(BaseV baseV) {
        this.baseV = baseV;
    }

    public SimpleApiCallback(BaseP baseP) {
        this.baseP = baseP;
    }

    @Override
    public void onStart() {
        if (this.simpleApiCallback != null) {
            this.simpleApiCallback.onStart();
        }
        if (this.baseV != null) {
            this.baseV.showLoadingDialog("\u6b63\u5728\u83b7\u53d6\u6570\u636e", true, false, new SimpleDialogListener(){

                @Override
                public void onCancel(DialogInterface dialog) {
                    super.onCancel(dialog);
                    if (SimpleApiCallback.this.task != null) {
                        SimpleApiCallback.this.task.cancel(false);
                    }
                }
            });
        }
    }

    @Override
    public void onFailure(String code, String msg) {
        if (this.simpleApiCallback != null) {
            this.simpleApiCallback.onFailure(code, msg);
        }
        if (this.baseV != null) {
            this.baseV.showMsgDialog("\u63d0\u793a", msg, "\u518d\u8bd5", "\u653e\u5f03\u4e86", false, false, new SimpleDialogListener(){

                @Override
                public void onPositive(DialogInterface dialog) {
                    super.onPositive(dialog);
                    SimpleApiCallback.this.retry();
                }

                @Override
                public void onNegative(DialogInterface dialog) {
                    super.onNegative(dialog);
                    SimpleApiCallback.this.onCancel();
                }
            });
        }
        if (this.baseP != null) {
            this.baseP.apiFailure(code, msg, this);
        }
    }

    @Override
    public boolean onApiFailure(String code, String msg) {
        if (this.simpleApiCallback != null) {
            this.simpleApiCallback.onApiFailure(code, msg);
        }
        if (this.baseV != null) {
            this.baseV.showMsgDialog("\u63d0\u793a", msg, "", "\u5173\u95ed", true, false, null);
        }
        if (this.baseP != null) {
            this.baseP.apiFailure(code, msg, this);
        }
        return true;
    }

    @Override
    public void onCancel() {
        if (this.simpleApiCallback != null) {
            this.simpleApiCallback.onCancel();
        }
    }

    @Override
    public void onFinish() {
        if (this.simpleApiCallback != null) {
            this.simpleApiCallback.onFinish();
        }
        if (this.baseV != null) {
            this.baseV.hideLoadingDialog();
        }
    }

    public void retry() {
        if (this.simpleApiCallback != null) {
            this.simpleApiCallback.retry();
        }
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }
}

