/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app.common.permission;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;

public class AppSettingsDialog {
    public static final int DEFAULT_SETTINGS_REQ_CODE = 3249;
    private AlertDialog mAlertDialog;

    private AppSettingsDialog(final @NonNull Object activityOrFragment, final @NonNull Context context, @NonNull String rationale, @Nullable String title, @Nullable String positiveButton, @Nullable String negativeButton, @Nullable DialogInterface.OnClickListener negativeListener, int requestCode) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setMessage((CharSequence)rationale);
        builder.setTitle((CharSequence)title);
        String positiveButtonText = TextUtils.isEmpty((CharSequence)positiveButton) ? context.getString(17039370) : positiveButton;
        String negativeButtonText = TextUtils.isEmpty((CharSequence)negativeButton) ? context.getString(0x1040000) : negativeButton;
        final int settingsRequestCode = requestCode > 0 ? requestCode : 3249;
        builder.setPositiveButton((CharSequence)positiveButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
                intent.setData(uri);
                AppSettingsDialog.this.startForResult(activityOrFragment, intent, settingsRequestCode);
            }
        });
        builder.setNegativeButton((CharSequence)negativeButtonText, negativeListener);
        this.mAlertDialog = builder.create();
    }

    private void startForResult(Object object, Intent intent, int requestCode) {
        if (object instanceof Activity) {
            ((Activity)object).startActivityForResult(intent, requestCode);
        } else if (object instanceof android.support.v4.app.Fragment) {
            ((android.support.v4.app.Fragment)object).startActivityForResult(intent, requestCode);
        } else if (object instanceof Fragment) {
            ((Fragment)object).startActivityForResult(intent, requestCode);
        }
    }

    public void show() {
        this.mAlertDialog.show();
    }

    public static class Builder {
        private Object mActivityOrFragment;
        private Context mContext;
        private String mRationale;
        private String mTitle;
        private String mPositiveButton;
        private String mNegativeButton;
        private DialogInterface.OnClickListener mNegativeListener;
        private int mRequestCode = -1;

        public Builder(@NonNull Activity activity, @NonNull String rationale) {
            this.mActivityOrFragment = activity;
            this.mContext = activity;
            this.mRationale = rationale;
        }

        public Builder(@NonNull android.support.v4.app.Fragment fragment, @NonNull String rationale) {
            this.mActivityOrFragment = fragment;
            this.mContext = fragment.getContext();
            this.mRationale = rationale;
        }

        public Builder(@NonNull Fragment fragment, @NonNull String rationale) {
            this.mActivityOrFragment = fragment;
            this.mContext = fragment.getActivity();
            this.mRationale = rationale;
        }

        public Builder setTitle(String title) {
            this.mTitle = title;
            return this;
        }

        public Builder setPositiveButton(String positiveButton) {
            this.mPositiveButton = positiveButton;
            return this;
        }

        public Builder setNegativeButton(String negativeButton, DialogInterface.OnClickListener negativeListener) {
            this.mNegativeButton = negativeButton;
            this.mNegativeListener = negativeListener;
            return this;
        }

        public Builder setRequestCode(int requestCode) {
            this.mRequestCode = requestCode;
            return this;
        }

        public AppSettingsDialog build() {
            return new AppSettingsDialog(this.mActivityOrFragment, this.mContext, this.mRationale, this.mTitle, this.mPositiveButton, this.mNegativeButton, this.mNegativeListener, this.mRequestCode);
        }
    }
}

