/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app.common.permission;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import cn.tianqu.libs.app.common.permission.AfterPermissionGranted;
import cn.tianqu.libs.app.common.permission.AppSettingsDialog;
import cn.tianqu.libs.app.common.permission.RationaleDialogFragment;
import cn.tianqu.libs.app.common.permission.RationaleDialogFragmentCompat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PermissionUtils {
    private static final String TAG = PermissionUtils.class.getCanonicalName();
    private static final String DIALOG_TAG = "RationaleDialogFragmentCompat";

    public static boolean hasPermissions(Context context, String ... perms) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        for (String perm : perms) {
            boolean hasPerm;
            boolean bl = hasPerm = ContextCompat.checkSelfPermission((Context)context, (String)perm) == 0;
            if (hasPerm) continue;
            return false;
        }
        return true;
    }

    public static void requestPermissions(Object object, String rationale, int requestCode, String ... perms) {
        PermissionUtils.requestPermissions(object, rationale, 17039370, 0x1040000, requestCode, perms);
    }

    public static void requestPermissions(Object object, String rationale, int positiveButton, int negativeButton, int requestCode, String ... perms) {
        PermissionUtils.checkCallingObjectSuitability(object);
        boolean shouldShowRationale = false;
        for (String perm : perms) {
            shouldShowRationale = PermissionUtils.shouldShowRequestPermissionRationale(object, perm);
        }
        if (shouldShowRationale) {
            if (PermissionUtils.getSupportFragmentManager(object) != null) {
                PermissionUtils.showRationaleDialogFragmentCompat(PermissionUtils.getSupportFragmentManager(object), rationale, positiveButton, negativeButton, requestCode, perms);
            } else if (PermissionUtils.getFragmentManager(object) != null) {
                PermissionUtils.showRationaleDialogFragment(PermissionUtils.getFragmentManager(object), rationale, positiveButton, negativeButton, requestCode, perms);
            } else {
                PermissionUtils.showRationaleAlertDialog(object, rationale, positiveButton, negativeButton, requestCode, perms);
            }
        } else {
            PermissionUtils.executePermissionsRequest(object, perms, requestCode);
        }
    }

    @RequiresApi(value=11)
    private static void showRationaleDialogFragmentCompat(@NonNull FragmentManager fragmentManager, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, int requestCode, String ... perms) {
        RationaleDialogFragmentCompat fragment = RationaleDialogFragmentCompat.newInstance(positiveButton, negativeButton, rationale, requestCode, perms);
        fragment.show(fragmentManager, DIALOG_TAG);
    }

    @RequiresApi(api=11)
    private static void showRationaleDialogFragment(@NonNull android.app.FragmentManager fragmentManager, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, int requestCode, String ... perms) {
        RationaleDialogFragment fragment = RationaleDialogFragment.newInstance(positiveButton, negativeButton, rationale, requestCode, perms);
        fragment.show(fragmentManager, DIALOG_TAG);
    }

    private static void showRationaleAlertDialog(final @NonNull Object object, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, final int requestCode, final String ... perms) {
        Activity activity = PermissionUtils.getActivity(object);
        if (activity == null) {
            throw new IllegalStateException("Can't show rationale dialog for null Activity");
        }
        new AlertDialog.Builder((Context)activity).setCancelable(false).setMessage((CharSequence)rationale).setPositiveButton(positiveButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                PermissionUtils.executePermissionsRequest(object, perms, requestCode);
            }
        }).setNegativeButton(negativeButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (object instanceof PermissionCallbacks) {
                    ((PermissionCallbacks)object).onPermissionDenied(requestCode, Arrays.asList(perms));
                }
            }
        }).create().show();
    }

    @TargetApi(value=23)
    static void executePermissionsRequest(Object object, String[] perms, int requestCode) {
        PermissionUtils.checkCallingObjectSuitability(object);
        if (object instanceof Activity) {
            ActivityCompat.requestPermissions((Activity)((Activity)object), (String[])perms, (int)requestCode);
        } else if (object instanceof android.support.v4.app.Fragment) {
            ((android.support.v4.app.Fragment)object).requestPermissions(perms, requestCode);
        } else if (object instanceof Fragment) {
            ((Fragment)object).requestPermissions(perms, requestCode);
        }
    }

    public static void onRequestPermissionsResult(int requestCode, String[] perms, int[] grantResults, Object ... receivers) {
        ArrayList<String> granted = new ArrayList<String>();
        ArrayList<String> denied = new ArrayList<String>();
        for (int i = 0; i < perms.length; ++i) {
            String perm = perms[i];
            if (grantResults[i] == 0) {
                granted.add(perm);
                continue;
            }
            denied.add(perm);
        }
        for (Object object : receivers) {
            if (!granted.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionGranted(requestCode, granted);
            }
            if (!denied.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionDenied(requestCode, denied);
            }
            if (granted.isEmpty() || !denied.isEmpty()) continue;
            PermissionUtils.runAnnotatedMethods(object, requestCode);
        }
    }

    private static void runAnnotatedMethods(Object object, int requestCode) {
        Class<?> clazz = object.getClass();
        for (Method method : clazz.getMethods()) {
            AfterPermissionGranted ann;
            if (!method.isAnnotationPresent(AfterPermissionGranted.class) || (ann = method.getAnnotation(AfterPermissionGranted.class)).value() != requestCode) continue;
            if (method.getParameterTypes().length > 0) {
                throw new RuntimeException("Cannot execute method" + method.getName() + " because it is non-void method and/or has input parameters.");
            }
            try {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)"runDefaultMethod: IllegalAccessException", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.e((String)TAG, (String)"runDefaultMethod: InvocationTargetException", (Throwable)e);
            }
        }
    }

    @TargetApi(value=23)
    private static boolean shouldShowRequestPermissionRationale(Object object, String perm) {
        if (object instanceof Activity) {
            return ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)object), (String)perm);
        }
        if (object instanceof android.support.v4.app.Fragment) {
            return ((android.support.v4.app.Fragment)object).shouldShowRequestPermissionRationale(perm);
        }
        if (object instanceof Fragment) {
            return ((Fragment)object).shouldShowRequestPermissionRationale(perm);
        }
        return false;
    }

    @TargetApi(value=11)
    private static Activity getActivity(Object object) {
        if (object instanceof Activity) {
            return (Activity)object;
        }
        if (object instanceof android.support.v4.app.Fragment) {
            return ((android.support.v4.app.Fragment)object).getActivity();
        }
        if (object instanceof Fragment) {
            return ((Fragment)object).getActivity();
        }
        return null;
    }

    private static FragmentManager getSupportFragmentManager(Object object) {
        if (object instanceof FragmentActivity) {
            return ((FragmentActivity)object).getSupportFragmentManager();
        }
        if (object instanceof android.support.v4.app.Fragment) {
            return ((android.support.v4.app.Fragment)object).getChildFragmentManager();
        }
        return null;
    }

    private static android.app.FragmentManager getFragmentManager(Object object) {
        if (object instanceof Activity) {
            if (Build.VERSION.SDK_INT >= 11) {
                return ((Activity)object).getFragmentManager();
            }
        } else if (object instanceof Fragment) {
            if (Build.VERSION.SDK_INT >= 17) {
                return ((Fragment)object).getChildFragmentManager();
            }
            return ((Fragment)object).getFragmentManager();
        }
        return null;
    }

    public static boolean somePermissionsPermanentlyDenied(@NonNull Object object, @NonNull List<String> deniedPermissions) {
        for (String deniedPermission : deniedPermissions) {
            if (!PermissionUtils.permissionPermanentlyDenied(object, deniedPermission)) continue;
            return true;
        }
        return false;
    }

    public static boolean permissionPermanentlyDenied(@NonNull Object object, @NonNull String deniedPermission) {
        return !PermissionUtils.shouldShowRequestPermissionRationale(object, deniedPermission);
    }

    public static void onPermissionsPermanentlyDenied(@NonNull Activity activity, @NonNull String rationale, @NonNull String title, @NonNull String positiveButton, @NonNull String negativeButton, int requestCode) {
        new AppSettingsDialog.Builder(activity, rationale).setTitle(title).setPositiveButton(positiveButton).setNegativeButton(negativeButton, null).setRequestCode(requestCode).build().show();
    }

    public static void onPermissionsPermanentlyDenied(@NonNull Fragment fragment, @NonNull String rationale, @NonNull String title, @NonNull String positiveButton, @NonNull String negativeButton, int requestCode) {
        new AppSettingsDialog.Builder(fragment, rationale).setTitle(title).setPositiveButton(positiveButton).setNegativeButton(negativeButton, null).setRequestCode(requestCode).build().show();
    }

    public static void onPermissionsPermanentlyDenied(@NonNull android.support.v4.app.Fragment fragment, @NonNull String rationale, @NonNull String title, @NonNull String positiveButton, @NonNull String negativeButton, int requestCode) {
        new AppSettingsDialog.Builder(fragment, rationale).setTitle(title).setPositiveButton(positiveButton).setNegativeButton(negativeButton, null).setRequestCode(requestCode).build().show();
    }

    private static void checkCallingObjectSuitability(Object object) {
        boolean isMinSdkM;
        if (object == null) {
            throw new NullPointerException("Activity or Fragment should not be null");
        }
        boolean isActivity = object instanceof Activity;
        boolean isSupportFragment = object instanceof android.support.v4.app.Fragment;
        boolean isAppFragment = object instanceof Fragment;
        boolean bl = isMinSdkM = Build.VERSION.SDK_INT >= 23;
        if (!(isSupportFragment || isActivity || isAppFragment && isMinSdkM)) {
            if (isAppFragment) {
                throw new IllegalArgumentException("Target SDK needs to be greater than 23 if caller is android.app.Fragment");
            }
            throw new IllegalArgumentException("Caller must be an Activity or a Fragment");
        }
    }

    public static interface PermissionCallbacks
    extends ActivityCompat.OnRequestPermissionsResultCallback {
        public void onPermissionGranted(int var1, List<String> var2);

        public void onPermissionDenied(int var1, List<String> var2);
    }
}

