/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import cn.tianqu.libs.app.BaseApp;
import cn.tianqu.libs.app.R;
import cn.tianqu.libs.app.common.log.LogUtil;
import cn.tianqu.libs.app.common.net.MyAsyncHttpClient;
import cn.tianqu.libs.app.common.permission.PermissionUtils;
import cn.tianqu.libs.app.ui.BaseActivityV;
import cn.tianqu.libs.app.ui.BaseUI;
import java.util.List;
import org.androidannotations.annotations.AfterViews;
import org.androidannotations.annotations.EActivity;
import org.androidannotations.annotations.UiThread;

@EActivity
public abstract class BaseActivity
extends AppCompatActivity
implements BaseActivityV,
PermissionUtils.PermissionCallbacks {
    protected boolean DEBUG = true;
    protected final String TAG = this.getClass().getSimpleName();
    private static final int PERMANENTLY_DENIED_REQUEST_CODE = 428;
    protected Activity activity;
    private BaseUI baseUI;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.activity = this;
        this.baseUI = new BaseUI((Context)this.activity);
        ((BaseApp)this.getApplication()).addActivity((Activity)this);
    }

    protected void onDestroy() {
        super.onDestroy();
        ((BaseApp)this.getApplication()).removeActivity((Activity)this);
        this.baseUI.dismissAllDialog();
        MyAsyncHttpClient.cancelRequests((Context)this.activity, true);
    }

    @AfterViews
    protected abstract void init();

    protected void initToolbar() {
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionUtils.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }

    @Override
    public void onPermissionGranted(int requestCode, List<String> perms) {
        LogUtil.d(this.DEBUG, this.TAG, perms.size() + " permissions granted.");
    }

    @Override
    public void onPermissionDenied(int requestCode, List<String> perms) {
        LogUtil.d(this.DEBUG, this.TAG, perms.size() + " permissions denied.");
        if (PermissionUtils.somePermissionsPermanentlyDenied(this, perms)) {
            PermissionUtils.onPermissionsPermanentlyDenied((Activity)this, this.getString(R.string.rationale), this.getString(R.string.rationale_title), this.getString(17039370), this.getString(0x1040000), 428);
        }
    }

    @Override
    public void showToast(String msg) {
        this.showToast(msg, 0);
    }

    @Override
    @UiThread
    public void showToast(String msg, int duration) {
        this.baseUI.showToast(msg, duration);
    }

    @Override
    @UiThread
    public void showLoadingDialog(String msg, boolean cancelable, boolean cancelOutside, BaseUI.DialogListener dialogListener) {
        this.baseUI.showLoadingDialog(msg, cancelable, cancelOutside, dialogListener);
    }

    @Override
    @UiThread
    public void showLoadingDialog(String msg, int progressColorRes, boolean cancelable, boolean cancelOutside, BaseUI.DialogListener dialogListener) {
        this.baseUI.showLoadingDialog(msg, progressColorRes, cancelable, cancelOutside, dialogListener);
    }

    @Override
    @UiThread
    public void hideLoadingDialog() {
        this.baseUI.hideLoadingDialog();
    }

    @Override
    @UiThread
    public void showMsgDialog(String title, String msg, String positiveText, String negativeText, boolean cancleable, boolean cancelOutside, BaseUI.DialogListener dialogListener) {
        this.baseUI.showMsgDialog(title, msg, positiveText, negativeText, cancleable, cancelOutside, dialogListener);
    }

    @Override
    @UiThread
    public void onNetworkUnavailability() {
        this.baseUI.onNetworkUnavailability();
    }

    protected void hideSoftInput() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
        if (inputMethodManager != null) {
            View v = this.getCurrentFocus();
            if (v == null) {
                return;
            }
            inputMethodManager.hideSoftInputFromWindow(v.getWindowToken(), 2);
        }
    }

    @Override
    public void onNetworkChange(boolean isNetworkConnect) {
    }
}

