/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import cn.tianqu.libs.app.common.log.LogUtil;
import cn.tianqu.libs.app.common.permission.PermissionUtils;
import cn.tianqu.libs.app.ui.BaseFragmentV;
import cn.tianqu.libs.app.ui.BaseUI;
import java.util.List;
import org.androidannotations.annotations.AfterViews;
import org.androidannotations.annotations.EFragment;
import org.androidannotations.annotations.UiThread;

@EFragment
public abstract class BaseFragment
extends Fragment
implements BaseFragmentV,
PermissionUtils.PermissionCallbacks {
    protected boolean DEBUG = true;
    protected final String TAG = this.getClass().getSimpleName();
    protected Activity activity;
    private BaseUI baseUI;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.activity = this.getActivity();
        this.baseUI = new BaseUI((Context)this.activity);
    }

    public void onDestroy() {
        this.baseUI.dismissAllDialog();
        super.onDestroy();
    }

    @AfterViews
    protected abstract void initView();

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionUtils.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }

    @Override
    public void onPermissionGranted(int requestCode, List<String> perms) {
        LogUtil.d(this.DEBUG, this.TAG, perms.size() + " permissions granted.");
    }

    @Override
    public void onPermissionDenied(int requestCode, List<String> perms) {
        LogUtil.e(this.DEBUG, this.TAG, perms.size() + " permissions denied.");
    }

    @Override
    public void showToast(String msg) {
        this.showToast(msg, 0);
    }

    @Override
    @UiThread
    public void showToast(String msg, int duration) {
        this.baseUI.showToast(msg, duration);
    }

    @Override
    @UiThread
    public void showLoadingDialog(String msg, boolean cancelable, boolean cancelOutside, BaseUI.DialogListener dialogListener) {
        this.baseUI.showLoadingDialog(msg, cancelable, cancelOutside, dialogListener);
    }

    @Override
    @UiThread
    public void showLoadingDialog(String msg, int progressColorRes, boolean cancelable, boolean cancelOutside, BaseUI.DialogListener dialogListener) {
        this.baseUI.showLoadingDialog(msg, progressColorRes, cancelable, cancelOutside, dialogListener);
    }

    @Override
    @UiThread
    public void hideLoadingDialog() {
        this.baseUI.hideLoadingDialog();
    }

    @Override
    @UiThread
    public void showMsgDialog(String title, String msg, String positiveText, String negativeText, boolean cancleable, boolean cancelOutside, BaseUI.DialogListener dialogListener) {
        this.baseUI.showMsgDialog(title, msg, positiveText, negativeText, cancleable, cancelOutside, dialogListener);
    }

    @Override
    @UiThread
    public void onNetworkUnavailability() {
        this.baseUI.onNetworkUnavailability();
    }
}

