/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app.ui;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.widget.Toast;
import cn.tianqu.libs.app.common.widget.LoadingDialog;
import cn.tianqu.libs.app.ui.BaseV;
import com.afollestad.materialdialogs.MaterialDialog;
import org.androidannotations.annotations.EBean;

@EBean
public class BaseUI
implements BaseV {
    private Context context;
    private Toast toast;
    private LoadingDialog loadingDialog;
    private MaterialDialog msgDialog;

    public BaseUI(Context context) {
        this.context = context;
    }

    @Override
    public synchronized void showToast(String msg, int duration) {
        if (this.toast != null) {
            this.toast.cancel();
        }
        this.toast = Toast.makeText((Context)this.context, (CharSequence)msg, (int)duration);
        this.toast.show();
    }

    @Override
    public void showToast(String msg) {
        this.showToast(msg, 0);
    }

    @Override
    public void showLoadingDialog(String msg, boolean cancelable, boolean cancelOutside, DialogListener dialogListener) {
        this.showLoadingDialog(msg, 0, cancelable, cancelOutside, dialogListener);
    }

    @Override
    public void showLoadingDialog(String msg, int progressColorRes, boolean cancelable, boolean cancelOutside, final DialogListener dialogListener) {
        if (this.loadingDialog != null) {
            this.loadingDialog.dismiss();
        }
        this.loadingDialog = new LoadingDialog(this.context, msg, progressColorRes, cancelable, cancelOutside, null);
        if (dialogListener != null) {
            this.loadingDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialogInterface) {
                    dialogListener.onCancel(dialogInterface);
                }
            });
            this.loadingDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialogInterface) {
                    dialogListener.onDismiss(dialogInterface);
                }
            });
        }
        this.loadingDialog.show();
    }

    @Override
    public void hideLoadingDialog() {
        if (this.loadingDialog != null) {
            this.loadingDialog.hide();
        }
    }

    @Override
    public void showMsgDialog(String title, String msg, String positiveText, String negativeText, boolean cancleable, boolean cancelOutside, final DialogListener dialogListener) {
        if (!((Activity)this.context).isFinishing()) {
            if (this.msgDialog != null) {
                this.msgDialog.dismiss();
            }
            MaterialDialog.Builder dialogBuilder = new MaterialDialog.Builder(this.context);
            dialogBuilder.positiveText((CharSequence)positiveText);
            dialogBuilder.negativeText((CharSequence)negativeText);
            dialogBuilder.title((CharSequence)title);
            dialogBuilder.content((CharSequence)msg);
            if (dialogListener != null) {
                dialogBuilder.callback(new MaterialDialog.ButtonCallback(){

                    public void onPositive(MaterialDialog dialog) {
                        super.onPositive(dialog);
                        dialogListener.onPositive((DialogInterface)dialog);
                    }

                    public void onNegative(MaterialDialog dialog) {
                        super.onNegative(dialog);
                        dialogListener.onNegative((DialogInterface)dialog);
                    }
                });
                dialogBuilder.cancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        dialogListener.onCancel(dialog);
                    }
                });
                dialogBuilder.dismissListener(new DialogInterface.OnDismissListener(){

                    public void onDismiss(DialogInterface dialog) {
                        dialogListener.onDismiss(dialog);
                    }
                });
            }
            this.msgDialog = dialogBuilder.build();
            this.msgDialog.setCancelable(cancleable);
            this.msgDialog.setCanceledOnTouchOutside(cancelOutside);
            this.msgDialog.show();
        }
    }

    @Override
    public void onNetworkUnavailability() {
        this.showToast("\u6ca1\u6709\u7f51\u7edc", 0);
    }

    protected void dismissAllDialog() {
        if (this.loadingDialog != null) {
            this.loadingDialog.dismiss();
        }
        if (this.msgDialog != null) {
            this.msgDialog.dismiss();
        }
    }

    public static interface DialogListener {
        public void onPositive(DialogInterface var1);

        public void onNegative(DialogInterface var1);

        public void onCancel(DialogInterface var1);

        public void onDismiss(DialogInterface var1);
    }
}

