/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.content.res;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.ResourceManagerInternal;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ColorStateListInflaterCompat;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParser;

@SuppressLint(value={"RestrictedAPI"})
public final class AppCompatResources {
    private static final String LOG_TAG = "AppCompatResources";
    private static final ThreadLocal<TypedValue> TL_TYPED_VALUE = new ThreadLocal();
    private static final WeakHashMap<Context, SparseArray<ColorStateListCacheEntry>> sColorStateCaches = new WeakHashMap(0);
    private static final Object sColorStateCacheLock = new Object();

    private AppCompatResources() {
    }

    public static ColorStateList getColorStateList(@NonNull Context context, @ColorRes int resId) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getColorStateList(resId);
        }
        ColorStateList csl = AppCompatResources.getCachedColorStateList(context, resId);
        if (csl != null) {
            return csl;
        }
        csl = AppCompatResources.inflateColorStateList(context, resId);
        if (csl != null) {
            AppCompatResources.addColorStateListToCache(context, resId, csl);
            return csl;
        }
        return ContextCompat.getColorStateList((Context)context, (int)resId);
    }

    @Nullable
    public static Drawable getDrawable(@NonNull Context context, @DrawableRes int resId) {
        return ResourceManagerInternal.get().getDrawable(context, resId);
    }

    @Nullable
    private static ColorStateList inflateColorStateList(Context context, int resId) {
        if (AppCompatResources.isColorInt(context, resId)) {
            return null;
        }
        Resources r = context.getResources();
        XmlResourceParser xml = r.getXml(resId);
        try {
            return ColorStateListInflaterCompat.createFromXml((Resources)r, (XmlPullParser)xml, (Resources.Theme)context.getTheme());
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Failed to inflate ColorStateList, leaving it to the framework", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ColorStateList getCachedColorStateList(@NonNull Context context, @ColorRes int resId) {
        Object object = sColorStateCacheLock;
        synchronized (object) {
            ColorStateListCacheEntry entry;
            SparseArray<ColorStateListCacheEntry> entries = sColorStateCaches.get(context);
            if (entries != null && entries.size() > 0 && (entry = (ColorStateListCacheEntry)entries.get(resId)) != null) {
                if (entry.configuration.equals(context.getResources().getConfiguration())) {
                    return entry.value;
                }
                entries.remove(resId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addColorStateListToCache(@NonNull Context context, @ColorRes int resId, @NonNull ColorStateList value) {
        Object object = sColorStateCacheLock;
        synchronized (object) {
            SparseArray entries = sColorStateCaches.get(context);
            if (entries == null) {
                entries = new SparseArray();
                sColorStateCaches.put(context, (SparseArray<ColorStateListCacheEntry>)entries);
            }
            entries.append(resId, (Object)new ColorStateListCacheEntry(value, context.getResources().getConfiguration()));
        }
    }

    private static boolean isColorInt(@NonNull Context context, @ColorRes int resId) {
        Resources r = context.getResources();
        TypedValue value = AppCompatResources.getTypedValue();
        r.getValue(resId, value, true);
        return value.type >= 28 && value.type <= 31;
    }

    @NonNull
    private static TypedValue getTypedValue() {
        TypedValue tv = TL_TYPED_VALUE.get();
        if (tv == null) {
            tv = new TypedValue();
            TL_TYPED_VALUE.set(tv);
        }
        return tv;
    }

    private static class ColorStateListCacheEntry {
        final ColorStateList value;
        final Configuration configuration;

        ColorStateListCacheEntry(@NonNull ColorStateList value, @NonNull Configuration configuration) {
            this.value = value;
            this.configuration = configuration;
        }
    }
}

