/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.impl.Camera2CameraImpl;
import androidx.camera.camera2.impl.Camera2LensFacingCameraIdFilter;
import androidx.camera.camera2.impl.CameraAvailabilityRegistry;
import androidx.camera.camera2.impl.compat.CameraManagerCompat;
import androidx.camera.core.CameraFactory;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraInternal;
import androidx.camera.core.LensFacingCameraIdFilter;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class Camera2CameraFactory
implements CameraFactory {
    private static final String TAG = "Camera2CameraFactory";
    private static final int DEFAULT_ALLOWED_CONCURRENT_OPEN_CAMERAS = 1;
    private static final HandlerThread sHandlerThread = new HandlerThread("CameraX-");
    private static final Handler sHandler;
    private final CameraAvailabilityRegistry mAvailabilityRegistry;
    private final CameraManagerCompat mCameraManager;

    public Camera2CameraFactory(@NonNull Context context) {
        this.mCameraManager = CameraManagerCompat.from(context);
        this.mAvailabilityRegistry = new CameraAvailabilityRegistry(1, CameraXExecutors.newHandlerExecutor((Handler)sHandler));
    }

    @NonNull
    public CameraInternal getCamera(@NonNull String cameraId) {
        Camera2CameraImpl camera2CameraImpl = new Camera2CameraImpl(this.mCameraManager, cameraId, this.mAvailabilityRegistry.getAvailableCameraCount(), sHandler);
        this.mAvailabilityRegistry.registerCamera(camera2CameraImpl);
        return camera2CameraImpl;
    }

    @NonNull
    public Set<String> getAvailableCameraIds() throws CameraInfoUnavailableException {
        List<String> camerasList = null;
        try {
            camerasList = Arrays.asList(this.mCameraManager.unwrap().getCameraIdList());
        }
        catch (CameraAccessException e) {
            throw new CameraInfoUnavailableException("Unable to retrieve list of cameras on device.", (Throwable)e);
        }
        return new LinkedHashSet<String>(camerasList);
    }

    @Nullable
    public String cameraIdForLensFacing(int lensFacing) throws CameraInfoUnavailableException {
        Set availableCameraIds = this.getLensFacingCameraIdFilter(lensFacing).filter(this.getAvailableCameraIds());
        if (!availableCameraIds.isEmpty()) {
            return (String)availableCameraIds.iterator().next();
        }
        return null;
    }

    @NonNull
    public LensFacingCameraIdFilter getLensFacingCameraIdFilter(int lensFacing) {
        return new Camera2LensFacingCameraIdFilter(lensFacing, this.mCameraManager.unwrap());
    }

    static {
        sHandlerThread.start();
        sHandler = new Handler(sHandlerThread.getLooper());
    }
}

