/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.camera.camera2.impl.Camera2CameraControl;
import androidx.camera.camera2.impl.Camera2CameraInfo;
import androidx.camera.camera2.impl.CaptureSession;
import androidx.camera.camera2.impl.compat.CameraManagerCompat;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraControlInternal;
import androidx.camera.core.CameraDeviceStateCallbacks;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraInfoInternal;
import androidx.camera.core.CameraInternal;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.DeferrableSurface;
import androidx.camera.core.ImmediateSurface;
import androidx.camera.core.Observable;
import androidx.camera.core.Preview;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseAttachState;
import androidx.camera.core.impl.LiveDataObservable;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

final class Camera2CameraImpl
implements CameraInternal {
    private static final String TAG = "Camera";
    private static final int ERROR_NONE = 0;
    private final Object mAttachedUseCaseLock = new Object();
    @GuardedBy(value="mAttachedUseCaseLock")
    private final UseCaseAttachState mUseCaseAttachState;
    private final String mCameraId;
    private final CameraManagerCompat mCameraManager;
    final Handler mHandler;
    private final Executor mExecutor;
    volatile InternalState mState = InternalState.INITIALIZED;
    private final LiveDataObservable<CameraInternal.State> mObservableState = new LiveDataObservable();
    private final Camera2CameraControl mCameraControlInternal;
    private final StateCallback mStateCallback = new StateCallback();
    @NonNull
    private CameraInfoInternal mCameraInfoInternal;
    @Nullable
    CameraDevice mCameraDevice;
    int mCameraDeviceError = 0;
    private CaptureSession.Builder mCaptureSessionBuilder = new CaptureSession.Builder();
    CaptureSession mCaptureSession;
    SessionConfig mCameraControlSessionConfig = SessionConfig.defaultEmptySessionConfig();
    private final Object mPendingLock = new Object();
    @GuardedBy(value="mPendingLock")
    private final List<UseCase> mPendingForAddOnline = new ArrayList<UseCase>();
    final AtomicInteger mReleaseRequestCount = new AtomicInteger(0);
    ListenableFuture<Void> mUserReleaseFuture;
    CallbackToFutureAdapter.Completer<Void> mUserReleaseNotifier;
    final Map<CaptureSession, ListenableFuture<Void>> mReleasedCaptureSessions = new HashMap<CaptureSession, ListenableFuture<Void>>();
    private final Observable<Integer> mAvailableCamerasObservable;
    private final CameraAvailability mCameraAvailability;
    private boolean mIsConfiguringForClose = false;

    Camera2CameraImpl(CameraManagerCompat cameraManager, String cameraId, @NonNull Observable<Integer> availableCamerasObservable, Handler handler) {
        this.mCameraManager = cameraManager;
        this.mCameraId = cameraId;
        this.mAvailableCamerasObservable = availableCamerasObservable;
        this.mHandler = handler;
        ScheduledExecutorService executorScheduler = CameraXExecutors.newHandlerExecutor((Handler)this.mHandler);
        this.mExecutor = executorScheduler;
        this.mUseCaseAttachState = new UseCaseAttachState(cameraId);
        this.mObservableState.postValue((Object)CameraInternal.State.CLOSED);
        try {
            CameraCharacteristics cameraCharacteristics = this.mCameraManager.unwrap().getCameraCharacteristics(this.mCameraId);
            this.mCameraControlInternal = new Camera2CameraControl(cameraCharacteristics, executorScheduler, executorScheduler, new ControlUpdateListenerInternal());
            this.mCameraInfoInternal = new Camera2CameraInfo(cameraCharacteristics, this.mCameraControlInternal.getZoomControl(), this.mCameraControlInternal.getTorchControl());
            Camera2CameraInfo camera2CameraInfo = (Camera2CameraInfo)this.mCameraInfoInternal;
            this.mCaptureSessionBuilder.setSupportedHardwareLevel(camera2CameraInfo.getSupportedHardwareLevel());
        }
        catch (CameraAccessException e) {
            throw new IllegalStateException("Cannot access camera", e);
        }
        this.mCaptureSessionBuilder.setExecutor(this.mExecutor);
        this.mCaptureSession = this.mCaptureSessionBuilder.build();
        this.mCameraAvailability = new CameraAvailability(this.mCameraId);
        this.mAvailableCamerasObservable.addObserver(this.mExecutor, (Observable.Observer)this.mCameraAvailability);
        this.mCameraManager.registerAvailabilityCallback(this.mExecutor, this.mCameraAvailability);
    }

    public void open() {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.open();
                }
            });
            return;
        }
        switch (this.mState) {
            case INITIALIZED: {
                this.openCameraDevice();
                break;
            }
            case CLOSING: {
                this.setState(InternalState.REOPENING);
                if (this.isSessionCloseComplete() || this.mCameraDeviceError != 0) break;
                Preconditions.checkState((this.mCameraDevice != null ? 1 : 0) != 0, (String)"Camera Device should be open if session close is not complete");
                this.setState(InternalState.OPENED);
                this.openCaptureSession();
                break;
            }
            default: {
                Log.d((String)TAG, (String)("open() ignored due to being in state: " + (Object)((Object)this.mState)));
            }
        }
    }

    public void close() {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.close();
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Closing camera: " + this.mCameraId));
        switch (this.mState) {
            case OPENED: {
                this.setState(InternalState.CLOSING);
                this.closeCamera(false);
                break;
            }
            case OPENING: 
            case REOPENING: {
                this.setState(InternalState.CLOSING);
                break;
            }
            case PENDING_OPEN: {
                Preconditions.checkState((this.mCameraDevice == null ? 1 : 0) != 0);
                this.setState(InternalState.INITIALIZED);
                break;
            }
            default: {
                Log.d((String)TAG, (String)("close() ignored due to being in state: " + (Object)((Object)this.mState)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void configAndClose(boolean abortInFlightCaptures) {
        this.mIsConfiguringForClose = true;
        this.resetCaptureSession(abortInFlightCaptures);
        CaptureSession dummySession = this.mCaptureSessionBuilder.build();
        final SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        surfaceTexture.setDefaultBufferSize(640, 480);
        final Surface surface = new Surface(surfaceTexture);
        Runnable closeAndCleanupRunner = new Runnable(){

            @Override
            public void run() {
                surface.release();
                surfaceTexture.release();
            }
        };
        SessionConfig.Builder builder = new SessionConfig.Builder();
        builder.addNonRepeatingSurface((DeferrableSurface)new ImmediateSurface(surface));
        builder.setTemplateType(1);
        try {
            Log.d((String)TAG, (String)"Start configAndClose.");
            dummySession.open(builder.build(), this.mCameraDevice);
            this.mIsConfiguringForClose = false;
            ListenableFuture<Void> releaseFuture = this.releaseSession(dummySession, false);
            releaseFuture.addListener(closeAndCleanupRunner, CameraXExecutors.directExecutor());
        }
        catch (CameraAccessException e) {
            Log.d((String)TAG, (String)("Unable to configure camera " + this.mCameraId + " due to " + e.getMessage()));
            closeAndCleanupRunner.run();
        }
        catch (DeferrableSurface.SurfaceClosedException e) {
            this.postSurfaceClosedError(e);
        }
        finally {
            this.mIsConfiguringForClose = false;
            this.resetCaptureSession(false);
        }
    }

    boolean isSessionCloseComplete() {
        return this.mReleasedCaptureSessions.isEmpty() && !this.mIsConfiguringForClose;
    }

    void finishClose() {
        Preconditions.checkState((this.mState == InternalState.RELEASING || this.mState == InternalState.CLOSING ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.mReleasedCaptureSessions.isEmpty());
        this.mCameraDevice = null;
        if (this.mState == InternalState.CLOSING) {
            this.setState(InternalState.INITIALIZED);
        } else {
            this.setState(InternalState.RELEASED);
            this.mAvailableCamerasObservable.removeObserver((Observable.Observer)this.mCameraAvailability);
            this.mCameraManager.unregisterAvailabilityCallback(this.mCameraAvailability);
            if (this.mUserReleaseNotifier != null) {
                this.mUserReleaseNotifier.set(null);
                this.mUserReleaseNotifier = null;
            }
        }
    }

    @WorkerThread
    void closeCamera(boolean abortInFlightCaptures) {
        boolean isLegacyDevice;
        Preconditions.checkState((this.mState == InternalState.CLOSING || this.mState == InternalState.RELEASING || this.mState == InternalState.REOPENING && this.mCameraDeviceError != 0 ? 1 : 0) != 0, (String)("closeCamera should only be called in a CLOSING, RELEASING or REOPENING (with error) state. Current state: " + (Object)((Object)this.mState) + " (error: " + this.getErrorMessage(this.mCameraDeviceError) + ")"));
        Camera2CameraInfo camera2CameraInfo = (Camera2CameraInfo)this.getCameraInfoInternal();
        boolean bl = isLegacyDevice = camera2CameraInfo.getSupportedHardwareLevel() == 2;
        if (Build.VERSION.SDK_INT > 23 && Build.VERSION.SDK_INT < 29 && isLegacyDevice && this.mCameraDeviceError == 0) {
            this.configAndClose(abortInFlightCaptures);
        } else {
            this.resetCaptureSession(abortInFlightCaptures);
        }
        this.mCaptureSession.cancelIssuedCaptureRequests();
    }

    @WorkerThread
    private ListenableFuture<Void> releaseSession(final @NonNull CaptureSession captureSession, boolean abortInFlightCaptures) {
        captureSession.close();
        ListenableFuture<Void> releaseFuture = captureSession.release(abortInFlightCaptures);
        Log.d((String)TAG, (String)("releasing session in state " + this.mState.name()));
        this.mReleasedCaptureSessions.put(captureSession, releaseFuture);
        Futures.addCallback(releaseFuture, (FutureCallback)new FutureCallback<Void>(){

            @WorkerThread
            public void onSuccess(@Nullable Void result) {
                Camera2CameraImpl.this.mReleasedCaptureSessions.remove(captureSession);
                switch (Camera2CameraImpl.this.mState) {
                    case REOPENING: {
                        if (Camera2CameraImpl.this.mCameraDeviceError == 0) break;
                    }
                    case CLOSING: 
                    case RELEASING: {
                        if (!Camera2CameraImpl.this.isSessionCloseComplete() || Camera2CameraImpl.this.mCameraDevice == null) break;
                        Camera2CameraImpl.this.mCameraDevice.close();
                        Camera2CameraImpl.this.mCameraDevice = null;
                        break;
                    }
                }
            }

            public void onFailure(Throwable t) {
            }
        }, (Executor)CameraXExecutors.directExecutor());
        return releaseFuture;
    }

    @NonNull
    public ListenableFuture<Void> release() {
        ListenableFuture releaseFuture = CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<Void>(){

            public Object attachCompleter(final @NonNull CallbackToFutureAdapter.Completer<Void> completer) {
                Camera2CameraImpl.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Futures.propagate(Camera2CameraImpl.this.getOrCreateUserReleaseFuture(), (CallbackToFutureAdapter.Completer)completer);
                    }
                });
                return "Release[request=" + Camera2CameraImpl.this.mReleaseRequestCount.getAndIncrement() + "]";
            }
        });
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.releaseInternal();
                }
            });
        } else {
            this.releaseInternal();
        }
        return releaseFuture;
    }

    @NonNull
    public Observable<CameraInternal.State> getCameraState() {
        return this.mObservableState;
    }

    @WorkerThread
    void releaseInternal() {
        switch (this.mState) {
            case INITIALIZED: 
            case PENDING_OPEN: {
                Preconditions.checkState((this.mCameraDevice == null ? 1 : 0) != 0);
                this.setState(InternalState.RELEASING);
                Preconditions.checkState((boolean)this.isSessionCloseComplete());
                this.finishClose();
                break;
            }
            case OPENED: {
                this.setState(InternalState.RELEASING);
                this.closeCamera(true);
                break;
            }
            case CLOSING: 
            case OPENING: 
            case REOPENING: 
            case RELEASING: {
                this.setState(InternalState.RELEASING);
                break;
            }
            default: {
                Log.d((String)TAG, (String)("release() ignored due to being in state: " + (Object)((Object)this.mState)));
            }
        }
    }

    @WorkerThread
    ListenableFuture<Void> getOrCreateUserReleaseFuture() {
        if (this.mUserReleaseFuture == null) {
            this.mUserReleaseFuture = this.mState != InternalState.RELEASED ? CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<Void>(){

                public Object attachCompleter(@NonNull CallbackToFutureAdapter.Completer<Void> completer) {
                    Preconditions.checkState((Camera2CameraImpl.this.mUserReleaseNotifier == null ? 1 : 0) != 0, (String)"Camera can only be released once, so release completer should be null on creation.");
                    Camera2CameraImpl.this.mUserReleaseNotifier = completer;
                    return "Release[camera=" + Camera2CameraImpl.this + "]";
                }
            }) : Futures.immediateFuture(null);
        }
        return this.mUserReleaseFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUseCaseActive(final @NonNull UseCase useCase) {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.onUseCaseActive(useCase);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use case " + useCase + " ACTIVE for camera " + this.mCameraId));
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            this.reattachUseCaseSurfaces(useCase);
            this.mUseCaseAttachState.setUseCaseActive(useCase);
            this.mUseCaseAttachState.updateUseCase(useCase);
        }
        this.updateCaptureSessionConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUseCaseInactive(final @NonNull UseCase useCase) {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.onUseCaseInactive(useCase);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use case " + useCase + " INACTIVE for camera " + this.mCameraId));
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            this.mUseCaseAttachState.setUseCaseInactive(useCase);
        }
        this.updateCaptureSessionConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUseCaseUpdated(final @NonNull UseCase useCase) {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.onUseCaseUpdated(useCase);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use case " + useCase + " UPDATED for camera " + this.mCameraId));
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            this.reattachUseCaseSurfaces(useCase);
            this.mUseCaseAttachState.updateUseCase(useCase);
        }
        this.updateCaptureSessionConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUseCaseReset(final @NonNull UseCase useCase) {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.onUseCaseReset(useCase);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use case " + useCase + " RESET for camera " + this.mCameraId));
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            this.reattachUseCaseSurfaces(useCase);
            this.mUseCaseAttachState.updateUseCase(useCase);
        }
        this.resetCaptureSession(false);
        this.updateCaptureSessionConfig();
        this.openCaptureSession();
    }

    @GuardedBy(value="mAttachedUseCaseLock")
    private void reattachUseCaseSurfaces(UseCase useCase) {
        if (!this.isUseCaseOnline(useCase)) {
            return;
        }
        SessionConfig sessionConfig = this.mUseCaseAttachState.getUseCaseSessionConfig(useCase);
        SessionConfig newSessionConfig = useCase.getSessionConfig(this.mCameraId);
        List currentSurfaces = sessionConfig.getSurfaces();
        List newSurfaces = newSessionConfig.getSurfaces();
        for (DeferrableSurface newSurface : newSurfaces) {
            if (currentSurfaces.contains(newSurface)) continue;
            newSurface.notifySurfaceAttached();
        }
        for (DeferrableSurface currentSurface : currentSurfaces) {
            if (newSurfaces.contains(currentSurface)) continue;
            currentSurface.notifySurfaceDetached();
        }
    }

    private void notifyAttachToUseCaseSurfaces(UseCase useCase) {
        for (DeferrableSurface surface : useCase.getSessionConfig(this.mCameraId).getSurfaces()) {
            surface.notifySurfaceAttached();
        }
    }

    private void notifyDetachFromUseCaseSurfaces(UseCase useCase) {
        for (DeferrableSurface surface : useCase.getSessionConfig(this.mCameraId).getSurfaces()) {
            surface.notifySurfaceDetached();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUseCaseOnline(UseCase useCase) {
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            return this.mUseCaseAttachState.isUseCaseOnline(useCase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnlineUseCase(final @NonNull Collection<UseCase> useCases) {
        if (useCases.isEmpty()) {
            return;
        }
        Object object = this.mPendingLock;
        synchronized (object) {
            for (UseCase useCase : useCases) {
                boolean isOnline = this.isUseCaseOnline(useCase);
                if (this.mPendingForAddOnline.contains(useCase) || isOnline) continue;
                this.notifyAttachToUseCaseSurfaces(useCase);
                this.mPendingForAddOnline.add(useCase);
            }
        }
        this.mCameraControlInternal.setActive(true);
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.addOnlineUseCase(useCases);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use cases " + useCases + " ONLINE for camera " + this.mCameraId));
        ArrayList<UseCase> useCasesChangedToOnline = new ArrayList<UseCase>();
        Object object2 = this.mAttachedUseCaseLock;
        synchronized (object2) {
            for (UseCase useCase : useCases) {
                if (this.isUseCaseOnline(useCase)) continue;
                this.mUseCaseAttachState.setUseCaseOnline(useCase);
                useCasesChangedToOnline.add(useCase);
            }
        }
        object2 = this.mPendingLock;
        synchronized (object2) {
            this.mPendingForAddOnline.removeAll(useCases);
        }
        this.notifyStateOnlineToUseCases(useCasesChangedToOnline);
        this.updateCaptureSessionConfig();
        this.resetCaptureSession(false);
        if (this.mState == InternalState.OPENED) {
            this.openCaptureSession();
        } else {
            this.open();
        }
        this.updateCameraControlPreviewAspectRatio(useCases);
    }

    private void notifyStateOnlineToUseCases(List<UseCase> useCases) {
        CameraXExecutors.mainThreadExecutor().execute(() -> {
            for (UseCase useCase : useCases) {
                useCase.onStateOnline(this.mCameraId);
            }
        });
    }

    private void notifyStateOfflineToUseCases(List<UseCase> useCases) {
        CameraXExecutors.mainThreadExecutor().execute(() -> {
            for (UseCase useCase : useCases) {
                useCase.onStateOffline(this.mCameraId);
            }
        });
    }

    private void updateCameraControlPreviewAspectRatio(Collection<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            if (!(useCase instanceof Preview)) continue;
            Size resolutoin = useCase.getAttachedSurfaceResolution(this.mCameraId);
            Rational aspectRatio = new Rational(resolutoin.getWidth(), resolutoin.getHeight());
            this.mCameraControlInternal.setPreviewAspectRatio(aspectRatio);
            return;
        }
    }

    private void clearCameraControlPreviewAspectRatio(Collection<UseCase> removedUseCases) {
        for (UseCase useCase : removedUseCases) {
            if (!(useCase instanceof Preview)) continue;
            this.mCameraControlInternal.setPreviewAspectRatio(null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnlineUseCase(final @NonNull Collection<UseCase> useCases) {
        if (useCases.isEmpty()) {
            return;
        }
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.removeOnlineUseCase(useCases);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use cases " + useCases + " OFFLINE for camera " + this.mCameraId));
        this.clearCameraControlPreviewAspectRatio(useCases);
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            ArrayList<UseCase> useCasesChangedToOffline = new ArrayList<UseCase>();
            for (UseCase useCase : useCases) {
                if (this.mUseCaseAttachState.isUseCaseOnline(useCase)) {
                    useCasesChangedToOffline.add(useCase);
                }
                this.mUseCaseAttachState.setUseCaseOffline(useCase);
            }
            for (UseCase detach : useCasesChangedToOffline) {
                this.notifyDetachFromUseCaseSurfaces(detach);
            }
            this.notifyStateOfflineToUseCases(useCasesChangedToOffline);
            if (this.mUseCaseAttachState.getOnlineUseCases().isEmpty()) {
                this.mCameraControlInternal.setActive(false);
                this.resetCaptureSession(false);
                this.close();
                return;
            }
        }
        this.updateCaptureSessionConfig();
        this.resetCaptureSession(false);
        if (this.mState == InternalState.OPENED) {
            this.openCaptureSession();
        }
    }

    @NonNull
    public CameraInfoInternal getCameraInfoInternal() {
        return this.mCameraInfoInternal;
    }

    @SuppressLint(value={"MissingPermission"})
    void openCameraDevice() {
        if (!this.mCameraAvailability.isCameraAvailable()) {
            Log.d((String)TAG, (String)("No cameras available. Waiting for available camera before opening camera: " + this.mCameraId));
            this.setState(InternalState.PENDING_OPEN);
            return;
        }
        this.setState(InternalState.OPENING);
        Log.d((String)TAG, (String)("Opening camera: " + this.mCameraId));
        try {
            this.mCameraManager.openCamera(this.mCameraId, this.mExecutor, this.createDeviceStateCallback());
        }
        catch (CameraAccessException e) {
            Log.d((String)TAG, (String)("Unable to open camera " + this.mCameraId + " due to " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCaptureSessionConfig() {
        SessionConfig.ValidatingBuilder validatingBuilder;
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            validatingBuilder = this.mUseCaseAttachState.getActiveAndOnlineBuilder();
        }
        if (validatingBuilder.isValid()) {
            validatingBuilder.add(this.mCameraControlSessionConfig);
            SessionConfig sessionConfig = validatingBuilder.build();
            this.mCaptureSession.setSessionConfig(sessionConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openCaptureSession() {
        SessionConfig.ValidatingBuilder validatingBuilder;
        Preconditions.checkState((this.mState == InternalState.OPENED ? 1 : 0) != 0);
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            validatingBuilder = this.mUseCaseAttachState.getOnlineBuilder();
        }
        if (!validatingBuilder.isValid()) {
            Log.d((String)TAG, (String)"Unable to create capture session due to conflicting configurations");
            return;
        }
        try {
            this.mCaptureSession.open(validatingBuilder.build(), this.mCameraDevice);
        }
        catch (CameraAccessException e) {
            Log.d((String)TAG, (String)("Unable to configure camera " + this.mCameraId + " due to " + e.getMessage()));
        }
        catch (DeferrableSurface.SurfaceClosedException e) {
            this.postSurfaceClosedError(e);
        }
    }

    void postSurfaceClosedError(DeferrableSurface.SurfaceClosedException e) {
        ScheduledExecutorService executor = CameraXExecutors.mainThreadExecutor();
        for (UseCase useCase : this.mUseCaseAttachState.getOnlineUseCases()) {
            List errorListeners;
            final SessionConfig sessionConfigError = useCase.getSessionConfig(this.mCameraId);
            if (!sessionConfigError.getSurfaces().contains(e.getDeferrableSurface()) || (errorListeners = sessionConfigError.getErrorListeners()).isEmpty()) continue;
            final SessionConfig.ErrorListener errorListener = (SessionConfig.ErrorListener)errorListeners.get(0);
            Log.d((String)TAG, (String)"Posting surface closed", (Throwable)new Throwable());
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    errorListener.onError(sessionConfigError, SessionConfig.SessionError.SESSION_ERROR_SURFACE_NEEDS_RESET);
                }
            });
            break;
        }
    }

    @WorkerThread
    void resetCaptureSession(boolean abortInFlightCaptures) {
        Preconditions.checkState((this.mCaptureSession != null ? 1 : 0) != 0);
        Log.d((String)TAG, (String)"Resetting Capture Session");
        CaptureSession oldCaptureSession = this.mCaptureSession;
        SessionConfig previousSessionConfig = oldCaptureSession.getSessionConfig();
        List<CaptureConfig> unissuedCaptureConfigs = oldCaptureSession.getCaptureConfigs();
        this.mCaptureSession = this.mCaptureSessionBuilder.build();
        this.mCaptureSession.setSessionConfig(previousSessionConfig);
        this.mCaptureSession.issueCaptureRequests(unissuedCaptureConfigs);
        this.releaseSession(oldCaptureSession, abortInFlightCaptures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CameraDevice.StateCallback createDeviceStateCallback() {
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            SessionConfig config = this.mUseCaseAttachState.getOnlineBuilder().build();
            List configuredStateCallbacks = config.getDeviceStateCallbacks();
            ArrayList<StateCallback> allStateCallbacks = new ArrayList<StateCallback>(configuredStateCallbacks);
            allStateCallbacks.add(this.mStateCallback);
            return CameraDeviceStateCallbacks.createComboCallback(allStateCallbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndAttachRepeatingSurface(CaptureConfig.Builder captureConfigBuilder) {
        Collection activeUseCases;
        if (!captureConfigBuilder.getSurfaces().isEmpty()) {
            Log.w((String)TAG, (String)"The capture config builder already has surface inside.");
            return false;
        }
        Iterator iterator = this.mAttachedUseCaseLock;
        synchronized (iterator) {
            activeUseCases = this.mUseCaseAttachState.getActiveAndOnlineUseCases();
        }
        for (UseCase useCase : activeUseCases) {
            SessionConfig sessionConfig = useCase.getSessionConfig(this.mCameraId);
            List surfaces = sessionConfig.getRepeatingCaptureConfig().getSurfaces();
            if (surfaces.isEmpty()) continue;
            for (DeferrableSurface surface : surfaces) {
                captureConfigBuilder.addSurface(surface);
            }
        }
        if (captureConfigBuilder.getSurfaces().isEmpty()) {
            Log.w((String)TAG, (String)"Unable to find a repeating surface to attach to CaptureConfig");
            return false;
        }
        return true;
    }

    @NonNull
    public CameraControlInternal getCameraControlInternal() {
        return this.mCameraControlInternal;
    }

    void submitCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
        ArrayList<CaptureConfig> captureConfigsWithSurface = new ArrayList<CaptureConfig>();
        for (CaptureConfig captureConfig : captureConfigs) {
            CaptureConfig.Builder builder = CaptureConfig.Builder.from((CaptureConfig)captureConfig);
            if (captureConfig.getSurfaces().isEmpty() && captureConfig.isUseRepeatingSurface() && !this.checkAndAttachRepeatingSurface(builder)) continue;
            captureConfigsWithSurface.add(builder.build());
        }
        Log.d((String)TAG, (String)("issue capture request for camera " + this.mCameraId));
        this.mCaptureSession.issueCaptureRequests(captureConfigsWithSurface);
    }

    @NonNull
    public String toString() {
        return String.format(Locale.US, "Camera@%x[id=%s]", this.hashCode(), this.mCameraId);
    }

    @NonNull
    public CameraControl getCameraControl() {
        return this.getCameraControlInternal();
    }

    @NonNull
    public CameraInfo getCameraInfo() {
        return this.getCameraInfoInternal();
    }

    @WorkerThread
    void setState(InternalState state) {
        Log.d((String)TAG, (String)("Transitioning camera internal state: " + (Object)((Object)this.mState) + " --> " + (Object)((Object)state)));
        this.mState = state;
        switch (state) {
            case INITIALIZED: {
                this.mObservableState.postValue((Object)CameraInternal.State.CLOSED);
                break;
            }
            case PENDING_OPEN: {
                this.mObservableState.postValue((Object)CameraInternal.State.PENDING_OPEN);
                break;
            }
            case OPENING: 
            case REOPENING: {
                this.mObservableState.postValue((Object)CameraInternal.State.OPENING);
                break;
            }
            case OPENED: {
                this.mObservableState.postValue((Object)CameraInternal.State.OPEN);
                break;
            }
            case CLOSING: {
                this.mObservableState.postValue((Object)CameraInternal.State.CLOSING);
                break;
            }
            case RELEASING: {
                this.mObservableState.postValue((Object)CameraInternal.State.RELEASING);
                break;
            }
            case RELEASED: {
                this.mObservableState.postValue((Object)CameraInternal.State.RELEASED);
            }
        }
    }

    String getErrorMessage(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "ERROR_NONE";
            }
            case 4: {
                return "ERROR_CAMERA_DEVICE";
            }
            case 3: {
                return "ERROR_CAMERA_DISABLED";
            }
            case 1: {
                return "ERROR_CAMERA_IN_USE";
            }
            case 5: {
                return "ERROR_CAMERA_SERVICE";
            }
            case 2: {
                return "ERROR_MAX_CAMERAS_IN_USE";
            }
        }
        return "UNKNOWN ERROR";
    }

    final class ControlUpdateListenerInternal
    implements CameraControlInternal.ControlUpdateCallback {
        ControlUpdateListenerInternal() {
        }

        public void onCameraControlUpdateSessionConfig(@NonNull SessionConfig sessionConfig) {
            Camera2CameraImpl.this.mCameraControlSessionConfig = (SessionConfig)Preconditions.checkNotNull((Object)sessionConfig);
            Camera2CameraImpl.this.updateCaptureSessionConfig();
        }

        public void onCameraControlCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
            Camera2CameraImpl.this.submitCaptureRequests((List)Preconditions.checkNotNull(captureConfigs));
        }
    }

    final class CameraAvailability
    extends CameraManager.AvailabilityCallback
    implements Observable.Observer<Integer> {
        private final String mCameraId;
        private boolean mCameraAvailable = true;
        private int mNumAvailableCameras = 0;

        CameraAvailability(String cameraId) {
            this.mCameraId = cameraId;
        }

        public void onCameraAvailable(@NonNull String cameraId) {
            if (!this.mCameraId.equals(cameraId)) {
                return;
            }
            this.mCameraAvailable = true;
            if (Camera2CameraImpl.this.mState == InternalState.PENDING_OPEN) {
                Camera2CameraImpl.this.openCameraDevice();
            }
        }

        public void onCameraUnavailable(@NonNull String cameraId) {
            if (!this.mCameraId.equals(cameraId)) {
                return;
            }
            this.mCameraAvailable = false;
        }

        public void onNewData(@Nullable Integer value) {
            Preconditions.checkNotNull((Object)value);
            if (value != this.mNumAvailableCameras) {
                this.mNumAvailableCameras = value;
                if (Camera2CameraImpl.this.mState == InternalState.PENDING_OPEN) {
                    Camera2CameraImpl.this.openCameraDevice();
                }
            }
        }

        public void onError(@NonNull Throwable t) {
        }

        boolean isCameraAvailable() {
            return this.mCameraAvailable && this.mNumAvailableCameras > 0;
        }
    }

    final class StateCallback
    extends CameraDevice.StateCallback {
        StateCallback() {
        }

        public void onOpened(CameraDevice cameraDevice) {
            Log.d((String)Camera2CameraImpl.TAG, (String)("CameraDevice.onOpened(): " + cameraDevice.getId()));
            Camera2CameraImpl.this.mCameraDevice = cameraDevice;
            Camera2CameraImpl.this.mCameraDeviceError = 0;
            switch (Camera2CameraImpl.this.mState) {
                case CLOSING: 
                case RELEASING: {
                    Preconditions.checkState((boolean)Camera2CameraImpl.this.isSessionCloseComplete());
                    Camera2CameraImpl.this.mCameraDevice.close();
                    Camera2CameraImpl.this.mCameraDevice = null;
                    break;
                }
                case OPENING: 
                case REOPENING: {
                    Camera2CameraImpl.this.setState(InternalState.OPENED);
                    Camera2CameraImpl.this.openCaptureSession();
                    break;
                }
                default: {
                    throw new IllegalStateException("onOpened() should not be possible from state: " + (Object)((Object)Camera2CameraImpl.this.mState));
                }
            }
        }

        public void onClosed(CameraDevice cameraDevice) {
            Log.d((String)Camera2CameraImpl.TAG, (String)("CameraDevice.onClosed(): " + cameraDevice.getId()));
            Preconditions.checkState((Camera2CameraImpl.this.mCameraDevice == null ? 1 : 0) != 0, (String)("Unexpected onClose callback on camera device: " + cameraDevice));
            switch (Camera2CameraImpl.this.mState) {
                case CLOSING: 
                case RELEASING: {
                    Preconditions.checkState((boolean)Camera2CameraImpl.this.isSessionCloseComplete());
                    Camera2CameraImpl.this.finishClose();
                    break;
                }
                case REOPENING: {
                    Camera2CameraImpl.this.openCameraDevice();
                    break;
                }
                default: {
                    throw new IllegalStateException("Camera closed while in state: " + (Object)((Object)Camera2CameraImpl.this.mState));
                }
            }
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            Log.d((String)Camera2CameraImpl.TAG, (String)("CameraDevice.onDisconnected(): " + cameraDevice.getId()));
            for (CaptureSession captureSession : Camera2CameraImpl.this.mReleasedCaptureSessions.keySet()) {
                captureSession.forceClose();
            }
            Camera2CameraImpl.this.mCaptureSession.forceClose();
            this.onError(cameraDevice, 1);
        }

        public void onError(@NonNull CameraDevice cameraDevice, int error) {
            Camera2CameraImpl.this.mCameraDevice = cameraDevice;
            Camera2CameraImpl.this.mCameraDeviceError = error;
            switch (Camera2CameraImpl.this.mState) {
                case CLOSING: 
                case RELEASING: {
                    Log.e((String)Camera2CameraImpl.TAG, (String)("CameraDevice.onError(): " + cameraDevice.getId() + " with error: " + Camera2CameraImpl.this.getErrorMessage(error)));
                    Camera2CameraImpl.this.closeCamera(false);
                    break;
                }
                case OPENED: 
                case OPENING: 
                case REOPENING: {
                    this.handleErrorOnOpen(cameraDevice, error);
                    break;
                }
                default: {
                    throw new IllegalStateException("onError() should not be possible from state: " + (Object)((Object)Camera2CameraImpl.this.mState));
                }
            }
        }

        private void handleErrorOnOpen(@NonNull CameraDevice cameraDevice, int error) {
            Preconditions.checkState((Camera2CameraImpl.this.mState == InternalState.OPENING || Camera2CameraImpl.this.mState == InternalState.OPENED || Camera2CameraImpl.this.mState == InternalState.REOPENING ? 1 : 0) != 0, (String)("Attempt to handle open error from non open state: " + (Object)((Object)Camera2CameraImpl.this.mState)));
            switch (error) {
                case 1: 
                case 2: 
                case 4: {
                    this.reopenCameraAfterError();
                    break;
                }
                default: {
                    Log.e((String)Camera2CameraImpl.TAG, (String)("Error observed on open (or opening) camera device " + cameraDevice.getId() + ": " + Camera2CameraImpl.this.getErrorMessage(error)));
                    Camera2CameraImpl.this.setState(InternalState.CLOSING);
                    Camera2CameraImpl.this.closeCamera(false);
                }
            }
        }

        private void reopenCameraAfterError() {
            Preconditions.checkState((Camera2CameraImpl.this.mCameraDeviceError != 0 ? 1 : 0) != 0, (String)"Can only reopen camera device after error if the camera device is actually in an error state.");
            Camera2CameraImpl.this.setState(InternalState.REOPENING);
            Camera2CameraImpl.this.closeCamera(false);
        }
    }

    static enum InternalState {
        INITIALIZED,
        PENDING_OPEN,
        OPENING,
        OPENED,
        CLOSING,
        REOPENING,
        RELEASING,
        RELEASED;

    }
}

