/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.hardware.camera2.CameraCharacteristics;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.impl.TorchControl;
import androidx.camera.camera2.impl.ZoomControl;
import androidx.camera.core.CameraInfoInternal;
import androidx.camera.core.CameraOrientationUtil;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LiveData;

final class Camera2CameraInfo
implements CameraInfoInternal {
    private static final String TAG = "Camera2CameraInfo";
    private final CameraCharacteristics mCameraCharacteristics;
    private final ZoomControl mZoomControl;
    private final TorchControl mTorchControl;

    Camera2CameraInfo(@NonNull CameraCharacteristics cameraCharacteristics, @NonNull ZoomControl zoomControl, @NonNull TorchControl torchControl) {
        Preconditions.checkNotNull((Object)cameraCharacteristics, (Object)"Camera characteristics map is missing");
        this.mCameraCharacteristics = cameraCharacteristics;
        this.mZoomControl = zoomControl;
        this.mTorchControl = torchControl;
        this.logDeviceInfo();
    }

    @Nullable
    public Integer getLensFacing() {
        Integer lensFacing = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        Preconditions.checkNotNull((Object)lensFacing);
        switch (lensFacing) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return null;
    }

    public int getSensorRotationDegrees(int relativeRotation) {
        Integer sensorOrientation = this.getSensorOrientation();
        int relativeRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees((int)relativeRotation);
        Integer lensFacing = this.getLensFacing();
        boolean isOppositeFacingScreen = lensFacing != null && 1 == lensFacing;
        return CameraOrientationUtil.getRelativeImageRotation((int)relativeRotationDegrees, (int)sensorOrientation, (boolean)isOppositeFacingScreen);
    }

    int getSensorOrientation() {
        Integer sensorOrientation = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        Preconditions.checkNotNull((Object)sensorOrientation);
        return sensorOrientation;
    }

    int getSupportedHardwareLevel() {
        Integer deviceLevel = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        Preconditions.checkNotNull((Object)deviceLevel);
        return deviceLevel;
    }

    public int getSensorRotationDegrees() {
        return this.getSensorRotationDegrees(0);
    }

    private void logDeviceInfo() {
        this.logDeviceLevel();
    }

    private void logDeviceLevel() {
        String levelString;
        int deviceLevel = this.getSupportedHardwareLevel();
        switch (deviceLevel) {
            case 2: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_LEGACY";
                break;
            }
            case 4: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_EXTERNAL";
                break;
            }
            case 0: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_LIMITED";
                break;
            }
            case 1: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_FULL";
                break;
            }
            case 3: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_3";
                break;
            }
            default: {
                levelString = "Unknown value: " + deviceLevel;
            }
        }
        Log.i((String)TAG, (String)("Device Level: " + levelString));
    }

    public boolean hasFlashUnit() {
        Boolean hasFlashUnit = (Boolean)this.mCameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        Preconditions.checkNotNull((Object)hasFlashUnit);
        return hasFlashUnit;
    }

    @NonNull
    public LiveData<Integer> getTorchState() {
        return this.mTorchControl.getTorchState();
    }

    @NonNull
    public LiveData<Float> getZoomRatio() {
        return this.mZoomControl.getZoomRatio();
    }

    @NonNull
    public LiveData<Float> getMaxZoomRatio() {
        return this.mZoomControl.getMaxZoomRatio();
    }

    @NonNull
    public LiveData<Float> getMinZoomRatio() {
        return this.mZoomControl.getMinZoomRatio();
    }

    @NonNull
    public LiveData<Float> getLinearZoom() {
        return this.mZoomControl.getLinearZoom();
    }
}

