/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Camera2CaptureCallbacks {
    private Camera2CaptureCallbacks() {
    }

    @NonNull
    public static CameraCaptureSession.CaptureCallback createNoOpCallback() {
        return new NoOpSessionCaptureCallback();
    }

    static CameraCaptureSession.CaptureCallback createComboCallback(List<CameraCaptureSession.CaptureCallback> callbacks) {
        return new ComboSessionCaptureCallback(callbacks);
    }

    @NonNull
    public static CameraCaptureSession.CaptureCallback createComboCallback(CameraCaptureSession.CaptureCallback ... callbacks) {
        return Camera2CaptureCallbacks.createComboCallback(Arrays.asList(callbacks));
    }

    private static final class ComboSessionCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        private final List<CameraCaptureSession.CaptureCallback> mCallbacks = new ArrayList<CameraCaptureSession.CaptureCallback>();

        ComboSessionCaptureCallback(List<CameraCaptureSession.CaptureCallback> callbacks) {
            for (CameraCaptureSession.CaptureCallback callback : callbacks) {
                if (callback instanceof NoOpSessionCaptureCallback) continue;
                this.mCallbacks.add(callback);
            }
        }

        @RequiresApi(api=24)
        public void onCaptureBufferLost(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull Surface surface, long frame) {
            for (CameraCaptureSession.CaptureCallback callback : this.mCallbacks) {
                callback.onCaptureBufferLost(session, request, surface, frame);
            }
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            for (CameraCaptureSession.CaptureCallback callback : this.mCallbacks) {
                callback.onCaptureCompleted(session, request, result);
            }
        }

        public void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
            for (CameraCaptureSession.CaptureCallback callback : this.mCallbacks) {
                callback.onCaptureFailed(session, request, failure);
            }
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            for (CameraCaptureSession.CaptureCallback callback : this.mCallbacks) {
                callback.onCaptureProgressed(session, request, partialResult);
            }
        }

        public void onCaptureSequenceAborted(@NonNull CameraCaptureSession session, int sequenceId) {
            for (CameraCaptureSession.CaptureCallback callback : this.mCallbacks) {
                callback.onCaptureSequenceAborted(session, sequenceId);
            }
        }

        public void onCaptureSequenceCompleted(@NonNull CameraCaptureSession session, int sequenceId, long frame) {
            for (CameraCaptureSession.CaptureCallback callback : this.mCallbacks) {
                callback.onCaptureSequenceCompleted(session, sequenceId, frame);
            }
        }

        public void onCaptureStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frame) {
            for (CameraCaptureSession.CaptureCallback callback : this.mCallbacks) {
                callback.onCaptureStarted(session, request, timestamp, frame);
            }
        }
    }

    static final class NoOpSessionCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        NoOpSessionCaptureCallback() {
        }

        public void onCaptureBufferLost(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull Surface surface, long frame) {
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        }

        public void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
        }

        public void onCaptureSequenceAborted(@NonNull CameraCaptureSession session, int sequenceId) {
        }

        public void onCaptureSequenceCompleted(@NonNull CameraCaptureSession session, int sequenceId, long frame) {
        }

        public void onCaptureStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frame) {
        }
    }
}

