/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.Config;
import androidx.camera.core.DeferrableSurface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Camera2CaptureRequestBuilder {
    private static final String TAG = "CaptureRequestBuilder";

    private Camera2CaptureRequestBuilder() {
    }

    @NonNull
    private static List<Surface> getConfiguredSurfaces(List<DeferrableSurface> deferrableSurfaces, Map<DeferrableSurface, Surface> configuredSurfaceMap) {
        ArrayList<Surface> surfaceList = new ArrayList<Surface>();
        for (DeferrableSurface deferrableSurface : deferrableSurfaces) {
            Surface surface = configuredSurfaceMap.get(deferrableSurface);
            if (surface == null) {
                throw new IllegalArgumentException("DeferrableSurface not in configuredSurfaceMap");
            }
            surfaceList.add(surface);
        }
        return surfaceList;
    }

    private static void applyImplementationOptionToCaptureBuilder(CaptureRequest.Builder builder, Config config) {
        Camera2ImplConfig camera2Config = new Camera2ImplConfig(config);
        Iterator<Config.Option<?>> iterator = camera2Config.getCaptureRequestOptions().iterator();
        while (iterator.hasNext()) {
            Config.Option<?> option;
            Config.Option<?> typeErasedOption = option = iterator.next();
            CaptureRequest.Key key = (CaptureRequest.Key)option.getToken();
            try {
                builder.set(key, camera2Config.retrieveOption(typeErasedOption));
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)("CaptureRequest.Key is not supported: " + key));
            }
        }
    }

    @Nullable
    public static CaptureRequest build(@NonNull CaptureConfig captureConfig, @Nullable CameraDevice device, @NonNull Map<DeferrableSurface, Surface> configuredSurfaceMap) throws CameraAccessException {
        if (device == null) {
            return null;
        }
        List<Surface> surfaceList = Camera2CaptureRequestBuilder.getConfiguredSurfaces(captureConfig.getSurfaces(), configuredSurfaceMap);
        if (surfaceList.isEmpty()) {
            return null;
        }
        CaptureRequest.Builder builder = device.createCaptureRequest(captureConfig.getTemplateType());
        Camera2CaptureRequestBuilder.applyImplementationOptionToCaptureBuilder(builder, captureConfig.getImplementationOptions());
        for (Surface surface : surfaceList) {
            builder.addTarget(surface);
        }
        builder.setTag(captureConfig.getTag());
        return builder.build();
    }

    @Nullable
    public static CaptureRequest buildWithoutTarget(@NonNull CaptureConfig captureConfig, @Nullable CameraDevice device) throws CameraAccessException {
        if (device == null) {
            return null;
        }
        CaptureRequest.Builder builder = device.createCaptureRequest(captureConfig.getTemplateType());
        Camera2CaptureRequestBuilder.applyImplementationOptionToCaptureBuilder(builder, captureConfig.getImplementationOptions());
        return builder.build();
    }
}

