/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraManager;
import android.media.CamcorderProfile;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.impl.CamcorderProfileHelper;
import androidx.camera.camera2.impl.SupportedSurfaceCombination;
import androidx.camera.camera2.impl.UseCaseSurfaceOccupancyManager;
import androidx.camera.core.CameraDeviceConfig;
import androidx.camera.core.CameraDeviceSurfaceManager;
import androidx.camera.core.CameraX;
import androidx.camera.core.SurfaceConfig;
import androidx.camera.core.UseCase;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class Camera2DeviceSurfaceManager
implements CameraDeviceSurfaceManager {
    private static final String TAG = "Camera2DeviceSurfaceManager";
    private static final Size MAXIMUM_PREVIEW_SIZE = new Size(1920, 1080);
    private final Map<String, SupportedSurfaceCombination> mCameraSupportedSurfaceCombinationMap = new HashMap<String, SupportedSurfaceCombination>();
    private final Context mContext;
    private final CamcorderProfileHelper mCamcorderProfileHelper;
    private boolean mIsInitialized = false;

    public Camera2DeviceSurfaceManager(@NonNull Context context) {
        this(context, new CamcorderProfileHelper(){

            @Override
            public boolean hasProfile(int cameraId, int quality) {
                return CamcorderProfile.hasProfile((int)cameraId, (int)quality);
            }
        });
    }

    @VisibleForTesting
    Camera2DeviceSurfaceManager(@NonNull Context context, @NonNull CamcorderProfileHelper camcorderProfileHelper) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)camcorderProfileHelper);
        this.mContext = context.getApplicationContext();
        this.mCamcorderProfileHelper = camcorderProfileHelper;
    }

    public void init() {
        if (!this.mIsInitialized) {
            CameraManager cameraManager = (CameraManager)this.mContext.getSystemService("camera");
            try {
                for (String cameraId : cameraManager.getCameraIdList()) {
                    this.mCameraSupportedSurfaceCombinationMap.put(cameraId, new SupportedSurfaceCombination(this.mContext, cameraId, this.mCamcorderProfileHelper));
                }
            }
            catch (CameraAccessException e) {
                throw new IllegalArgumentException("Fail to get camera id list", e);
            }
            this.mIsInitialized = true;
        }
    }

    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public boolean checkSupported(@NonNull String cameraId, @Nullable List<SurfaceConfig> surfaceConfigList) {
        this.checkInitialized();
        if (surfaceConfigList == null || surfaceConfigList.isEmpty()) {
            return true;
        }
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        boolean isSupported = false;
        if (supportedSurfaceCombination != null) {
            isSupported = supportedSurfaceCombination.checkSupported(surfaceConfigList);
        }
        return isSupported;
    }

    @Nullable
    public SurfaceConfig transformSurfaceConfig(@NonNull String cameraId, int imageFormat, @NonNull Size size) {
        this.checkInitialized();
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        SurfaceConfig surfaceConfig = null;
        if (supportedSurfaceCombination != null) {
            surfaceConfig = supportedSurfaceCombination.transformSurfaceConfig(imageFormat, size);
        }
        return surfaceConfig;
    }

    @NonNull
    public Map<UseCase, Size> getSuggestedResolutions(@NonNull String cameraId, @Nullable List<UseCase> originalUseCases, @NonNull List<UseCase> newUseCases) {
        this.checkInitialized();
        Preconditions.checkNotNull(newUseCases, (Object)"No new use cases to be bound.");
        Preconditions.checkArgument((!newUseCases.isEmpty() ? 1 : 0) != 0, (Object)"No new use cases to be bound.");
        UseCaseSurfaceOccupancyManager.checkUseCaseLimitNotExceeded(originalUseCases, newUseCases);
        ArrayList<SurfaceConfig> surfaceConfigs = new ArrayList<SurfaceConfig>();
        if (originalUseCases != null) {
            for (UseCase useCase : originalUseCases) {
                CameraDeviceConfig deviceConfig = (CameraDeviceConfig)Preconditions.checkNotNull((Object)useCase.getBoundDeviceConfig());
                String useCaseCameraId = this.getCameraIdFromConfig(deviceConfig);
                Size resolution = useCase.getAttachedSurfaceResolution(useCaseCameraId);
                surfaceConfigs.add(this.transformSurfaceConfig(cameraId, useCase.getImageFormat(), resolution));
            }
        }
        for (UseCase useCase : newUseCases) {
            surfaceConfigs.add(this.transformSurfaceConfig(cameraId, useCase.getImageFormat(), new Size(640, 480)));
        }
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination == null || !supportedSurfaceCombination.checkSupported(surfaceConfigs)) {
            throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + cameraId + ".  May be attempting to bind too many use cases.");
        }
        return supportedSurfaceCombination.getSuggestedResolutions(originalUseCases, newUseCases);
    }

    @NonNull
    public Size getMaxOutputSize(@NonNull String cameraId, int imageFormat) {
        this.checkInitialized();
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination == null) {
            throw new IllegalArgumentException("Fail to find supported surface info - CameraId:" + cameraId);
        }
        return supportedSurfaceCombination.getMaxOutputSizeByFormat(imageFormat);
    }

    @NonNull
    public Size getPreviewSize() {
        this.checkInitialized();
        Size previewSize = MAXIMUM_PREVIEW_SIZE;
        if (!this.mCameraSupportedSurfaceCombinationMap.isEmpty()) {
            String cameraId = (String)this.mCameraSupportedSurfaceCombinationMap.keySet().toArray()[0];
            previewSize = this.mCameraSupportedSurfaceCombinationMap.get(cameraId).getSurfaceSizeDefinition().getPreviewSize();
        }
        return previewSize;
    }

    public boolean requiresCorrectedAspectRatio(@NonNull CameraDeviceConfig useCaseConfig) {
        this.checkInitialized();
        String cameraId = this.getCameraIdFromConfig(useCaseConfig);
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination == null) {
            throw new IllegalArgumentException("Fail to find supported surface info - CameraId:" + cameraId);
        }
        return supportedSurfaceCombination.requiresCorrectedAspectRatio();
    }

    @Nullable
    public Rational getCorrectedAspectRatio(@NonNull CameraDeviceConfig deviceConfig, int rotation) {
        this.checkInitialized();
        String cameraId = this.getCameraIdFromConfig(deviceConfig);
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination == null) {
            throw new IllegalArgumentException("Fail to find supported surface info - CameraId:" + cameraId);
        }
        return supportedSurfaceCombination.getCorrectedAspectRatio(rotation);
    }

    private String getCameraIdFromConfig(@NonNull CameraDeviceConfig config) {
        String cameraId;
        try {
            Integer lensFacing = config.getLensFacing(null);
            if (lensFacing == null) {
                lensFacing = CameraX.getDefaultLensFacing();
            }
            cameraId = CameraX.getCameraWithLensFacing((int)lensFacing);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to get camera ID from camera device config.", e);
        }
        return cameraId;
    }

    private void checkInitialized() {
        Preconditions.checkState((boolean)this.mIsInitialized, (String)"CameraDeviceSurfaceManager is not initialized.");
    }

    static enum Operation {
        ADD_CONFIG,
        REMOVE_CONFIG;

    }
}

