/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.impl.CameraEventCallbacks;
import androidx.camera.core.Config;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.MutableConfig;
import androidx.camera.core.MutableOptionsBundle;
import androidx.camera.core.OptionsBundle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Camera2ImplConfig
implements Config {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String CAPTURE_REQUEST_ID_STEM = "camera2.captureRequest.option.";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final Config.Option<Integer> TEMPLATE_TYPE_OPTION = Config.Option.create((String)"camera2.captureRequest.templateType", Integer.TYPE);
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final Config.Option<CameraDevice.StateCallback> DEVICE_STATE_CALLBACK_OPTION = Config.Option.create((String)"camera2.cameraDevice.stateCallback", CameraDevice.StateCallback.class);
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final Config.Option<CameraCaptureSession.StateCallback> SESSION_STATE_CALLBACK_OPTION = Config.Option.create((String)"camera2.cameraCaptureSession.stateCallback", CameraCaptureSession.StateCallback.class);
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final Config.Option<CameraCaptureSession.CaptureCallback> SESSION_CAPTURE_CALLBACK_OPTION = Config.Option.create((String)"camera2.cameraCaptureSession.captureCallback", CameraCaptureSession.CaptureCallback.class);
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final Config.Option<CameraEventCallbacks> CAMERA_EVENT_CALLBACK_OPTION = Config.Option.create((String)"camera2.cameraEvent.callback", CameraEventCallbacks.class);
    private final Config mConfig;

    public Camera2ImplConfig(@NonNull Config config) {
        this.mConfig = config;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public static Config.Option<Object> createCaptureRequestOption(@NonNull CaptureRequest.Key<?> key) {
        return Config.Option.create((String)(CAPTURE_REQUEST_ID_STEM + key.getName()), Object.class, key);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public <ValueT> ValueT getCaptureRequestOption(@NonNull CaptureRequest.Key<ValueT> key, @Nullable ValueT valueIfMissing) {
        Config.Option<Object> opt = Camera2ImplConfig.createCaptureRequestOption(key);
        return (ValueT)this.mConfig.retrieveOption(opt, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public Set<Config.Option<?>> getCaptureRequestOptions() {
        final HashSet optionSet = new HashSet();
        this.findOptions(CAPTURE_REQUEST_ID_STEM, new Config.OptionMatcher(){

            public boolean onOptionMatched(Config.Option<?> option) {
                optionSet.add(option);
                return true;
            }
        });
        return optionSet;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getCaptureRequestTemplate(int valueIfMissing) {
        return (Integer)this.mConfig.retrieveOption(TEMPLATE_TYPE_OPTION, (Object)valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CameraDevice.StateCallback getDeviceStateCallback(@Nullable CameraDevice.StateCallback valueIfMissing) {
        return (CameraDevice.StateCallback)this.mConfig.retrieveOption(DEVICE_STATE_CALLBACK_OPTION, (Object)valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CameraCaptureSession.StateCallback getSessionStateCallback(@Nullable CameraCaptureSession.StateCallback valueIfMissing) {
        return (CameraCaptureSession.StateCallback)this.mConfig.retrieveOption(SESSION_STATE_CALLBACK_OPTION, (Object)valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CameraCaptureSession.CaptureCallback getSessionCaptureCallback(@Nullable CameraCaptureSession.CaptureCallback valueIfMissing) {
        return (CameraCaptureSession.CaptureCallback)this.mConfig.retrieveOption(SESSION_CAPTURE_CALLBACK_OPTION, (Object)valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CameraEventCallbacks getCameraEventCallback(@Nullable CameraEventCallbacks valueIfMissing) {
        return (CameraEventCallbacks)((Object)this.mConfig.retrieveOption(CAMERA_EVENT_CALLBACK_OPTION, (Object)valueIfMissing));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean containsOption(@NonNull Config.Option<?> id) {
        return this.mConfig.containsOption(id);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id) {
        return (ValueT)this.mConfig.retrieveOption(id);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id, @Nullable ValueT valueIfMissing) {
        return (ValueT)this.mConfig.retrieveOption(id, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void findOptions(@NonNull String idStem, @NonNull Config.OptionMatcher matcher) {
        this.mConfig.findOptions(idStem, matcher);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Set<Config.Option<?>> listOptions() {
        return this.mConfig.listOptions();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Extender<T> {
        ExtendableBuilder<T> mBaseBuilder;

        public Extender(@NonNull ExtendableBuilder<T> baseBuilder) {
            this.mBaseBuilder = baseBuilder;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Extender<T> setCameraEventCallback(@NonNull CameraEventCallbacks cameraEventCallbacks) {
            this.mBaseBuilder.getMutableConfig().insertOption(CAMERA_EVENT_CALLBACK_OPTION, (Object)cameraEventCallbacks);
            return this;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Builder
    implements ExtendableBuilder<Camera2ImplConfig> {
        private final MutableOptionsBundle mMutableOptionsBundle = MutableOptionsBundle.create();

        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableOptionsBundle;
        }

        @NonNull
        public <ValueT> Builder setCaptureRequestOption(@NonNull CaptureRequest.Key<ValueT> key, @NonNull ValueT value) {
            Config.Option<Object> opt = Camera2ImplConfig.createCaptureRequestOption(key);
            this.mMutableOptionsBundle.insertOption(opt, value);
            return this;
        }

        @NonNull
        public Builder insertAllOptions(@NonNull Config config) {
            Iterator iterator = config.listOptions().iterator();
            while (iterator.hasNext()) {
                Config.Option option;
                Config.Option objectOpt = option = (Config.Option)iterator.next();
                this.mMutableOptionsBundle.insertOption(objectOpt, config.retrieveOption(objectOpt));
            }
            return this;
        }

        @NonNull
        public Camera2ImplConfig build() {
            return new Camera2ImplConfig((Config)OptionsBundle.from((Config)this.mMutableOptionsBundle));
        }
    }
}

