/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.camera.core.CameraInternal;
import androidx.camera.core.Observable;
import androidx.camera.core.impl.LiveDataObservable;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

final class CameraAvailabilityRegistry {
    private static final boolean DEBUG = false;
    private StringBuilder mDebugString = null;
    private static final String TAG = "AvailabilityRegistry";
    final int mMaxAllowedOpenedCameras;
    private final Executor mExecutor;
    private final LiveDataObservable<Integer> mAvailableCameras;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private final Map<CameraInternal, CameraInternal.State> mCameraStates = new HashMap<CameraInternal, CameraInternal.State>();

    CameraAvailabilityRegistry(int maxAllowedOpenedCameras, @NonNull Executor executor) {
        this.mMaxAllowedOpenedCameras = maxAllowedOpenedCameras;
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mAvailableCameras = new LiveDataObservable();
        this.mAvailableCameras.postValue((Object)maxAllowedOpenedCameras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerCamera(final @NonNull CameraInternal cameraInternal) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mCameraStates.containsKey(cameraInternal)) {
                this.mCameraStates.put(cameraInternal, null);
                cameraInternal.getCameraState().addObserver(this.mExecutor, (Observable.Observer)new Observable.Observer<CameraInternal.State>(){

                    public void onNewData(@Nullable CameraInternal.State state) {
                        if (state == CameraInternal.State.RELEASED) {
                            CameraAvailabilityRegistry.this.unregisterCamera(cameraInternal, this);
                        } else {
                            CameraAvailabilityRegistry.this.updateState(cameraInternal, state);
                        }
                    }

                    public void onError(@NonNull Throwable t) {
                    }
                });
            }
        }
    }

    Observable<Integer> getAvailableCameraCount() {
        return this.mAvailableCameras;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void unregisterCamera(CameraInternal cameraInternal, Observable.Observer<CameraInternal.State> observer) {
        int availableCameras;
        Object object = this.mLock;
        synchronized (object) {
            cameraInternal.getCameraState().removeObserver(observer);
            if (this.mCameraStates.remove(cameraInternal) == null) {
                return;
            }
            availableCameras = this.recalculateAvailableCameras();
        }
        this.mAvailableCameras.postValue((Object)availableCameras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void updateState(CameraInternal cameraInternal, CameraInternal.State state) {
        int availableCameras;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mCameraStates.containsKey(cameraInternal) || this.mCameraStates.put(cameraInternal, state) == state) {
                return;
            }
            availableCameras = this.recalculateAvailableCameras();
        }
        this.mAvailableCameras.postValue((Object)availableCameras);
    }

    @WorkerThread
    @GuardedBy(value="mLock")
    private int recalculateAvailableCameras() {
        int openCount = 0;
        for (Map.Entry<CameraInternal, CameraInternal.State> entry : this.mCameraStates.entrySet()) {
            if (entry.getValue() == CameraInternal.State.CLOSED || entry.getValue() == CameraInternal.State.OPENING || entry.getValue() == CameraInternal.State.PENDING_OPEN) continue;
            ++openCount;
        }
        return Math.max(this.mMaxAllowedOpenedCameras - openCount, 0);
    }
}

