/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import androidx.annotation.NonNull;
import androidx.camera.camera2.impl.Camera2CameraControl;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.google.common.util.concurrent.ListenableFuture;

final class TorchControl {
    private final Camera2CameraControl mCamera2CameraControl;
    private final MutableLiveData<Integer> mTorchState;

    TorchControl(@NonNull Camera2CameraControl camera2CameraControl) {
        this.mCamera2CameraControl = camera2CameraControl;
        this.mTorchState = new MutableLiveData((Object)0);
    }

    ListenableFuture<Void> enableTorch(boolean enabled) {
        this.setLiveDataValue(this.mTorchState, enabled ? 1 : 0);
        return Futures.immediateFuture(null);
    }

    @NonNull
    LiveData<Integer> getTorchState() {
        return this.mTorchState;
    }

    private <T> void setLiveDataValue(@NonNull MutableLiveData<T> liveData, T value) {
        if (Threads.isMainThread()) {
            liveData.setValue(value);
        } else {
            liveData.postValue(value);
        }
    }
}

