/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.os.Looper;
import androidx.annotation.FloatRange;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.camera.camera2.impl.Camera2CameraControl;
import androidx.camera.core.CameraControl;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.math.MathUtils;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.google.common.util.concurrent.ListenableFuture;

final class ZoomControl {
    private static final String TAG = "ZoomControl";
    public static final float DEFAULT_ZOOM_RATIO = 1.0f;
    public static final float MIN_ZOOM = 1.0f;
    private final Camera2CameraControl mCamera2CameraControl;
    private final CameraCharacteristics mCameraCharacteristics;
    private final MutableLiveData<Float> mZoomRatioLiveData;
    private final MutableLiveData<Float> mMaxZoomRatioLiveData;
    private final MutableLiveData<Float> mMinZoomRatioLiveData;
    private final MutableLiveData<Float> mLinearZoomLiveData;
    final Object mCompleterLock = new Object();
    @GuardedBy(value="mCompleterLock")
    CallbackToFutureAdapter.Completer<Void> mPendingZoomRatioCompleter;
    @GuardedBy(value="mCompleterLock")
    Rect mPendingZoomCropRegion = null;
    final Object mActiveLock = new Object();
    @GuardedBy(value="mActiveLock")
    private boolean mIsActive = false;
    private Camera2CameraControl.CaptureResultListener mCaptureResultListener = new Camera2CameraControl.CaptureResultListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public boolean onCaptureResult(@NonNull TotalCaptureResult captureResult) {
            CallbackToFutureAdapter.Completer<Void> completerToSet = null;
            Object object = ZoomControl.this.mCompleterLock;
            synchronized (object) {
                if (ZoomControl.this.mPendingZoomRatioCompleter != null) {
                    Rect cropRect;
                    CaptureRequest request = captureResult.getRequest();
                    Rect rect = cropRect = request == null ? null : (Rect)request.get(CaptureRequest.SCALER_CROP_REGION);
                    if (ZoomControl.this.mPendingZoomCropRegion != null && ZoomControl.this.mPendingZoomCropRegion.equals((Object)cropRect)) {
                        completerToSet = ZoomControl.this.mPendingZoomRatioCompleter;
                        ZoomControl.this.mPendingZoomRatioCompleter = null;
                        ZoomControl.this.mPendingZoomCropRegion = null;
                    }
                }
            }
            if (completerToSet != null) {
                completerToSet.set(null);
            }
            return false;
        }
    };

    ZoomControl(@NonNull Camera2CameraControl camera2CameraControl, @NonNull CameraCharacteristics cameraCharacteristics) {
        this.mCamera2CameraControl = camera2CameraControl;
        this.mCameraCharacteristics = cameraCharacteristics;
        this.mZoomRatioLiveData = new MutableLiveData((Object)Float.valueOf(1.0f));
        this.mMaxZoomRatioLiveData = new MutableLiveData((Object)Float.valueOf(this.getMaxDigitalZoom()));
        this.mMinZoomRatioLiveData = new MutableLiveData((Object)Float.valueOf(1.0f));
        this.mLinearZoomLiveData = new MutableLiveData((Object)Float.valueOf(0.0f));
        camera2CameraControl.addCaptureResultListener(this.mCaptureResultListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void setActive(boolean isActive) {
        CallbackToFutureAdapter.Completer<Void> completerToSetException = null;
        boolean shouldResetDefault = false;
        Object object = this.mActiveLock;
        synchronized (object) {
            if (this.mIsActive == isActive) {
                return;
            }
            this.mIsActive = isActive;
            if (!this.mIsActive) {
                Object object2 = this.mCompleterLock;
                synchronized (object2) {
                    if (this.mPendingZoomRatioCompleter != null) {
                        completerToSetException = this.mPendingZoomRatioCompleter;
                        this.mPendingZoomRatioCompleter = null;
                        this.mPendingZoomCropRegion = null;
                    }
                }
                shouldResetDefault = true;
            }
        }
        if (shouldResetDefault) {
            this.setLiveDataValue(this.mZoomRatioLiveData, Float.valueOf(1.0f));
            this.setLiveDataValue(this.mLinearZoomLiveData, Float.valueOf(0.0f));
            this.mCamera2CameraControl.setCropRegion(null);
        }
        if (completerToSetException != null) {
            completerToSetException.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    ListenableFuture<Void> setZoomRatio(float ratio) {
        Object object = this.mActiveLock;
        synchronized (object) {
            if (!this.mIsActive) {
                return Futures.immediateFailedFuture((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            }
            if (ratio > ((Float)this.getMaxZoomRatio().getValue()).floatValue() || ratio < ((Float)this.getMinZoomRatio().getValue()).floatValue()) {
                String outOfRangeDesc = "Requested zoomRatio " + ratio + " is not within valid range [" + this.getMinZoomRatio().getValue() + " , " + this.getMaxZoomRatio().getValue() + "]";
                return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException(outOfRangeDesc));
            }
            return this.setZoomRatioInternal(ratio, true);
        }
    }

    @NonNull
    @VisibleForTesting
    static Rect getCropRectByRatio(@NonNull Rect sensorRect, float ratio) {
        float cropWidth = (float)sensorRect.width() / ratio;
        float cropHeight = (float)sensorRect.height() / ratio;
        float left = ((float)sensorRect.width() - cropWidth) / 2.0f;
        float top = ((float)sensorRect.height() - cropHeight) / 2.0f;
        return new Rect((int)left, (int)top, (int)(left + cropWidth), (int)(top + cropHeight));
    }

    @NonNull
    @GuardedBy(value="mActiveLock")
    private ListenableFuture<Void> setZoomRatioInternal(float ratio, boolean updatePercentage) {
        Rect sensorRect = this.mCamera2CameraControl.getSensorRect();
        if (sensorRect == null) {
            throw new IllegalStateException("Cannot get sensor active array");
        }
        this.setLiveDataValue(this.mZoomRatioLiveData, Float.valueOf(ratio));
        if (updatePercentage) {
            this.setLiveDataValue(this.mLinearZoomLiveData, Float.valueOf(this.getPercentageByRatio(ratio)));
        }
        final Rect targetRegion = ZoomControl.getCropRectByRatio(sensorRect, ratio);
        this.mCamera2CameraControl.setCropRegion(targetRegion);
        return CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public Object attachCompleter(@NonNull CallbackToFutureAdapter.Completer<Void> completer) throws Exception {
                CallbackToFutureAdapter.Completer<Void> completerToCancel = null;
                Object object = ZoomControl.this.mCompleterLock;
                synchronized (object) {
                    if (ZoomControl.this.mPendingZoomRatioCompleter != null) {
                        completerToCancel = ZoomControl.this.mPendingZoomRatioCompleter;
                        ZoomControl.this.mPendingZoomRatioCompleter = null;
                    }
                    ZoomControl.this.mPendingZoomCropRegion = targetRegion;
                    ZoomControl.this.mPendingZoomRatioCompleter = completer;
                }
                if (completerToCancel != null) {
                    completerToCancel.setException((Throwable)new CameraControl.OperationCanceledException("There is a new zoomRatio being set"));
                }
                return "setZoomRatio";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    ListenableFuture<Void> setLinearZoom(@FloatRange(from=0.0, to=1.0) float linearZoom) {
        Object object = this.mActiveLock;
        synchronized (object) {
            if (!this.mIsActive) {
                return Futures.immediateFailedFuture((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            }
            if (linearZoom > 1.0f || linearZoom < 0.0f) {
                String outOfRangeDesc = "Requested linearZoom " + linearZoom + " is not within valid range [0..1]";
                return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException(outOfRangeDesc));
            }
            float ratio = this.getRatioByPercentage(linearZoom);
            this.setLiveDataValue(this.mLinearZoomLiveData, Float.valueOf(linearZoom));
            return this.setZoomRatioInternal(ratio, false);
        }
    }

    private <T> void setLiveDataValue(@NonNull MutableLiveData<T> liveData, T value) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            liveData.setValue(value);
        } else {
            liveData.postValue(value);
        }
    }

    @NonNull
    LiveData<Float> getZoomRatio() {
        return this.mZoomRatioLiveData;
    }

    @NonNull
    LiveData<Float> getMaxZoomRatio() {
        return this.mMaxZoomRatioLiveData;
    }

    @NonNull
    LiveData<Float> getMinZoomRatio() {
        return this.mMinZoomRatioLiveData;
    }

    @NonNull
    LiveData<Float> getLinearZoom() {
        return this.mLinearZoomLiveData;
    }

    private float getMaxDigitalZoom() {
        Float maxZoom = (Float)this.mCameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
        if (maxZoom == null) {
            return 1.0f;
        }
        return maxZoom.floatValue();
    }

    private float getRatioByPercentage(float percentage) {
        if (percentage == 1.0f) {
            return this.getMaxDigitalZoom();
        }
        if (percentage == 0.0f) {
            return 1.0f;
        }
        double cropWidthInMaxZoom = 1.0f / ((Float)this.getMaxZoomRatio().getValue()).floatValue();
        double cropWidthInMinZoom = 1.0f / ((Float)this.getMinZoomRatio().getValue()).floatValue();
        double cropWidth = cropWidthInMinZoom + (cropWidthInMaxZoom - cropWidthInMinZoom) * (double)percentage;
        double ratio = 1.0 / cropWidth;
        return (float)MathUtils.clamp((double)ratio, (double)((Float)this.getMinZoomRatio().getValue()).floatValue(), (double)((Float)this.getMaxZoomRatio().getValue()).floatValue());
    }

    private float getPercentageByRatio(float ratio) {
        if (this.getMaxDigitalZoom() == 1.0f) {
            return 0.0f;
        }
        if (ratio == this.getMaxDigitalZoom()) {
            return 1.0f;
        }
        if (ratio == 1.0f) {
            return 0.0f;
        }
        float cropWidth = 1.0f / ratio;
        float cropWidthInMaxZoom = 1.0f / ((Float)this.getMaxZoomRatio().getValue()).floatValue();
        float cropWidthInMinZoom = 1.0f / ((Float)this.getMinZoomRatio().getValue()).floatValue();
        return (cropWidth - cropWidthInMinZoom) / (cropWidthInMaxZoom - cropWidthInMinZoom);
    }
}

