/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl.compat;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.impl.compat.CameraDeviceCompatApi23Impl;
import androidx.camera.camera2.impl.compat.CameraDeviceCompatApi24Impl;
import androidx.camera.camera2.impl.compat.CameraDeviceCompatApi28Impl;
import androidx.camera.camera2.impl.compat.CameraDeviceCompatBaseImpl;
import androidx.camera.camera2.impl.compat.params.SessionConfigurationCompat;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public final class CameraDeviceCompat {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final int SESSION_OPERATION_MODE_NORMAL = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final int SESSION_OPERATION_MODE_CONSTRAINED_HIGH_SPEED = 1;
    private static final CameraDeviceCompatImpl IMPL = CameraDeviceCompat.chooseImplementation();

    private CameraDeviceCompat() {
    }

    public static void createCaptureSession(@NonNull CameraDevice device, @NonNull SessionConfigurationCompat config) throws CameraAccessException {
        IMPL.createCaptureSession(device, config);
    }

    private static CameraDeviceCompatImpl chooseImplementation() {
        if (Build.VERSION.SDK_INT >= 28) {
            return new CameraDeviceCompatApi28Impl();
        }
        if (Build.VERSION.SDK_INT >= 24) {
            return new CameraDeviceCompatApi24Impl();
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return new CameraDeviceCompatApi23Impl();
        }
        return new CameraDeviceCompatBaseImpl();
    }

    static final class StateCallbackExecutorWrapper
    extends CameraDevice.StateCallback {
        final CameraDevice.StateCallback mWrappedCallback;
        private final Executor mExecutor;

        StateCallbackExecutorWrapper(@NonNull Executor executor, @NonNull CameraDevice.StateCallback wrappedCallback) {
            this.mExecutor = executor;
            this.mWrappedCallback = wrappedCallback;
        }

        public void onOpened(final @NonNull CameraDevice camera) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onOpened(camera);
                }
            });
        }

        public void onDisconnected(final @NonNull CameraDevice camera) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onDisconnected(camera);
                }
            });
        }

        public void onError(final @NonNull CameraDevice camera, final int error) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onError(camera, error);
                }
            });
        }

        public void onClosed(final @NonNull CameraDevice camera) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onClosed(camera);
                }
            });
        }
    }

    static interface CameraDeviceCompatImpl {
        public void createCaptureSession(@NonNull CameraDevice var1, @NonNull SessionConfigurationCompat var2) throws CameraAccessException;
    }
}

