/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl.compat;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.params.InputConfiguration;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.compat.CameraCaptureSessionCompat;
import androidx.camera.camera2.impl.compat.CameraDeviceCompatBaseImpl;
import androidx.camera.camera2.impl.compat.params.InputConfigurationCompat;
import androidx.camera.camera2.impl.compat.params.SessionConfigurationCompat;
import androidx.camera.core.impl.utils.MainThreadAsyncHandler;
import androidx.core.util.Preconditions;
import java.util.List;

@RequiresApi(value=23)
class CameraDeviceCompatApi23Impl
extends CameraDeviceCompatBaseImpl {
    CameraDeviceCompatApi23Impl() {
    }

    @Override
    public void createCaptureSession(@NonNull CameraDevice device, @NonNull SessionConfigurationCompat config) throws CameraAccessException {
        CameraDeviceCompatApi23Impl.checkPreconditions(device, config);
        CameraCaptureSessionCompat.StateCallbackExecutorWrapper cb = new CameraCaptureSessionCompat.StateCallbackExecutorWrapper(config.getExecutor(), config.getStateCallback());
        List<Surface> surfaces = CameraDeviceCompatApi23Impl.unpackSurfaces(config.getOutputConfigurations());
        Handler handler = MainThreadAsyncHandler.getInstance();
        InputConfigurationCompat inputConfigCompat = config.getInputConfiguration();
        if (inputConfigCompat != null) {
            InputConfiguration inputConfig = (InputConfiguration)inputConfigCompat.unwrap();
            Preconditions.checkNotNull((Object)inputConfig);
            device.createReprocessableCaptureSession(inputConfig, surfaces, (CameraCaptureSession.StateCallback)cb, handler);
        } else if (config.getSessionType() == 1) {
            device.createConstrainedHighSpeedCaptureSession(surfaces, (CameraCaptureSession.StateCallback)cb, handler);
        } else {
            this.createBaseCaptureSession(device, surfaces, cb, handler);
        }
    }
}

