/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl.compat;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.compat.CameraCaptureSessionCompat;
import androidx.camera.camera2.impl.compat.CameraDeviceCompat;
import androidx.camera.camera2.impl.compat.params.OutputConfigurationCompat;
import androidx.camera.camera2.impl.compat.params.SessionConfigurationCompat;
import androidx.camera.core.impl.utils.MainThreadAsyncHandler;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=21)
class CameraDeviceCompatBaseImpl
implements CameraDeviceCompat.CameraDeviceCompatImpl {
    CameraDeviceCompatBaseImpl() {
    }

    static List<Surface> unpackSurfaces(@NonNull List<OutputConfigurationCompat> outputConfigs) {
        ArrayList<Surface> surfaces = new ArrayList<Surface>(outputConfigs.size());
        for (OutputConfigurationCompat outputConfig : outputConfigs) {
            surfaces.add(outputConfig.getSurface());
        }
        return surfaces;
    }

    static void checkPreconditions(CameraDevice device, SessionConfigurationCompat config) {
        Preconditions.checkNotNull((Object)device);
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)config.getStateCallback());
        List<OutputConfigurationCompat> outputConfigs = config.getOutputConfigurations();
        if (outputConfigs == null) {
            throw new IllegalArgumentException("Invalid output configurations");
        }
        if (config.getExecutor() == null) {
            throw new IllegalArgumentException("Invalid executor");
        }
        CameraDeviceCompatBaseImpl.checkPhysicalCameraIdValid(device, outputConfigs);
    }

    private static void checkPhysicalCameraIdValid(CameraDevice device, @NonNull List<OutputConfigurationCompat> outputConfigs) {
        String cameraId = device.getId();
        for (OutputConfigurationCompat outputConfigurationCompat : outputConfigs) {
            String outputConfigPhysicalId = outputConfigurationCompat.getPhysicalCameraId();
            if (outputConfigPhysicalId == null || outputConfigPhysicalId.isEmpty()) continue;
            Log.w((String)"CameraDeviceCompat", (String)("Camera " + cameraId + ": Camera doesn't support physicalCameraId " + outputConfigPhysicalId + ". Ignoring."));
        }
    }

    void createBaseCaptureSession(@NonNull CameraDevice device, @NonNull List<Surface> surfaces, @NonNull CameraCaptureSession.StateCallback cb, @NonNull Handler handler) throws CameraAccessException {
        device.createCaptureSession(surfaces, cb, handler);
    }

    @Override
    public void createCaptureSession(@NonNull CameraDevice device, @NonNull SessionConfigurationCompat config) throws CameraAccessException {
        CameraDeviceCompatBaseImpl.checkPreconditions(device, config);
        if (config.getInputConfiguration() != null) {
            throw new IllegalArgumentException("Reprocessing sessions not supported until API 23");
        }
        if (config.getSessionType() == 1) {
            throw new IllegalArgumentException("High speed capture sessions not supported until API 23");
        }
        CameraCaptureSessionCompat.StateCallbackExecutorWrapper cb = new CameraCaptureSessionCompat.StateCallbackExecutorWrapper(config.getExecutor(), config.getStateCallback());
        List<Surface> surfaces = CameraDeviceCompatBaseImpl.unpackSurfaces(config.getOutputConfigurations());
        this.createBaseCaptureSession(device, surfaces, cb, MainThreadAsyncHandler.getInstance());
    }
}

