/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CaptureResult;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.CameraCaptureMetaData;
import androidx.camera.core.impl.CameraCaptureResult;

public class Camera2CameraCaptureResult
implements CameraCaptureResult {
    private static final String TAG = "C2CameraCaptureResult";
    private final Object mTag;
    private final CaptureResult mCaptureResult;

    public Camera2CameraCaptureResult(@Nullable Object tag, @NonNull CaptureResult captureResult) {
        this.mTag = tag;
        this.mCaptureResult = captureResult;
    }

    @NonNull
    public CameraCaptureMetaData.AfMode getAfMode() {
        Integer mode = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AF_MODE);
        if (mode == null) {
            return CameraCaptureMetaData.AfMode.UNKNOWN;
        }
        switch (mode) {
            case 0: 
            case 5: {
                return CameraCaptureMetaData.AfMode.OFF;
            }
            case 1: 
            case 2: {
                return CameraCaptureMetaData.AfMode.ON_MANUAL_AUTO;
            }
            case 3: 
            case 4: {
                return CameraCaptureMetaData.AfMode.ON_CONTINUOUS_AUTO;
            }
        }
        Log.e((String)TAG, (String)("Undefined af mode: " + mode));
        return CameraCaptureMetaData.AfMode.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.AfState getAfState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AF_STATE);
        if (state == null) {
            return CameraCaptureMetaData.AfState.UNKNOWN;
        }
        switch (state) {
            case 0: {
                return CameraCaptureMetaData.AfState.INACTIVE;
            }
            case 1: 
            case 3: 
            case 6: {
                return CameraCaptureMetaData.AfState.SCANNING;
            }
            case 4: {
                return CameraCaptureMetaData.AfState.LOCKED_FOCUSED;
            }
            case 5: {
                return CameraCaptureMetaData.AfState.LOCKED_NOT_FOCUSED;
            }
            case 2: {
                return CameraCaptureMetaData.AfState.FOCUSED;
            }
        }
        Log.e((String)TAG, (String)("Undefined af state: " + state));
        return CameraCaptureMetaData.AfState.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.AeState getAeState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AE_STATE);
        if (state == null) {
            return CameraCaptureMetaData.AeState.UNKNOWN;
        }
        switch (state) {
            case 0: {
                return CameraCaptureMetaData.AeState.INACTIVE;
            }
            case 1: 
            case 5: {
                return CameraCaptureMetaData.AeState.SEARCHING;
            }
            case 4: {
                return CameraCaptureMetaData.AeState.FLASH_REQUIRED;
            }
            case 2: {
                return CameraCaptureMetaData.AeState.CONVERGED;
            }
            case 3: {
                return CameraCaptureMetaData.AeState.LOCKED;
            }
        }
        Log.e((String)TAG, (String)("Undefined ae state: " + state));
        return CameraCaptureMetaData.AeState.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.AwbState getAwbState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AWB_STATE);
        if (state == null) {
            return CameraCaptureMetaData.AwbState.UNKNOWN;
        }
        switch (state) {
            case 0: {
                return CameraCaptureMetaData.AwbState.INACTIVE;
            }
            case 1: {
                return CameraCaptureMetaData.AwbState.METERING;
            }
            case 2: {
                return CameraCaptureMetaData.AwbState.CONVERGED;
            }
            case 3: {
                return CameraCaptureMetaData.AwbState.LOCKED;
            }
        }
        Log.e((String)TAG, (String)("Undefined awb state: " + state));
        return CameraCaptureMetaData.AwbState.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.FlashState getFlashState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.FLASH_STATE);
        if (state == null) {
            return CameraCaptureMetaData.FlashState.UNKNOWN;
        }
        switch (state) {
            case 0: 
            case 1: {
                return CameraCaptureMetaData.FlashState.NONE;
            }
            case 2: {
                return CameraCaptureMetaData.FlashState.READY;
            }
            case 3: 
            case 4: {
                return CameraCaptureMetaData.FlashState.FIRED;
            }
        }
        Log.e((String)TAG, (String)("Undefined flash state: " + state));
        return CameraCaptureMetaData.FlashState.UNKNOWN;
    }

    public long getTimestamp() {
        Long timestamp = (Long)this.mCaptureResult.get(CaptureResult.SENSOR_TIMESTAMP);
        if (timestamp == null) {
            return -1L;
        }
        return timestamp;
    }

    @Nullable
    public Object getTag() {
        return this.mTag;
    }

    @NonNull
    public CaptureResult getCaptureResult() {
        return this.mCaptureResult;
    }
}

