/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.media.CamcorderProfile;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.internal.CamcorderProfileHelper;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.SupportedSurfaceCombination;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Camera2DeviceSurfaceManager
implements CameraDeviceSurfaceManager {
    private static final String TAG = "Camera2DeviceSurfaceManager";
    private static final Size MAXIMUM_PREVIEW_SIZE = new Size(1920, 1080);
    private final Map<String, SupportedSurfaceCombination> mCameraSupportedSurfaceCombinationMap = new HashMap<String, SupportedSurfaceCombination>();
    private final CamcorderProfileHelper mCamcorderProfileHelper;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Camera2DeviceSurfaceManager(@NonNull Context context) throws CameraUnavailableException {
        this(context, CamcorderProfile::hasProfile);
    }

    Camera2DeviceSurfaceManager(@NonNull Context context, @NonNull CamcorderProfileHelper camcorderProfileHelper) throws CameraUnavailableException {
        Preconditions.checkNotNull((Object)camcorderProfileHelper);
        this.mCamcorderProfileHelper = camcorderProfileHelper;
        this.init(context);
    }

    private void init(@NonNull Context context) throws CameraUnavailableException {
        Preconditions.checkNotNull((Object)context);
        CameraManagerCompat cameraManager = CameraManagerCompat.from(context);
        try {
            for (String cameraId : cameraManager.getCameraIdList()) {
                this.mCameraSupportedSurfaceCombinationMap.put(cameraId, new SupportedSurfaceCombination(context, cameraId, this.mCamcorderProfileHelper));
            }
        }
        catch (CameraAccessExceptionCompat e) {
            throw CameraUnavailableExceptionHelper.createFrom(e);
        }
    }

    public boolean checkSupported(@NonNull String cameraId, @Nullable List<SurfaceConfig> surfaceConfigList) {
        if (surfaceConfigList == null || surfaceConfigList.isEmpty()) {
            return true;
        }
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        boolean isSupported = false;
        if (supportedSurfaceCombination != null) {
            isSupported = supportedSurfaceCombination.checkSupported(surfaceConfigList);
        }
        return isSupported;
    }

    @Nullable
    public SurfaceConfig transformSurfaceConfig(@NonNull String cameraId, int imageFormat, @NonNull Size size) {
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        SurfaceConfig surfaceConfig = null;
        if (supportedSurfaceCombination != null) {
            surfaceConfig = supportedSurfaceCombination.transformSurfaceConfig(imageFormat, size);
        }
        return surfaceConfig;
    }

    @NonNull
    public Map<UseCaseConfig<?>, Size> getSuggestedResolutions(@NonNull String cameraId, @NonNull List<SurfaceConfig> existingSurfaces, @NonNull List<UseCaseConfig<?>> newUseCaseConfigs) {
        Preconditions.checkArgument((!newUseCaseConfigs.isEmpty() ? 1 : 0) != 0, (Object)"No new use cases to be bound.");
        ArrayList<SurfaceConfig> surfaceConfigs = new ArrayList<SurfaceConfig>(existingSurfaces);
        for (UseCaseConfig<?> useCaseConfig : newUseCaseConfigs) {
            surfaceConfigs.add(this.transformSurfaceConfig(cameraId, useCaseConfig.getInputFormat(), new Size(640, 480)));
        }
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination == null) {
            throw new IllegalArgumentException("No such camera id in supported combination list: " + cameraId);
        }
        if (!supportedSurfaceCombination.checkSupported(surfaceConfigs)) {
            throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + cameraId + ".  May be attempting to bind too many use cases. Existing surfaces: " + existingSurfaces + " New configs: " + newUseCaseConfigs);
        }
        return supportedSurfaceCombination.getSuggestedResolutions(existingSurfaces, newUseCaseConfigs);
    }

    @NonNull
    public Size getMaxOutputSize(@NonNull String cameraId, int imageFormat) {
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination == null) {
            throw new IllegalArgumentException("Fail to find supported surface info - CameraId:" + cameraId);
        }
        return supportedSurfaceCombination.getMaxOutputSizeByFormat(imageFormat);
    }

    @NonNull
    public Size getPreviewSize() {
        Size previewSize = MAXIMUM_PREVIEW_SIZE;
        if (!this.mCameraSupportedSurfaceCombinationMap.isEmpty()) {
            String cameraId = (String)this.mCameraSupportedSurfaceCombinationMap.keySet().toArray()[0];
            previewSize = this.mCameraSupportedSurfaceCombinationMap.get(cameraId).getSurfaceSizeDefinition().getPreviewSize();
        }
        return previewSize;
    }

    public boolean requiresCorrectedAspectRatio(@NonNull String cameraId) {
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination == null) {
            throw new IllegalArgumentException("Fail to find supported surface info - CameraId:" + cameraId);
        }
        return supportedSurfaceCombination.requiresCorrectedAspectRatio();
    }

    @Nullable
    public Rational getCorrectedAspectRatio(@NonNull String cameraId, int rotation) {
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination == null) {
            throw new IllegalArgumentException("Fail to find supported surface info - CameraId:" + cameraId);
        }
        return supportedSurfaceCombination.getCorrectedAspectRatio(rotation);
    }
}

