/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import androidx.annotation.NonNull;
import androidx.camera.camera2.internal.MeteringRepeating;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.UseCaseEventConfig;
import java.util.UUID;

public class MeteringRepeatingConfig
implements UseCaseConfig<MeteringRepeating> {
    private final OptionsBundle mConfig;

    public MeteringRepeatingConfig(@NonNull OptionsBundle config) {
        this.mConfig = config;
    }

    @NonNull
    public Config getConfig() {
        return this.mConfig;
    }

    public static final class Builder
    implements UseCaseConfig.Builder<MeteringRepeating, MeteringRepeatingConfig, Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = (Class)mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(MeteringRepeating.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setTargetClass((Class)MeteringRepeating.class);
        }

        @NonNull
        public static Builder fromConfig(@NonNull MeteringRepeatingConfig configuration) {
            return new Builder(MutableOptionsBundle.from((Config)configuration));
        }

        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @NonNull
        public MeteringRepeatingConfig getUseCaseConfig() {
            return new MeteringRepeatingConfig(OptionsBundle.from((Config)this.mMutableConfig));
        }

        @NonNull
        public MeteringRepeating build() {
            return new MeteringRepeating(this.getUseCaseConfig());
        }

        @NonNull
        public Builder setTargetClass(@NonNull Class<MeteringRepeating> targetClass) {
            this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(TargetConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @NonNull
        public Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_NAME, (Object)targetName);
            return this;
        }

        @NonNull
        public Builder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_SESSION_CONFIG, (Object)sessionConfig);
            return this;
        }

        @NonNull
        public Builder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_CAPTURE_CONFIG, (Object)captureConfig);
            return this;
        }

        @NonNull
        public Builder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SESSION_CONFIG_UNPACKER, (Object)optionUnpacker);
            return this;
        }

        @NonNull
        public Builder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_CONFIG_UNPACKER, (Object)optionUnpacker);
            return this;
        }

        @NonNull
        public Builder setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, (Object)priority);
            return this;
        }

        @NonNull
        public Builder setCameraSelector(@NonNull CameraSelector cameraSelector) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAMERA_SELECTOR, (Object)cameraSelector);
            return this;
        }

        @NonNull
        public Builder setUseCaseEventCallback(@NonNull UseCase.EventCallback eventCallback) {
            this.getMutableConfig().insertOption(UseCaseEventConfig.OPTION_USE_CASE_EVENT_CALLBACK, (Object)eventCallback);
            return this;
        }
    }
}

