/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.os.Looper;
import androidx.annotation.FloatRange;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.camera.camera2.internal.Camera2CameraControl;
import androidx.camera.camera2.internal.ZoomStateImpl;
import androidx.camera.core.CameraControl;
import androidx.camera.core.ZoomState;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.ImmutableZoomState;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.google.common.util.concurrent.ListenableFuture;

final class ZoomControl {
    private static final String TAG = "ZoomControl";
    public static final float DEFAULT_ZOOM_RATIO = 1.0f;
    public static final float MIN_ZOOM = 1.0f;
    private final Camera2CameraControl mCamera2CameraControl;
    @GuardedBy(value="mActiveLock")
    private final ZoomStateImpl mCurrentZoomState;
    private final MutableLiveData<ZoomState> mZoomStateLiveData;
    final Object mCompleterLock = new Object();
    @GuardedBy(value="mCompleterLock")
    CallbackToFutureAdapter.Completer<Void> mPendingZoomRatioCompleter;
    @GuardedBy(value="mCompleterLock")
    Rect mPendingZoomCropRegion = null;
    final Object mActiveLock = new Object();
    @GuardedBy(value="mActiveLock")
    private boolean mIsActive = false;
    private Camera2CameraControl.CaptureResultListener mCaptureResultListener = new Camera2CameraControl.CaptureResultListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public boolean onCaptureResult(@NonNull TotalCaptureResult captureResult) {
            CallbackToFutureAdapter.Completer<Void> completerToSet = null;
            Object object = ZoomControl.this.mCompleterLock;
            synchronized (object) {
                if (ZoomControl.this.mPendingZoomRatioCompleter != null) {
                    Rect cropRect;
                    CaptureRequest request = captureResult.getRequest();
                    Rect rect = cropRect = request == null ? null : (Rect)request.get(CaptureRequest.SCALER_CROP_REGION);
                    if (ZoomControl.this.mPendingZoomCropRegion != null && ZoomControl.this.mPendingZoomCropRegion.equals((Object)cropRect)) {
                        completerToSet = ZoomControl.this.mPendingZoomRatioCompleter;
                        ZoomControl.this.mPendingZoomRatioCompleter = null;
                        ZoomControl.this.mPendingZoomCropRegion = null;
                    }
                }
            }
            if (completerToSet != null) {
                completerToSet.set(null);
            }
            return false;
        }
    };

    ZoomControl(@NonNull Camera2CameraControl camera2CameraControl, @NonNull CameraCharacteristics cameraCharacteristics) {
        this.mCamera2CameraControl = camera2CameraControl;
        this.mCurrentZoomState = new ZoomStateImpl(ZoomControl.getMaxDigitalZoom(cameraCharacteristics), 1.0f);
        this.mCurrentZoomState.setZoomRatio(1.0f);
        this.mZoomStateLiveData = new MutableLiveData((Object)ImmutableZoomState.create((ZoomState)this.mCurrentZoomState));
        camera2CameraControl.addCaptureResultListener(this.mCaptureResultListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void setActive(boolean isActive) {
        CallbackToFutureAdapter.Completer<Void> completerToSetException = null;
        boolean shouldResetDefault = false;
        Object object = this.mActiveLock;
        synchronized (object) {
            if (this.mIsActive == isActive) {
                return;
            }
            this.mIsActive = isActive;
            if (!this.mIsActive) {
                Object object2 = this.mCompleterLock;
                synchronized (object2) {
                    if (this.mPendingZoomRatioCompleter != null) {
                        completerToSetException = this.mPendingZoomRatioCompleter;
                        this.mPendingZoomRatioCompleter = null;
                        this.mPendingZoomCropRegion = null;
                    }
                }
                shouldResetDefault = true;
                this.mCurrentZoomState.setZoomRatio(1.0f);
                this.updateLiveData(ImmutableZoomState.create((ZoomState)this.mCurrentZoomState));
            }
        }
        if (shouldResetDefault) {
            this.mCamera2CameraControl.setCropRegion(null);
        }
        if (completerToSetException != null) {
            completerToSetException.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    ListenableFuture<Void> setZoomRatio(float ratio) {
        Object object = this.mActiveLock;
        synchronized (object) {
            if (!this.mIsActive) {
                return Futures.immediateFailedFuture((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            }
            try {
                this.mCurrentZoomState.setZoomRatio(ratio);
            }
            catch (IllegalArgumentException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            this.updateLiveData(ImmutableZoomState.create((ZoomState)this.mCurrentZoomState));
            return this.submitCameraZoomRatio(ratio);
        }
    }

    @NonNull
    @VisibleForTesting
    static Rect getCropRectByRatio(@NonNull Rect sensorRect, float ratio) {
        float cropWidth = (float)sensorRect.width() / ratio;
        float cropHeight = (float)sensorRect.height() / ratio;
        float left = ((float)sensorRect.width() - cropWidth) / 2.0f;
        float top = ((float)sensorRect.height() - cropHeight) / 2.0f;
        return new Rect((int)left, (int)top, (int)(left + cropWidth), (int)(top + cropHeight));
    }

    @NonNull
    @GuardedBy(value="mActiveLock")
    private ListenableFuture<Void> submitCameraZoomRatio(float ratio) {
        Rect sensorRect = this.mCamera2CameraControl.getSensorRect();
        Rect targetRegion = ZoomControl.getCropRectByRatio(sensorRect, ratio);
        this.mCamera2CameraControl.setCropRegion(targetRegion);
        return CallbackToFutureAdapter.getFuture(completer -> {
            CallbackToFutureAdapter.Completer<Void> completerToCancel = null;
            Object object = this.mCompleterLock;
            synchronized (object) {
                if (this.mPendingZoomRatioCompleter != null) {
                    completerToCancel = this.mPendingZoomRatioCompleter;
                    this.mPendingZoomRatioCompleter = null;
                }
                this.mPendingZoomCropRegion = targetRegion;
                this.mPendingZoomRatioCompleter = completer;
            }
            if (completerToCancel != null) {
                completerToCancel.setException((Throwable)new CameraControl.OperationCanceledException("There is a new zoomRatio being set"));
            }
            return "setZoomRatio";
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    ListenableFuture<Void> setLinearZoom(@FloatRange(from=0.0, to=1.0) float linearZoom) {
        Object object = this.mActiveLock;
        synchronized (object) {
            if (!this.mIsActive) {
                return Futures.immediateFailedFuture((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            }
            try {
                this.mCurrentZoomState.setLinearZoom(linearZoom);
            }
            catch (IllegalArgumentException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            this.updateLiveData(ImmutableZoomState.create((ZoomState)this.mCurrentZoomState));
            return this.submitCameraZoomRatio(this.mCurrentZoomState.getZoomRatio());
        }
    }

    private void updateLiveData(ZoomState zoomState) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.mZoomStateLiveData.setValue((Object)zoomState);
        } else {
            this.mZoomStateLiveData.postValue((Object)zoomState);
        }
    }

    LiveData<ZoomState> getZoomState() {
        return this.mZoomStateLiveData;
    }

    private static float getMaxDigitalZoom(CameraCharacteristics cameraCharacteristics) {
        Float maxZoom = (Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
        if (maxZoom == null) {
            return 1.0f;
        }
        return maxZoom.floatValue();
    }
}

