/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.os.Handler;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompatApi28Impl;
import androidx.camera.camera2.internal.compat.CameraManagerCompatApi29Impl;
import androidx.camera.camera2.internal.compat.CameraManagerCompatBaseImpl;
import androidx.camera.core.impl.utils.MainThreadAsyncHandler;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public final class CameraManagerCompat {
    private final CameraManagerCompatImpl mImpl;

    private CameraManagerCompat(CameraManagerCompatImpl impl) {
        this.mImpl = impl;
    }

    @NonNull
    public static CameraManagerCompat from(@NonNull Context context) {
        return CameraManagerCompat.from(context, MainThreadAsyncHandler.getInstance());
    }

    @NonNull
    public static CameraManagerCompat from(@NonNull Context context, @NonNull Handler compatHandler) {
        if (Build.VERSION.SDK_INT >= 29) {
            return new CameraManagerCompat(new CameraManagerCompatApi29Impl(context));
        }
        if (Build.VERSION.SDK_INT >= 28) {
            return new CameraManagerCompat(CameraManagerCompatApi28Impl.create(context));
        }
        return new CameraManagerCompat(CameraManagerCompatBaseImpl.create(context, compatHandler));
    }

    @NonNull
    public String[] getCameraIdList() throws CameraAccessExceptionCompat {
        return this.mImpl.getCameraIdList();
    }

    public void registerAvailabilityCallback(@NonNull Executor executor, @NonNull CameraManager.AvailabilityCallback callback) {
        this.mImpl.registerAvailabilityCallback(executor, callback);
    }

    public void unregisterAvailabilityCallback(@NonNull CameraManager.AvailabilityCallback callback) {
        this.mImpl.unregisterAvailabilityCallback(callback);
    }

    @NonNull
    public CameraCharacteristics getCameraCharacteristics(@NonNull String cameraId) throws CameraAccessExceptionCompat {
        return this.mImpl.getCameraCharacteristics(cameraId);
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void openCamera(@NonNull String cameraId, @NonNull Executor executor, @NonNull CameraDevice.StateCallback callback) throws CameraAccessExceptionCompat {
        this.mImpl.openCamera(cameraId, executor, callback);
    }

    @NonNull
    public CameraManager unwrap() {
        return this.mImpl.getCameraManager();
    }

    static final class AvailabilityCallbackExecutorWrapper
    extends CameraManager.AvailabilityCallback {
        private final Executor mExecutor;
        final CameraManager.AvailabilityCallback mWrappedCallback;
        private final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private boolean mDisabled = false;

        AvailabilityCallbackExecutorWrapper(@NonNull Executor executor, @NonNull CameraManager.AvailabilityCallback wrappedCallback) {
            this.mExecutor = executor;
            this.mWrappedCallback = wrappedCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDisabled() {
            Object object = this.mLock;
            synchronized (object) {
                this.mDisabled = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresApi(value=29)
        public void onCameraAccessPrioritiesChanged() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mDisabled) {
                    this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            mWrappedCallback.onCameraAccessPrioritiesChanged();
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraAvailable(final @NonNull String cameraId) {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mDisabled) {
                    this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            mWrappedCallback.onCameraAvailable(cameraId);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraUnavailable(final @NonNull String cameraId) {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mDisabled) {
                    this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            mWrappedCallback.onCameraUnavailable(cameraId);
                        }
                    });
                }
            }
        }
    }

    static interface CameraManagerCompatImpl {
        public String[] getCameraIdList() throws CameraAccessExceptionCompat;

        public void registerAvailabilityCallback(@NonNull Executor var1, @NonNull CameraManager.AvailabilityCallback var2);

        public void unregisterAvailabilityCallback(@NonNull CameraManager.AvailabilityCallback var1);

        @NonNull
        public CameraCharacteristics getCameraCharacteristics(@NonNull String var1) throws CameraAccessExceptionCompat;

        @RequiresPermission(value="android.permission.CAMERA")
        public void openCamera(@NonNull String var1, @NonNull Executor var2, @NonNull CameraDevice.StateCallback var3) throws CameraAccessExceptionCompat;

        @NonNull
        public CameraManager getCameraManager();
    }
}

