/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompatBaseImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

@RequiresApi(value=28)
class CameraManagerCompatApi28Impl
extends CameraManagerCompatBaseImpl {
    CameraManagerCompatApi28Impl(@NonNull Context context, @Nullable Object cameraManagerParams) {
        super(context, cameraManagerParams);
    }

    static CameraManagerCompatApi28Impl create(@NonNull Context context) {
        return new CameraManagerCompatApi28Impl(context, new CameraManagerCompatParamsApi28());
    }

    @Override
    public void registerAvailabilityCallback(@NonNull Executor executor, @NonNull CameraManager.AvailabilityCallback callback) {
        this.mCameraManager.registerAvailabilityCallback(executor, callback);
    }

    @Override
    public void unregisterAvailabilityCallback(@NonNull CameraManager.AvailabilityCallback callback) {
        this.mCameraManager.unregisterAvailabilityCallback(callback);
    }

    @Override
    @RequiresPermission(value="android.permission.CAMERA")
    public void openCamera(@NonNull String cameraId, @NonNull Executor executor, @NonNull CameraDevice.StateCallback callback) throws CameraAccessExceptionCompat {
        try {
            this.mCameraManager.openCamera(cameraId, executor, callback);
        }
        catch (CameraAccessException e) {
            throw CameraAccessExceptionCompat.toCameraAccessExceptionCompat(e);
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (this.isDndFailCase(e)) {
                this.throwDndException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public CameraCharacteristics getCameraCharacteristics(@NonNull String cameraId) throws CameraAccessExceptionCompat {
        CameraCharacteristics cameraCharacteristics;
        block11: {
            try {
                cameraCharacteristics = super.getCameraCharacteristics(cameraId);
                if (Build.VERSION.SDK_INT != 28) break block11;
                Map<String, CameraCharacteristics> map = CameraManagerCompatParamsApi28.sCameraCharacteristicsMap;
                synchronized (map) {
                    if (!CameraManagerCompatParamsApi28.sCameraCharacteristicsMap.containsKey(cameraId)) {
                        CameraManagerCompatParamsApi28.sCameraCharacteristicsMap.put(cameraId, cameraCharacteristics);
                    }
                }
            }
            catch (RuntimeException e) {
                if (this.isDndFailCase(e)) {
                    Map<String, CameraCharacteristics> map = CameraManagerCompatParamsApi28.sCameraCharacteristicsMap;
                    synchronized (map) {
                        if (CameraManagerCompatParamsApi28.sCameraCharacteristicsMap.containsKey(cameraId)) {
                            return CameraManagerCompatParamsApi28.sCameraCharacteristicsMap.get(cameraId);
                        }
                    }
                    this.throwDndException(e);
                }
                throw e;
            }
        }
        return cameraCharacteristics;
    }

    private void throwDndException(@NonNull Throwable cause) throws CameraAccessExceptionCompat {
        throw new CameraAccessExceptionCompat(10001, cause);
    }

    private boolean isDndFailCase(@NonNull Throwable throwable) {
        return Build.VERSION.SDK_INT == 28 && CameraManagerCompatApi28Impl.isDndRuntimeException(throwable);
    }

    private static boolean isDndRuntimeException(@NonNull Throwable throwable) {
        if (throwable.getClass().equals(RuntimeException.class)) {
            StackTraceElement[] stackTraceElement = throwable.getStackTrace();
            if (stackTraceElement == null || stackTraceElement.length < 0) {
                return false;
            }
            return "_enableShutterSound".equals(stackTraceElement[0].getMethodName());
        }
        return false;
    }

    static final class CameraManagerCompatParamsApi28 {
        @GuardedBy(value="sCameraCharacteristicsMap")
        static final Map<String, CameraCharacteristics> sCameraCharacteristicsMap = new HashMap<String, CameraCharacteristics>();

        CameraManagerCompatParamsApi28() {
        }
    }
}

