/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import androidx.annotation.NonNull;
import androidx.annotation.experimental.UseExperimental;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.impl.CameraEventCallbacks;
import androidx.camera.camera2.internal.Camera2CaptureCallbacks;
import androidx.camera.camera2.internal.CameraCaptureSessionStateCallbacks;
import androidx.camera.camera2.internal.CameraDeviceStateCallbacks;
import androidx.camera.camera2.internal.CaptureCallbackContainer;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import java.util.Collection;

final class Camera2SessionOptionUnpacker
implements SessionConfig.OptionUnpacker {
    static final Camera2SessionOptionUnpacker INSTANCE = new Camera2SessionOptionUnpacker();

    Camera2SessionOptionUnpacker() {
    }

    @UseExperimental(markerClass=ExperimentalCamera2Interop.class)
    public void unpack(@NonNull UseCaseConfig<?> config, @NonNull SessionConfig.Builder builder) {
        SessionConfig defaultSessionConfig = config.getDefaultSessionConfig(null);
        OptionsBundle implOptions = OptionsBundle.emptyBundle();
        int templateType = SessionConfig.defaultEmptySessionConfig().getTemplateType();
        if (defaultSessionConfig != null) {
            templateType = defaultSessionConfig.getTemplateType();
            builder.addAllDeviceStateCallbacks((Collection)defaultSessionConfig.getDeviceStateCallbacks());
            builder.addAllSessionStateCallbacks(defaultSessionConfig.getSessionStateCallbacks());
            builder.addAllRepeatingCameraCaptureCallbacks((Collection)defaultSessionConfig.getRepeatingCameraCaptureCallbacks());
            implOptions = defaultSessionConfig.getImplementationOptions();
        }
        builder.setImplementationOptions((Config)implOptions);
        Camera2ImplConfig camera2Config = new Camera2ImplConfig((Config)config);
        builder.setTemplateType(camera2Config.getCaptureRequestTemplate(templateType));
        builder.addDeviceStateCallback(camera2Config.getDeviceStateCallback(CameraDeviceStateCallbacks.createNoOpCallback()));
        builder.addSessionStateCallback(camera2Config.getSessionStateCallback(CameraCaptureSessionStateCallbacks.createNoOpCallback()));
        builder.addCameraCaptureCallback((CameraCaptureCallback)CaptureCallbackContainer.create(camera2Config.getSessionCaptureCallback(Camera2CaptureCallbacks.createNoOpCallback())));
        MutableOptionsBundle cameraEventConfig = MutableOptionsBundle.create();
        cameraEventConfig.insertOption(Camera2ImplConfig.CAMERA_EVENT_CALLBACK_OPTION, (Object)camera2Config.getCameraEventCallback(CameraEventCallbacks.createEmptyCallback()));
        builder.addImplementationOptions((Config)cameraEventConfig);
        builder.addImplementationOptions((Config)camera2Config.getCaptureRequestOptions());
    }
}

