/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.Camera2CaptureCallbacks;
import androidx.camera.camera2.internal.CaptureSessionRepository;
import androidx.camera.camera2.internal.SynchronizedCaptureSession;
import androidx.camera.camera2.internal.SynchronizedCaptureSessionBaseImpl;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

class SynchronizedCaptureSessionImpl
extends SynchronizedCaptureSessionBaseImpl {
    private static final String TAG = "SyncCaptureSessionImpl";
    private final Object mObjectLock = new Object();
    @NonNull
    private final Set<String> mEnabledFeature;
    @NonNull
    private final ListenableFuture<Void> mStartStreamingFuture;
    CallbackToFutureAdapter.Completer<Void> mStartStreamingCompleter;
    @Nullable
    private final ListenableFuture<Void> mClosingDeferrableSurfaceFuture;
    @Nullable
    CallbackToFutureAdapter.Completer<Void> mClosingDeferrableSurfaceCompleter;
    @Nullable
    @GuardedBy(value="mObjectLock")
    private List<DeferrableSurface> mDeferrableSurfaces;
    @Nullable
    @GuardedBy(value="mObjectLock")
    ListenableFuture<Void> mOpeningCaptureSession;
    @Nullable
    @GuardedBy(value="mObjectLock")
    ListenableFuture<List<Surface>> mStartingSurface;
    @GuardedBy(value="mObjectLock")
    private boolean mHasSubmittedRepeating;
    private final CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frameNumber) {
            if (SynchronizedCaptureSessionImpl.this.mStartStreamingCompleter != null) {
                SynchronizedCaptureSessionImpl.this.mStartStreamingCompleter.set(null);
                SynchronizedCaptureSessionImpl.this.mStartStreamingCompleter = null;
            }
        }

        public void onCaptureSequenceAborted(@NonNull CameraCaptureSession session, int sequenceId) {
            if (SynchronizedCaptureSessionImpl.this.mStartStreamingCompleter != null) {
                SynchronizedCaptureSessionImpl.this.mStartStreamingCompleter.setCancelled();
                SynchronizedCaptureSessionImpl.this.mStartStreamingCompleter = null;
            }
        }
    };

    SynchronizedCaptureSessionImpl(@NonNull Set<String> enabledFeature, @NonNull CaptureSessionRepository repository, @NonNull Executor executor, @NonNull ScheduledExecutorService scheduledExecutorService, @NonNull Handler compatHandler) {
        super(repository, executor, scheduledExecutorService, compatHandler);
        this.mEnabledFeature = enabledFeature;
        this.mStartStreamingFuture = enabledFeature.contains("wait_for_request") ? CallbackToFutureAdapter.getFuture(completer -> {
            this.mStartStreamingCompleter = completer;
            return "StartStreamingFuture[session=" + this + "]";
        }) : Futures.immediateFuture(null);
        this.mClosingDeferrableSurfaceFuture = this.mEnabledFeature.contains("deferrableSurface_close") ? CallbackToFutureAdapter.getFuture(completer -> {
            this.mClosingDeferrableSurfaceCompleter = completer;
            return "ClosingDeferrableSurfaceFuture[session=" + this + "]";
        }) : Futures.immediateFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ListenableFuture<Void> openCaptureSession(@NonNull CameraDevice cameraDevice, @NonNull SessionConfigurationCompat sessionConfigurationCompat) {
        Object object = this.mObjectLock;
        synchronized (object) {
            List<ListenableFuture<Void>> futureList = this.getBlockerFuture("wait_for_request", this.mCaptureSessionRepository.getClosingCaptureSession());
            this.mOpeningCaptureSession = FutureChain.from((ListenableFuture)Futures.successfulAsList(futureList)).transformAsync(v -> super.openCaptureSession(cameraDevice, sessionConfigurationCompat), CameraXExecutors.directExecutor());
            return Futures.nonCancellationPropagating(this.mOpeningCaptureSession);
        }
    }

    @Override
    @NonNull
    public ListenableFuture<Void> getSynchronizedBlocker(@NonNull String feature) {
        switch (feature) {
            case "wait_for_request": {
                return Futures.nonCancellationPropagating(this.mStartStreamingFuture);
            }
            case "deferrableSurface_close": {
                return Futures.nonCancellationPropagating(this.mClosingDeferrableSurfaceFuture);
            }
        }
        return super.getSynchronizedBlocker(feature);
    }

    private List<ListenableFuture<Void>> getBlockerFuture(@NonNull String feature, List<SynchronizedCaptureSession> sessions) {
        ArrayList<ListenableFuture<Void>> futureList = new ArrayList<ListenableFuture<Void>>();
        for (SynchronizedCaptureSession session : sessions) {
            futureList.add(session.getSynchronizedBlocker(feature));
        }
        return futureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ListenableFuture<List<Surface>> startWithDeferrableSurface(@NonNull List<DeferrableSurface> deferrableSurfaces, long timeout) {
        Object object = this.mObjectLock;
        synchronized (object) {
            this.mDeferrableSurfaces = deferrableSurfaces;
            List<Object> futureList = Collections.emptyList();
            if (this.mEnabledFeature.contains("force_close")) {
                Map<SynchronizedCaptureSession, List<DeferrableSurface>> registeredSurfaceMap = this.mCaptureSessionRepository.registerDeferrableSurface(this, deferrableSurfaces);
                ArrayList<SynchronizedCaptureSession> sessionsWithSameSurface = new ArrayList<SynchronizedCaptureSession>();
                for (Map.Entry<SynchronizedCaptureSession, List<DeferrableSurface>> entry : registeredSurfaceMap.entrySet()) {
                    if (entry.getKey() == this || Collections.disjoint((Collection)entry.getValue(), this.mDeferrableSurfaces)) continue;
                    sessionsWithSameSurface.add(entry.getKey());
                }
                futureList = this.getBlockerFuture("deferrableSurface_close", sessionsWithSameSurface);
            }
            this.mStartingSurface = FutureChain.from((ListenableFuture)Futures.successfulAsList(futureList)).transformAsync(v -> super.startWithDeferrableSurface(deferrableSurfaces, timeout), this.getExecutor());
            return Futures.nonCancellationPropagating(this.mStartingSurface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop() {
        Object object = this.mObjectLock;
        synchronized (object) {
            if (this.isCameraCaptureSessionOpen()) {
                this.closeConfiguredDeferrableSurfaces();
            } else {
                if (this.mOpeningCaptureSession != null) {
                    this.mOpeningCaptureSession.cancel(true);
                }
                if (this.mStartingSurface != null) {
                    this.mStartingSurface.cancel(true);
                }
                this.stopDeferrableSurface();
            }
            return super.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setSingleRepeatingRequest(@NonNull CaptureRequest request, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        if (this.mEnabledFeature.contains("wait_for_request")) {
            Object object = this.mObjectLock;
            synchronized (object) {
                this.mHasSubmittedRepeating = true;
                CameraCaptureSession.CaptureCallback comboCaptureCallback = Camera2CaptureCallbacks.createComboCallback(this.mCaptureCallback, listener);
                return super.setSingleRepeatingRequest(request, comboCaptureCallback);
            }
        }
        return super.setSingleRepeatingRequest(request, listener);
    }

    @Override
    public void onConfigured(@NonNull SynchronizedCaptureSession session) {
        this.debugLog("Session onConfigured()");
        if (this.mEnabledFeature.contains("force_close")) {
            LinkedHashSet<SynchronizedCaptureSession> staleCreatingSessions = new LinkedHashSet<SynchronizedCaptureSession>();
            for (SynchronizedCaptureSession s : this.mCaptureSessionRepository.getCreatingCaptureSessions()) {
                if (s == session) break;
                staleCreatingSessions.add(s);
            }
            this.forceOnConfigureFailed(staleCreatingSessions);
        }
        super.onConfigured(session);
        if (this.mEnabledFeature.contains("force_close")) {
            LinkedHashSet<SynchronizedCaptureSession> openedSessions = new LinkedHashSet<SynchronizedCaptureSession>();
            for (SynchronizedCaptureSession s : this.mCaptureSessionRepository.getCaptureSessions()) {
                if (s == session) break;
                openedSessions.add(s);
            }
            SynchronizedCaptureSessionImpl.forceOnClosed(openedSessions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.debugLog("Session call close()");
        if (this.mEnabledFeature.contains("wait_for_request")) {
            Object object = this.mObjectLock;
            synchronized (object) {
                if (!this.mHasSubmittedRepeating) {
                    this.mStartStreamingFuture.cancel(true);
                }
            }
        }
        this.mStartStreamingFuture.addListener(() -> {
            this.debugLog("Session call super.close()");
            super.close();
        }, this.getExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeConfiguredDeferrableSurfaces() {
        Object object = this.mObjectLock;
        synchronized (object) {
            if (this.mDeferrableSurfaces == null) {
                this.debugLog("deferrableSurface == null, maybe forceClose, skip close");
                return;
            }
            if (this.mEnabledFeature.contains("deferrableSurface_close")) {
                for (DeferrableSurface deferrableSurface : this.mDeferrableSurfaces) {
                    deferrableSurface.close();
                }
                this.debugLog("deferrableSurface closed");
                this.stopDeferrableSurface();
            }
        }
    }

    void stopDeferrableSurface() {
        if (this.mEnabledFeature.contains("deferrableSurface_close")) {
            this.mCaptureSessionRepository.unregisterDeferrableSurface(this);
            if (this.mClosingDeferrableSurfaceCompleter != null) {
                this.mClosingDeferrableSurfaceCompleter.set(null);
            }
        }
    }

    @Override
    public void onClosed(@NonNull SynchronizedCaptureSession session) {
        this.closeConfiguredDeferrableSurfaces();
        this.debugLog("onClosed()");
        super.onClosed(session);
    }

    static void forceOnClosed(@NonNull Set<SynchronizedCaptureSession> sessions) {
        for (SynchronizedCaptureSession session : sessions) {
            session.getStateCallback().onClosed(session);
        }
    }

    private void forceOnConfigureFailed(@NonNull Set<SynchronizedCaptureSession> sessions) {
        for (SynchronizedCaptureSession session : sessions) {
            session.getStateCallback().onConfigureFailed(session);
        }
    }

    void debugLog(String message) {
        Logger.d((String)TAG, (String)("[" + this + "] " + message));
    }
}

