/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.experimental.UseExperimental;
import androidx.camera.camera2.impl.CameraEventCallbacks;
import androidx.camera.camera2.interop.CaptureRequestOptions;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import java.util.Iterator;

@UseExperimental(markerClass=ExperimentalCamera2Interop.class)
public final class Camera2ImplConfig
extends CaptureRequestOptions {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String CAPTURE_REQUEST_ID_STEM = "camera2.captureRequest.option.";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final Config.Option<Integer> TEMPLATE_TYPE_OPTION = Config.Option.create((String)"camera2.captureRequest.templateType", Integer.TYPE);
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final Config.Option<CameraDevice.StateCallback> DEVICE_STATE_CALLBACK_OPTION = Config.Option.create((String)"camera2.cameraDevice.stateCallback", CameraDevice.StateCallback.class);
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final Config.Option<CameraCaptureSession.StateCallback> SESSION_STATE_CALLBACK_OPTION = Config.Option.create((String)"camera2.cameraCaptureSession.stateCallback", CameraCaptureSession.StateCallback.class);
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final Config.Option<CameraCaptureSession.CaptureCallback> SESSION_CAPTURE_CALLBACK_OPTION = Config.Option.create((String)"camera2.cameraCaptureSession.captureCallback", CameraCaptureSession.CaptureCallback.class);
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final Config.Option<CameraEventCallbacks> CAMERA_EVENT_CALLBACK_OPTION = Config.Option.create((String)"camera2.cameraEvent.callback", CameraEventCallbacks.class);
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final Config.Option<Object> CAPTURE_REQUEST_TAG_OPTION = Config.Option.create((String)"camera2.captureRequest.tag", Object.class);

    public Camera2ImplConfig(@NonNull Config config) {
        super(config);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public static Config.Option<Object> createCaptureRequestOption(@NonNull CaptureRequest.Key<?> key) {
        return Config.Option.create((String)(CAPTURE_REQUEST_ID_STEM + key.getName()), Object.class, key);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public CaptureRequestOptions getCaptureRequestOptions() {
        return CaptureRequestOptions.Builder.from(this.getConfig()).build();
    }

    public int getCaptureRequestTemplate(int valueIfMissing) {
        return (Integer)this.getConfig().retrieveOption(TEMPLATE_TYPE_OPTION, (Object)valueIfMissing);
    }

    @Nullable
    public CameraDevice.StateCallback getDeviceStateCallback(@Nullable CameraDevice.StateCallback valueIfMissing) {
        return (CameraDevice.StateCallback)this.getConfig().retrieveOption(DEVICE_STATE_CALLBACK_OPTION, (Object)valueIfMissing);
    }

    @Nullable
    public CameraCaptureSession.StateCallback getSessionStateCallback(@Nullable CameraCaptureSession.StateCallback valueIfMissing) {
        return (CameraCaptureSession.StateCallback)this.getConfig().retrieveOption(SESSION_STATE_CALLBACK_OPTION, (Object)valueIfMissing);
    }

    @Nullable
    public CameraCaptureSession.CaptureCallback getSessionCaptureCallback(@Nullable CameraCaptureSession.CaptureCallback valueIfMissing) {
        return (CameraCaptureSession.CaptureCallback)this.getConfig().retrieveOption(SESSION_CAPTURE_CALLBACK_OPTION, (Object)valueIfMissing);
    }

    @Nullable
    public CameraEventCallbacks getCameraEventCallback(@Nullable CameraEventCallbacks valueIfMissing) {
        return (CameraEventCallbacks)((Object)this.getConfig().retrieveOption(CAMERA_EVENT_CALLBACK_OPTION, (Object)valueIfMissing));
    }

    @Nullable
    public Object getCaptureRequestTag(@Nullable Object valueIfMissing) {
        return this.getConfig().retrieveOption(CAPTURE_REQUEST_TAG_OPTION, valueIfMissing);
    }

    public static final class Extender<T> {
        ExtendableBuilder<T> mBaseBuilder;

        public Extender(@NonNull ExtendableBuilder<T> baseBuilder) {
            this.mBaseBuilder = baseBuilder;
        }

        @NonNull
        public Extender<T> setCameraEventCallback(@NonNull CameraEventCallbacks cameraEventCallbacks) {
            this.mBaseBuilder.getMutableConfig().insertOption(CAMERA_EVENT_CALLBACK_OPTION, (Object)cameraEventCallbacks);
            return this;
        }
    }

    public static final class Builder
    implements ExtendableBuilder<Camera2ImplConfig> {
        private final MutableOptionsBundle mMutableOptionsBundle = MutableOptionsBundle.create();

        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableOptionsBundle;
        }

        @NonNull
        public <ValueT> Builder setCaptureRequestOption(@NonNull CaptureRequest.Key<ValueT> key, @NonNull ValueT value) {
            Config.Option<Object> opt = Camera2ImplConfig.createCaptureRequestOption(key);
            this.mMutableOptionsBundle.insertOption(opt, value);
            return this;
        }

        @NonNull
        public <ValueT> Builder setCaptureRequestOptionWithPriority(@NonNull CaptureRequest.Key<ValueT> key, @NonNull ValueT value, @NonNull Config.OptionPriority priority) {
            Config.Option<Object> opt = Camera2ImplConfig.createCaptureRequestOption(key);
            this.mMutableOptionsBundle.insertOption(opt, priority, value);
            return this;
        }

        @NonNull
        public Builder insertAllOptions(@NonNull Config config) {
            Iterator iterator = config.listOptions().iterator();
            while (iterator.hasNext()) {
                Config.Option option;
                Config.Option objectOpt = option = (Config.Option)iterator.next();
                this.mMutableOptionsBundle.insertOption(objectOpt, config.retrieveOption(objectOpt));
            }
            return this;
        }

        @NonNull
        public Camera2ImplConfig build() {
            return new Camera2ImplConfig((Config)OptionsBundle.from((Config)this.mMutableOptionsBundle));
        }
    }
}

