/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.graphics.Point;
import android.util.Size;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.Camera2CaptureOptionUnpacker;
import androidx.camera.camera2.internal.Camera2SessionOptionUnpacker;
import androidx.camera.camera2.internal.ImageCaptureOptionUnpacker;
import androidx.camera.camera2.internal.compat.workaround.PreviewPixelHDRnet;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;

public final class Camera2UseCaseConfigFactory
implements UseCaseConfigFactory {
    private static final Size MAX_PREVIEW_SIZE = new Size(1920, 1080);
    final WindowManager mWindowManager;

    public Camera2UseCaseConfigFactory(@NonNull Context context) {
        this.mWindowManager = (WindowManager)context.getSystemService("window");
    }

    @Nullable
    public Config getConfig(@NonNull UseCaseConfigFactory.CaptureType captureType) {
        MutableOptionsBundle mutableConfig = MutableOptionsBundle.create();
        SessionConfig.Builder sessionBuilder = new SessionConfig.Builder();
        sessionBuilder.setTemplateType(1);
        if (captureType == UseCaseConfigFactory.CaptureType.PREVIEW) {
            PreviewPixelHDRnet.setHDRnet(sessionBuilder);
        }
        mutableConfig.insertOption(UseCaseConfig.OPTION_DEFAULT_SESSION_CONFIG, (Object)sessionBuilder.build());
        mutableConfig.insertOption(UseCaseConfig.OPTION_SESSION_CONFIG_UNPACKER, (Object)Camera2SessionOptionUnpacker.INSTANCE);
        CaptureConfig.Builder captureBuilder = new CaptureConfig.Builder();
        switch (captureType) {
            case IMAGE_CAPTURE: {
                captureBuilder.setTemplateType(2);
                break;
            }
            case PREVIEW: 
            case IMAGE_ANALYSIS: 
            case VIDEO_CAPTURE: {
                captureBuilder.setTemplateType(1);
            }
        }
        mutableConfig.insertOption(UseCaseConfig.OPTION_DEFAULT_CAPTURE_CONFIG, (Object)captureBuilder.build());
        mutableConfig.insertOption(UseCaseConfig.OPTION_CAPTURE_CONFIG_UNPACKER, (Object)(captureType == UseCaseConfigFactory.CaptureType.IMAGE_CAPTURE ? ImageCaptureOptionUnpacker.INSTANCE : Camera2CaptureOptionUnpacker.INSTANCE));
        if (captureType == UseCaseConfigFactory.CaptureType.PREVIEW) {
            mutableConfig.insertOption(ImageOutputConfig.OPTION_MAX_RESOLUTION, (Object)this.getPreviewSize());
        }
        int targetRotation = this.mWindowManager.getDefaultDisplay().getRotation();
        mutableConfig.insertOption(ImageOutputConfig.OPTION_TARGET_ROTATION, (Object)targetRotation);
        return OptionsBundle.from((Config)mutableConfig);
    }

    private Size getPreviewSize() {
        Point displaySize = new Point();
        this.mWindowManager.getDefaultDisplay().getRealSize(displaySize);
        Size displayViewSize = displaySize.x > displaySize.y ? new Size(displaySize.x, displaySize.y) : new Size(displaySize.y, displaySize.x);
        return displayViewSize.getWidth() * displayViewSize.getHeight() > MAX_PREVIEW_SIZE.getWidth() * MAX_PREVIEW_SIZE.getHeight() ? MAX_PREVIEW_SIZE : displayViewSize;
    }
}

