/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCharacteristics;
import android.util.Range;
import android.util.Rational;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.core.ExperimentalExposureCompensation;
import androidx.camera.core.ExposureState;

@ExperimentalExposureCompensation
class ExposureStateImpl
implements ExposureState {
    private final Object mLock = new Object();
    private final CameraCharacteristicsCompat mCameraCharacteristics;
    @GuardedBy(value="mLock")
    private int mExposureCompensation;

    ExposureStateImpl(CameraCharacteristicsCompat characteristics, int exposureCompensation) {
        this.mCameraCharacteristics = characteristics;
        this.mExposureCompensation = exposureCompensation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExposureCompensationIndex() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mExposureCompensation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExposureCompensationIndex(int value) {
        Object object = this.mLock;
        synchronized (object) {
            this.mExposureCompensation = value;
        }
    }

    @NonNull
    public Range<Integer> getExposureCompensationRange() {
        return (Range)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
    }

    @NonNull
    public Rational getExposureCompensationStep() {
        if (!this.isExposureCompensationSupported()) {
            return Rational.ZERO;
        }
        return (Rational)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
    }

    public boolean isExposureCompensationSupported() {
        Range compensationRange = (Range)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        return compensationRange != null && (Integer)compensationRange.getLower() != 0 && (Integer)compensationRange.getUpper() != 0;
    }
}

