/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import androidx.annotation.NonNull;
import androidx.camera.camera2.internal.Camera2CameraControlImpl;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.core.CameraControl;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

final class TorchControl {
    private static final String TAG = "TorchControl";
    static final int DEFAULT_TORCH_STATE = 0;
    private final Camera2CameraControlImpl mCamera2CameraControlImpl;
    private final MutableLiveData<Integer> mTorchState;
    private final boolean mHasFlashUnit;
    private final Executor mExecutor;
    private boolean mIsActive;
    CallbackToFutureAdapter.Completer<Void> mEnableTorchCompleter;
    boolean mTargetTorchEnabled;
    private final Camera2CameraControlImpl.CaptureResultListener mCaptureResultListener = new Camera2CameraControlImpl.CaptureResultListener(){

        @Override
        public boolean onCaptureResult(@NonNull TotalCaptureResult captureResult) {
            if (TorchControl.this.mEnableTorchCompleter != null) {
                boolean torchEnabled;
                CaptureRequest captureRequest = captureResult.getRequest();
                Integer flashMode = (Integer)captureRequest.get(CaptureRequest.FLASH_MODE);
                boolean bl = torchEnabled = flashMode != null && flashMode == 2;
                if (torchEnabled == TorchControl.this.mTargetTorchEnabled) {
                    TorchControl.this.mEnableTorchCompleter.set(null);
                    TorchControl.this.mEnableTorchCompleter = null;
                }
            }
            return false;
        }
    };

    TorchControl(@NonNull Camera2CameraControlImpl camera2CameraControlImpl, @NonNull CameraCharacteristicsCompat cameraCharacteristics, @NonNull Executor executor) {
        this.mCamera2CameraControlImpl = camera2CameraControlImpl;
        this.mExecutor = executor;
        Boolean hasFlashUnit = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        this.mHasFlashUnit = hasFlashUnit != null && hasFlashUnit != false;
        this.mTorchState = new MutableLiveData((Object)0);
        this.mCamera2CameraControlImpl.addCaptureResultListener(this.mCaptureResultListener);
    }

    void setActive(boolean isActive) {
        if (this.mIsActive == isActive) {
            return;
        }
        this.mIsActive = isActive;
        if (!isActive) {
            if (this.mTargetTorchEnabled) {
                this.mTargetTorchEnabled = false;
                this.mCamera2CameraControlImpl.enableTorchInternal(false);
                this.setLiveDataValue(this.mTorchState, 0);
            }
            if (this.mEnableTorchCompleter != null) {
                this.mEnableTorchCompleter.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
                this.mEnableTorchCompleter = null;
            }
        }
    }

    ListenableFuture<Void> enableTorch(boolean enabled) {
        if (!this.mHasFlashUnit) {
            Logger.d((String)TAG, (String)"Unable to enableTorch due to there is no flash unit.");
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("No flash unit"));
        }
        this.setLiveDataValue(this.mTorchState, enabled ? 1 : 0);
        return CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> this.enableTorchInternal((CallbackToFutureAdapter.Completer<Void>)completer, enabled));
            return "enableTorch: " + enabled;
        });
    }

    @NonNull
    LiveData<Integer> getTorchState() {
        return this.mTorchState;
    }

    void enableTorchInternal(@NonNull CallbackToFutureAdapter.Completer<Void> completer, boolean enabled) {
        if (!this.mIsActive) {
            this.setLiveDataValue(this.mTorchState, 0);
            completer.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            return;
        }
        this.mTargetTorchEnabled = enabled;
        this.mCamera2CameraControlImpl.enableTorchInternal(enabled);
        this.setLiveDataValue(this.mTorchState, enabled ? 1 : 0);
        if (this.mEnableTorchCompleter != null) {
            this.mEnableTorchCompleter.setException((Throwable)new CameraControl.OperationCanceledException("There is a new enableTorch being set"));
        }
        this.mEnableTorchCompleter = completer;
    }

    private <T> void setLiveDataValue(@NonNull MutableLiveData<T> liveData, T value) {
        if (Threads.isMainThread()) {
            liveData.setValue(value);
        } else {
            liveData.postValue(value);
        }
    }
}

