/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraCharacteristics;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;

public class CameraCharacteristicsCompat {
    @NonNull
    @GuardedBy(value="this")
    private final Map<CameraCharacteristics.Key<?>, Object> mValuesCache = new HashMap();
    @NonNull
    private final CameraCharacteristics mCameraCharacteristics;

    private CameraCharacteristicsCompat(@NonNull CameraCharacteristics cameraCharacteristics) {
        this.mCameraCharacteristics = cameraCharacteristics;
    }

    @VisibleForTesting(otherwise=3)
    @NonNull
    public static CameraCharacteristicsCompat toCameraCharacteristicsCompat(@NonNull CameraCharacteristics characteristics) {
        return new CameraCharacteristicsCompat(characteristics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T get(@NonNull CameraCharacteristics.Key<T> key) {
        CameraCharacteristicsCompat cameraCharacteristicsCompat = this;
        synchronized (cameraCharacteristicsCompat) {
            Object value = this.mValuesCache.get(key);
            if (value != null) {
                return (T)value;
            }
            value = this.mCameraCharacteristics.get(key);
            if (value != null) {
                this.mValuesCache.put(key, value);
            }
            return (T)value;
        }
    }

    @NonNull
    public CameraCharacteristics toCameraCharacteristics() {
        return this.mCameraCharacteristics;
    }
}

