/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.interop;

import androidx.annotation.NonNull;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ExperimentalCamera2Interop
public final class Camera2CameraFilter {
    @NonNull
    public static CameraFilter createCameraFilter(@NonNull Camera2Filter filter) {
        return cameraInfos -> {
            ArrayList<Camera2CameraInfo> input = new ArrayList<Camera2CameraInfo>();
            for (CameraInfo cameraInfo : cameraInfos) {
                input.add(Camera2CameraInfo.from(cameraInfo));
            }
            List<Camera2CameraInfo> result = filter.filter(Collections.unmodifiableList(input));
            ArrayList<CameraInfo> output = new ArrayList<CameraInfo>();
            for (CameraInfo cameraInfo : cameraInfos) {
                if (!result.contains(Camera2CameraInfo.from(cameraInfo))) continue;
                output.add(cameraInfo);
            }
            return output;
        };
    }

    private Camera2CameraFilter() {
    }

    public static interface Camera2Filter {
        @NonNull
        public List<Camera2CameraInfo> filter(@NonNull List<Camera2CameraInfo> var1);
    }
}

