/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.media.CamcorderProfile;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.quirk.CamcorderProfileResolutionQuirk;
import androidx.camera.camera2.internal.compat.quirk.CameraQuirks;
import androidx.camera.camera2.internal.compat.workaround.CamcorderProfileResolutionValidator;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CamcorderProfileProvider;
import androidx.camera.core.impl.CamcorderProfileProxy;

public class Camera2CamcorderProfileProvider
implements CamcorderProfileProvider {
    private static final String TAG = "Camera2CamcorderProfileProvider";
    private final boolean mHasValidCameraId;
    private final int mCameraId;
    private final CamcorderProfileResolutionValidator mCamcorderProfileResolutionValidator;

    public Camera2CamcorderProfileProvider(@NonNull String cameraId, @NonNull CameraCharacteristicsCompat cameraCharacteristics) {
        boolean hasValidCameraId = false;
        int intCameraId = -1;
        try {
            intCameraId = Integer.parseInt(cameraId);
            hasValidCameraId = true;
        }
        catch (NumberFormatException e) {
            Logger.w((String)TAG, (String)("Camera id is not an integer: " + cameraId + ", unable to create CamcorderProfileProvider"));
        }
        this.mHasValidCameraId = hasValidCameraId;
        this.mCameraId = intCameraId;
        CamcorderProfileResolutionQuirk quirk = (CamcorderProfileResolutionQuirk)CameraQuirks.get(cameraId, cameraCharacteristics).get(CamcorderProfileResolutionQuirk.class);
        this.mCamcorderProfileResolutionValidator = new CamcorderProfileResolutionValidator(quirk);
    }

    public boolean hasProfile(int quality) {
        if (!this.mHasValidCameraId) {
            return false;
        }
        if (!CamcorderProfile.hasProfile((int)this.mCameraId, (int)quality)) {
            return false;
        }
        if (this.mCamcorderProfileResolutionValidator.hasQuirk()) {
            CamcorderProfileProxy profile = this.getProfileInternal(quality);
            return this.mCamcorderProfileResolutionValidator.hasValidVideoResolution(profile);
        }
        return true;
    }

    @Nullable
    public CamcorderProfileProxy get(int quality) {
        if (!this.mHasValidCameraId) {
            return null;
        }
        if (!CamcorderProfile.hasProfile((int)this.mCameraId, (int)quality)) {
            return null;
        }
        CamcorderProfileProxy profile = this.getProfileInternal(quality);
        if (!this.mCamcorderProfileResolutionValidator.hasValidVideoResolution(profile)) {
            return null;
        }
        return profile;
    }

    @Nullable
    private CamcorderProfileProxy getProfileInternal(int quality) {
        CamcorderProfile profile = null;
        try {
            profile = CamcorderProfile.get((int)this.mCameraId, (int)quality);
        }
        catch (RuntimeException e) {
            Logger.w((String)TAG, (String)("Unable to get CamcorderProfile by quality: " + quality), (Throwable)e);
        }
        return profile != null ? CamcorderProfileProxy.fromCamcorderProfile((CamcorderProfile)profile) : null;
    }
}

