/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCharacteristics;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.Camera2CameraFactory;
import androidx.camera.camera2.internal.Camera2CameraInfoImpl;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.InitializationException;
import androidx.camera.core.impl.CameraInfoInternal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class CameraSelectionOptimizer {
    private CameraSelectionOptimizer() {
    }

    static List<String> getSelectedAvailableCameraIds(@NonNull Camera2CameraFactory cameraFactory, @Nullable CameraSelector availableCamerasSelector) throws InitializationException {
        try {
            String skippedCameraId;
            ArrayList<String> availableCameraIds = new ArrayList<String>();
            List<String> cameraIdList = Arrays.asList(cameraFactory.getCameraManager().getCameraIdList());
            if (availableCamerasSelector == null) {
                for (String id : cameraIdList) {
                    availableCameraIds.add(id);
                }
                return availableCameraIds;
            }
            try {
                Integer lensFacingInteger = availableCamerasSelector.getLensFacing();
                skippedCameraId = CameraSelectionOptimizer.decideSkippedCameraIdByHeuristic(cameraFactory.getCameraManager(), lensFacingInteger, cameraIdList);
            }
            catch (IllegalStateException e) {
                skippedCameraId = null;
            }
            ArrayList<Camera2CameraInfoImpl> cameraInfos = new ArrayList<Camera2CameraInfoImpl>();
            for (String id : cameraIdList) {
                if (id.equals(skippedCameraId)) continue;
                Camera2CameraInfoImpl cameraInfo = cameraFactory.getCameraInfo(id);
                cameraInfos.add(cameraInfo);
            }
            try {
                List filteredCameraInfos = availableCamerasSelector.filter(cameraInfos);
                for (Camera2CameraInfoImpl cameraInfo : filteredCameraInfos) {
                    String cameraId = ((CameraInfoInternal)cameraInfo).getCameraId();
                    availableCameraIds.add(cameraId);
                }
            }
            catch (IllegalArgumentException e) {
                return availableCameraIds;
            }
            return availableCameraIds;
        }
        catch (CameraAccessExceptionCompat e) {
            throw new InitializationException((Throwable)CameraUnavailableExceptionHelper.createFrom(e));
        }
        catch (CameraUnavailableException e) {
            throw new InitializationException((Throwable)e);
        }
    }

    private static String decideSkippedCameraIdByHeuristic(CameraManagerCompat cameraManager, Integer lensFacingInteger, List<String> cameraIdList) throws CameraAccessExceptionCompat {
        String skippedCameraId = null;
        if (lensFacingInteger == null) {
            return null;
        }
        if (!cameraIdList.contains("0") || !cameraIdList.contains("1")) {
            return null;
        }
        if (lensFacingInteger == 1) {
            if ((Integer)cameraManager.getCameraCharacteristicsCompat("0").get(CameraCharacteristics.LENS_FACING) == 1) {
                skippedCameraId = "1";
            }
        } else if (lensFacingInteger == 0 && (Integer)cameraManager.getCameraCharacteristicsCompat("1").get(CameraCharacteristics.LENS_FACING) == 0) {
            skippedCameraId = "0";
        }
        return skippedCameraId;
    }
}

