/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraDevice;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.camera.camera2.internal.SynchronizedCaptureSession;
import androidx.camera.core.impl.DeferrableSurface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

class CaptureSessionRepository {
    @NonNull
    final Executor mExecutor;
    final Object mLock = new Object();
    @GuardedBy(value="mLock")
    final Set<SynchronizedCaptureSession> mCaptureSessions = new LinkedHashSet<SynchronizedCaptureSession>();
    @GuardedBy(value="mLock")
    final Set<SynchronizedCaptureSession> mClosingCaptureSession = new LinkedHashSet<SynchronizedCaptureSession>();
    @GuardedBy(value="mLock")
    final Set<SynchronizedCaptureSession> mCreatingCaptureSessions = new LinkedHashSet<SynchronizedCaptureSession>();
    @GuardedBy(value="mLock")
    final Map<SynchronizedCaptureSession, List<DeferrableSurface>> mDeferrableSurfaceMap = new HashMap<SynchronizedCaptureSession, List<DeferrableSurface>>();
    private final CameraDevice.StateCallback mCameraStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(@NonNull CameraDevice camera) {
        }

        public void onError(@NonNull CameraDevice camera, int error) {
            this.forceOnClosedCaptureSessions();
        }

        public void onDisconnected(@NonNull CameraDevice camera) {
            this.forceOnClosedCaptureSessions();
        }

        private void forceOnClosedCaptureSessions() {
            CaptureSessionRepository.this.mExecutor.execute(() -> {
                LinkedHashSet<SynchronizedCaptureSession> sessions = new LinkedHashSet<SynchronizedCaptureSession>();
                Object object = CaptureSessionRepository.this.mLock;
                synchronized (object) {
                    sessions.addAll(new LinkedHashSet<SynchronizedCaptureSession>(CaptureSessionRepository.this.mCreatingCaptureSessions));
                    sessions.addAll(new LinkedHashSet<SynchronizedCaptureSession>(CaptureSessionRepository.this.mCaptureSessions));
                }
                CaptureSessionRepository.forceOnClosed(sessions);
            });
        }
    };

    CaptureSessionRepository(@NonNull Executor executor) {
        this.mExecutor = executor;
    }

    @NonNull
    CameraDevice.StateCallback getCameraStateCallback() {
        return this.mCameraStateCallback;
    }

    static void forceOnClosed(@NonNull Set<SynchronizedCaptureSession> sessions) {
        for (SynchronizedCaptureSession session : sessions) {
            session.getStateCallback().onClosed(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    List<SynchronizedCaptureSession> getCaptureSessions() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<SynchronizedCaptureSession>(this.mCaptureSessions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    List<SynchronizedCaptureSession> getClosingCaptureSession() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<SynchronizedCaptureSession>(this.mClosingCaptureSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    List<SynchronizedCaptureSession> getCreatingCaptureSessions() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<SynchronizedCaptureSession>(this.mCreatingCaptureSessions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<SynchronizedCaptureSession, List<DeferrableSurface>> registerDeferrableSurface(@NonNull SynchronizedCaptureSession synchronizedCaptureSession, @NonNull List<DeferrableSurface> deferrableSurfaces) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDeferrableSurfaceMap.put(synchronizedCaptureSession, deferrableSurfaces);
            return new HashMap<SynchronizedCaptureSession, List<DeferrableSurface>>(this.mDeferrableSurfaceMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterDeferrableSurface(@NonNull SynchronizedCaptureSession synchronizedCaptureSession) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDeferrableSurfaceMap.remove(synchronizedCaptureSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCreateCaptureSession(@NonNull SynchronizedCaptureSession synchronizedCaptureSession) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCreatingCaptureSessions.add(synchronizedCaptureSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCaptureSessionConfigureFail(@NonNull SynchronizedCaptureSession synchronizedCaptureSession) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCreatingCaptureSessions.remove(synchronizedCaptureSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCaptureSessionCreated(@NonNull SynchronizedCaptureSession synchronizedCaptureSession) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCaptureSessions.add(synchronizedCaptureSession);
            this.mCreatingCaptureSessions.remove(synchronizedCaptureSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCaptureSessionClosed(@NonNull SynchronizedCaptureSession synchronizedCaptureSession) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCaptureSessions.remove(synchronizedCaptureSession);
            this.mClosingCaptureSession.remove(synchronizedCaptureSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCaptureSessionClosing(@NonNull SynchronizedCaptureSession synchronizedCaptureSession) {
        Object object = this.mLock;
        synchronized (object) {
            this.mClosingCaptureSession.add(synchronizedCaptureSession);
        }
    }
}

