/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.graphics.Rect;
import android.hardware.camera2.CaptureResult;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraCaptureMetaData;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.TagBundle;
import androidx.camera.core.impl.utils.ExifData;

@RequiresApi(value=21)
public class Camera2CameraCaptureResult
implements CameraCaptureResult {
    private static final String TAG = "C2CameraCaptureResult";
    private final TagBundle mTagBundle;
    private final CaptureResult mCaptureResult;

    public Camera2CameraCaptureResult(@NonNull TagBundle tagBundle, @NonNull CaptureResult captureResult) {
        this.mTagBundle = tagBundle;
        this.mCaptureResult = captureResult;
    }

    public Camera2CameraCaptureResult(@NonNull CaptureResult captureResult) {
        this(TagBundle.emptyBundle(), captureResult);
    }

    @NonNull
    public CameraCaptureMetaData.AfMode getAfMode() {
        Integer mode = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AF_MODE);
        if (mode == null) {
            return CameraCaptureMetaData.AfMode.UNKNOWN;
        }
        switch (mode) {
            case 0: 
            case 5: {
                return CameraCaptureMetaData.AfMode.OFF;
            }
            case 1: 
            case 2: {
                return CameraCaptureMetaData.AfMode.ON_MANUAL_AUTO;
            }
            case 3: 
            case 4: {
                return CameraCaptureMetaData.AfMode.ON_CONTINUOUS_AUTO;
            }
        }
        Logger.e((String)TAG, (String)("Undefined af mode: " + mode));
        return CameraCaptureMetaData.AfMode.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.AfState getAfState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AF_STATE);
        if (state == null) {
            return CameraCaptureMetaData.AfState.UNKNOWN;
        }
        switch (state) {
            case 0: {
                return CameraCaptureMetaData.AfState.INACTIVE;
            }
            case 1: 
            case 3: {
                return CameraCaptureMetaData.AfState.SCANNING;
            }
            case 4: {
                return CameraCaptureMetaData.AfState.LOCKED_FOCUSED;
            }
            case 5: {
                return CameraCaptureMetaData.AfState.LOCKED_NOT_FOCUSED;
            }
            case 6: {
                return CameraCaptureMetaData.AfState.PASSIVE_NOT_FOCUSED;
            }
            case 2: {
                return CameraCaptureMetaData.AfState.PASSIVE_FOCUSED;
            }
        }
        Logger.e((String)TAG, (String)("Undefined af state: " + state));
        return CameraCaptureMetaData.AfState.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.AeState getAeState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AE_STATE);
        if (state == null) {
            return CameraCaptureMetaData.AeState.UNKNOWN;
        }
        switch (state) {
            case 0: {
                return CameraCaptureMetaData.AeState.INACTIVE;
            }
            case 1: 
            case 5: {
                return CameraCaptureMetaData.AeState.SEARCHING;
            }
            case 4: {
                return CameraCaptureMetaData.AeState.FLASH_REQUIRED;
            }
            case 2: {
                return CameraCaptureMetaData.AeState.CONVERGED;
            }
            case 3: {
                return CameraCaptureMetaData.AeState.LOCKED;
            }
        }
        Logger.e((String)TAG, (String)("Undefined ae state: " + state));
        return CameraCaptureMetaData.AeState.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.AwbState getAwbState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AWB_STATE);
        if (state == null) {
            return CameraCaptureMetaData.AwbState.UNKNOWN;
        }
        switch (state) {
            case 0: {
                return CameraCaptureMetaData.AwbState.INACTIVE;
            }
            case 1: {
                return CameraCaptureMetaData.AwbState.METERING;
            }
            case 2: {
                return CameraCaptureMetaData.AwbState.CONVERGED;
            }
            case 3: {
                return CameraCaptureMetaData.AwbState.LOCKED;
            }
        }
        Logger.e((String)TAG, (String)("Undefined awb state: " + state));
        return CameraCaptureMetaData.AwbState.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.FlashState getFlashState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.FLASH_STATE);
        if (state == null) {
            return CameraCaptureMetaData.FlashState.UNKNOWN;
        }
        switch (state) {
            case 0: 
            case 1: {
                return CameraCaptureMetaData.FlashState.NONE;
            }
            case 2: {
                return CameraCaptureMetaData.FlashState.READY;
            }
            case 3: 
            case 4: {
                return CameraCaptureMetaData.FlashState.FIRED;
            }
        }
        Logger.e((String)TAG, (String)("Undefined flash state: " + state));
        return CameraCaptureMetaData.FlashState.UNKNOWN;
    }

    public long getTimestamp() {
        Long timestamp = (Long)this.mCaptureResult.get(CaptureResult.SENSOR_TIMESTAMP);
        if (timestamp == null) {
            return -1L;
        }
        return timestamp;
    }

    @NonNull
    public TagBundle getTagBundle() {
        return this.mTagBundle;
    }

    public void populateExifData(@NonNull ExifData.Builder exifData) {
        Integer whiteBalanceMode;
        Float focalLength;
        Integer iso;
        Float aperture;
        Long exposureTimeNs;
        Integer jpegOrientation;
        super.populateExifData(exifData);
        Rect cropRegion = (Rect)this.mCaptureResult.get(CaptureResult.SCALER_CROP_REGION);
        if (cropRegion != null) {
            exifData.setImageWidth(cropRegion.width()).setImageHeight(cropRegion.height());
        }
        if ((jpegOrientation = (Integer)this.mCaptureResult.get(CaptureResult.JPEG_ORIENTATION)) != null) {
            exifData.setOrientationDegrees(jpegOrientation.intValue());
        }
        if ((exposureTimeNs = (Long)this.mCaptureResult.get(CaptureResult.SENSOR_EXPOSURE_TIME)) != null) {
            exifData.setExposureTimeNanos(exposureTimeNs.longValue());
        }
        if ((aperture = (Float)this.mCaptureResult.get(CaptureResult.LENS_APERTURE)) != null) {
            exifData.setLensFNumber(aperture.floatValue());
        }
        if ((iso = (Integer)this.mCaptureResult.get(CaptureResult.SENSOR_SENSITIVITY)) != null) {
            Integer postRawSensitivityBoost;
            if (Build.VERSION.SDK_INT >= 24 && (postRawSensitivityBoost = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_POST_RAW_SENSITIVITY_BOOST)) != null) {
                iso = iso * (int)((float)postRawSensitivityBoost.intValue() / 100.0f);
            }
            exifData.setIso(iso.intValue());
        }
        if ((focalLength = (Float)this.mCaptureResult.get(CaptureResult.LENS_FOCAL_LENGTH)) != null) {
            exifData.setFocalLength(focalLength.floatValue());
        }
        if ((whiteBalanceMode = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AWB_MODE)) != null) {
            ExifData.WhiteBalanceMode wbMode = ExifData.WhiteBalanceMode.AUTO;
            if (whiteBalanceMode == 0) {
                wbMode = ExifData.WhiteBalanceMode.MANUAL;
            }
            exifData.setWhiteBalanceMode(wbMode);
        }
    }

    @NonNull
    public CaptureResult getCaptureResult() {
        return this.mCaptureResult;
    }
}

