/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.InputConfiguration;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageWriter;
import android.os.Build;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.ZslControl;
import androidx.camera.camera2.internal.ZslUtil;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.SafeCloseImageReaderProxy;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.compat.ImageWriterCompat;
import androidx.camera.core.internal.utils.ZslRingBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;

@RequiresApi(value=23)
final class ZslControlImpl
implements ZslControl {
    private static final String TAG = "ZslControlImpl";
    @VisibleForTesting
    static final int RING_BUFFER_CAPACITY = 3;
    @VisibleForTesting
    static final int MAX_IMAGES = 9;
    @NonNull
    private final Map<Integer, Size> mReprocessingInputSizeMap;
    @NonNull
    private final CameraCharacteristicsCompat mCameraCharacteristicsCompat;
    @VisibleForTesting
    @NonNull
    final ZslRingBuffer mImageRingBuffer;
    private boolean mIsZslDisabledByUseCaseConfig = false;
    private boolean mIsZslDisabledByFlashMode = false;
    private boolean mIsPrivateReprocessingSupported = false;
    SafeCloseImageReaderProxy mReprocessingImageReader;
    private CameraCaptureCallback mMetadataMatchingCaptureCallback;
    private DeferrableSurface mReprocessingImageDeferrableSurface;
    @Nullable
    ImageWriter mReprocessingImageWriter;

    ZslControlImpl(@NonNull CameraCharacteristicsCompat cameraCharacteristicsCompat) {
        this.mCameraCharacteristicsCompat = cameraCharacteristicsCompat;
        this.mIsPrivateReprocessingSupported = ZslUtil.isCapabilitySupported(this.mCameraCharacteristicsCompat, 4);
        this.mReprocessingInputSizeMap = this.createReprocessingInputSizeMap(this.mCameraCharacteristicsCompat);
        this.mImageRingBuffer = new ZslRingBuffer(3, imageProxy -> imageProxy.close());
    }

    @Override
    public void setZslDisabledByUserCaseConfig(boolean disabled) {
        this.mIsZslDisabledByUseCaseConfig = disabled;
    }

    @Override
    public boolean isZslDisabledByUserCaseConfig() {
        return this.mIsZslDisabledByUseCaseConfig;
    }

    @Override
    public void setZslDisabledByFlashMode(boolean disabled) {
        this.mIsZslDisabledByFlashMode = disabled;
    }

    @Override
    public boolean isZslDisabledByFlashMode() {
        return this.mIsZslDisabledByFlashMode;
    }

    @Override
    public void addZslConfig(@NonNull SessionConfig.Builder sessionConfigBuilder) {
        this.cleanup();
        if (this.mIsZslDisabledByUseCaseConfig) {
            return;
        }
        if (!this.mIsPrivateReprocessingSupported || this.mReprocessingInputSizeMap.isEmpty() || !this.mReprocessingInputSizeMap.containsKey(34) || !this.isJpegValidOutputForInputFormat(this.mCameraCharacteristicsCompat, 34)) {
            return;
        }
        int reprocessingImageFormat = 34;
        Size resolution = this.mReprocessingInputSizeMap.get(reprocessingImageFormat);
        MetadataImageReader metadataImageReader = new MetadataImageReader(resolution.getWidth(), resolution.getHeight(), reprocessingImageFormat, 9);
        this.mMetadataMatchingCaptureCallback = metadataImageReader.getCameraCaptureCallback();
        this.mReprocessingImageReader = new SafeCloseImageReaderProxy((ImageReaderProxy)metadataImageReader);
        metadataImageReader.setOnImageAvailableListener(imageReader -> {
            try {
                ImageProxy imageProxy = imageReader.acquireLatestImage();
                if (imageProxy != null) {
                    this.mImageRingBuffer.enqueue(imageProxy);
                }
            }
            catch (IllegalStateException e) {
                Logger.e((String)TAG, (String)("Failed to acquire latest image IllegalStateException = " + e.getMessage()));
            }
        }, CameraXExecutors.ioExecutor());
        this.mReprocessingImageDeferrableSurface = new ImmediateSurface(this.mReprocessingImageReader.getSurface(), new Size(this.mReprocessingImageReader.getWidth(), this.mReprocessingImageReader.getHeight()), reprocessingImageFormat);
        SafeCloseImageReaderProxy reprocessingImageReaderProxy = this.mReprocessingImageReader;
        this.mReprocessingImageDeferrableSurface.getTerminationFuture().addListener(() -> ((SafeCloseImageReaderProxy)reprocessingImageReaderProxy).safeClose(), (Executor)CameraXExecutors.mainThreadExecutor());
        sessionConfigBuilder.addSurface(this.mReprocessingImageDeferrableSurface);
        sessionConfigBuilder.addCameraCaptureCallback(this.mMetadataMatchingCaptureCallback);
        sessionConfigBuilder.addSessionStateCallback(new CameraCaptureSession.StateCallback(){

            public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                Surface surface = cameraCaptureSession.getInputSurface();
                if (surface != null) {
                    ZslControlImpl.this.mReprocessingImageWriter = ImageWriterCompat.newInstance((Surface)surface, (int)1);
                }
            }

            public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
            }
        });
        sessionConfigBuilder.setInputConfiguration(new InputConfiguration(this.mReprocessingImageReader.getWidth(), this.mReprocessingImageReader.getHeight(), this.mReprocessingImageReader.getImageFormat()));
    }

    @Override
    @Nullable
    public ImageProxy dequeueImageFromBuffer() {
        ImageProxy imageProxy = null;
        try {
            imageProxy = (ImageProxy)this.mImageRingBuffer.dequeue();
        }
        catch (NoSuchElementException e) {
            Logger.e((String)TAG, (String)"dequeueImageFromBuffer no such element");
        }
        return imageProxy;
    }

    @Override
    public boolean enqueueImageToImageWriter(@NonNull ImageProxy imageProxy) {
        Image image = imageProxy.getImage();
        if (Build.VERSION.SDK_INT >= 23 && this.mReprocessingImageWriter != null && image != null) {
            try {
                ImageWriterCompat.queueInputImage((ImageWriter)this.mReprocessingImageWriter, (Image)image);
            }
            catch (IllegalStateException e) {
                Logger.e((String)TAG, (String)("enqueueImageToImageWriter throws IllegalStateException = " + e.getMessage()));
                return false;
            }
            return true;
        }
        return false;
    }

    private void cleanup() {
        ImageWriter reprocessingImageWriter;
        ZslRingBuffer imageRingBuffer = this.mImageRingBuffer;
        while (!imageRingBuffer.isEmpty()) {
            ImageProxy imageProxy = (ImageProxy)imageRingBuffer.dequeue();
            imageProxy.close();
        }
        DeferrableSurface reprocessingImageDeferrableSurface = this.mReprocessingImageDeferrableSurface;
        if (reprocessingImageDeferrableSurface != null) {
            SafeCloseImageReaderProxy reprocessingImageReaderProxy = this.mReprocessingImageReader;
            if (reprocessingImageReaderProxy != null) {
                reprocessingImageDeferrableSurface.getTerminationFuture().addListener(() -> ((SafeCloseImageReaderProxy)reprocessingImageReaderProxy).safeClose(), (Executor)CameraXExecutors.mainThreadExecutor());
                this.mReprocessingImageReader = null;
            }
            reprocessingImageDeferrableSurface.close();
            this.mReprocessingImageDeferrableSurface = null;
        }
        if ((reprocessingImageWriter = this.mReprocessingImageWriter) != null) {
            reprocessingImageWriter.close();
            this.mReprocessingImageWriter = null;
        }
    }

    @NonNull
    private Map<Integer, Size> createReprocessingInputSizeMap(@NonNull CameraCharacteristicsCompat cameraCharacteristicsCompat) {
        StreamConfigurationMap map = (StreamConfigurationMap)cameraCharacteristicsCompat.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (map == null || map.getInputFormats() == null) {
            return new HashMap<Integer, Size>();
        }
        HashMap<Integer, Size> inputSizeMap = new HashMap<Integer, Size>();
        for (int format : map.getInputFormats()) {
            Size[] inputSizes = map.getInputSizes(format);
            if (inputSizes == null) continue;
            Arrays.sort(inputSizes, new CompareSizesByArea(true));
            inputSizeMap.put(format, inputSizes[0]);
        }
        return inputSizeMap;
    }

    private boolean isJpegValidOutputForInputFormat(@NonNull CameraCharacteristicsCompat cameraCharacteristicsCompat, int inputFormat) {
        StreamConfigurationMap map = (StreamConfigurationMap)cameraCharacteristicsCompat.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (map == null) {
            return false;
        }
        int[] validOutputFormats = map.getValidOutputFormatsForInput(inputFormat);
        if (validOutputFormats == null) {
            return false;
        }
        for (int outputFormat : validOutputFormats) {
            if (outputFormat != 256) continue;
            return true;
        }
        return false;
    }
}

