/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.graphics.Point;
import android.hardware.display.DisplayManager;
import android.util.Size;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.compat.workaround.MaxPreviewSize;

@RequiresApi(value=21)
public class DisplayInfoManager {
    private static final Size MAX_PREVIEW_SIZE = new Size(1920, 1080);
    private static final Object INSTANCE_LOCK = new Object();
    private static volatile DisplayInfoManager sInstance;
    @NonNull
    private final DisplayManager mDisplayManager;
    private volatile Size mPreviewSize = null;
    private final MaxPreviewSize mMaxPreviewSize = new MaxPreviewSize();

    private DisplayInfoManager(@NonNull Context context) {
        this.mDisplayManager = (DisplayManager)context.getSystemService("display");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static DisplayInfoManager getInstance(@NonNull Context context) {
        if (sInstance == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new DisplayInfoManager(context);
                }
            }
        }
        return sInstance;
    }

    @VisibleForTesting
    static void releaseInstance() {
        sInstance = null;
    }

    void refresh() {
        this.mPreviewSize = this.calculatePreviewSize();
    }

    @NonNull
    public Display getMaxSizeDisplay() {
        Display[] displays = this.mDisplayManager.getDisplays();
        if (displays.length == 1) {
            return displays[0];
        }
        Display maxDisplay = null;
        int maxDisplaySize = -1;
        for (Display display : displays) {
            if (display.getState() == 1) continue;
            Point displaySize = new Point();
            display.getRealSize(displaySize);
            if (displaySize.x * displaySize.y <= maxDisplaySize) continue;
            maxDisplaySize = displaySize.x * displaySize.y;
            maxDisplay = display;
        }
        if (maxDisplay == null) {
            throw new IllegalArgumentException("No display can be found from the input display manager!");
        }
        return maxDisplay;
    }

    @NonNull
    Size getPreviewSize() {
        if (this.mPreviewSize != null) {
            return this.mPreviewSize;
        }
        this.mPreviewSize = this.calculatePreviewSize();
        return this.mPreviewSize;
    }

    private Size calculatePreviewSize() {
        Point displaySize = new Point();
        Display display = this.getMaxSizeDisplay();
        display.getRealSize(displaySize);
        Size displayViewSize = displaySize.x > displaySize.y ? new Size(displaySize.x, displaySize.y) : new Size(displaySize.y, displaySize.x);
        if (displayViewSize.getWidth() * displayViewSize.getHeight() > MAX_PREVIEW_SIZE.getWidth() * MAX_PREVIEW_SIZE.getHeight()) {
            displayViewSize = MAX_PREVIEW_SIZE;
        }
        return this.mMaxPreviewSize.getMaxPreviewResolution(displayViewSize);
    }
}

