/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.media.CamcorderProfile;
import android.media.EncoderProfiles;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.internal.compat.quirk.InvalidVideoProfilesQuirk;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.compat.EncoderProfilesProxyCompat;
import java.util.HashMap;
import java.util.Map;

@RequiresApi(value=21)
public class Camera2EncoderProfilesProvider
implements EncoderProfilesProvider {
    private static final String TAG = "Camera2EncoderProfilesProvider";
    private final boolean mHasValidCameraId;
    private final String mCameraId;
    private final int mIntCameraId;
    private final Map<Integer, EncoderProfilesProxy> mEncoderProfilesCache = new HashMap<Integer, EncoderProfilesProxy>();

    public Camera2EncoderProfilesProvider(@NonNull String cameraId) {
        this.mCameraId = cameraId;
        boolean hasValidCameraId = false;
        int intCameraId = -1;
        try {
            intCameraId = Integer.parseInt(cameraId);
            hasValidCameraId = true;
        }
        catch (NumberFormatException e) {
            Logger.w((String)TAG, (String)("Camera id is not an integer: " + cameraId + ", unable to create Camera2EncoderProfilesProvider"));
        }
        this.mHasValidCameraId = hasValidCameraId;
        this.mIntCameraId = intCameraId;
    }

    public boolean hasProfile(int quality) {
        if (!this.mHasValidCameraId) {
            return false;
        }
        return CamcorderProfile.hasProfile((int)this.mIntCameraId, (int)quality);
    }

    @Nullable
    public EncoderProfilesProxy getAll(int quality) {
        if (!this.mHasValidCameraId) {
            return null;
        }
        if (!CamcorderProfile.hasProfile((int)this.mIntCameraId, (int)quality)) {
            return null;
        }
        if (this.mEncoderProfilesCache.containsKey(quality)) {
            return this.mEncoderProfilesCache.get(quality);
        }
        EncoderProfilesProxy profiles = this.getProfilesInternal(quality);
        this.mEncoderProfilesCache.put(quality, profiles);
        return profiles;
    }

    @Nullable
    private EncoderProfilesProxy getProfilesInternal(int quality) {
        if (Build.VERSION.SDK_INT >= 31) {
            boolean isVideoProfilesInvalid;
            EncoderProfiles profiles = Api31Impl.getAll(this.mCameraId, quality);
            if (profiles == null) {
                return null;
            }
            boolean bl = isVideoProfilesInvalid = DeviceQuirks.get(InvalidVideoProfilesQuirk.class) != null;
            if (isVideoProfilesInvalid) {
                Logger.d((String)TAG, (String)"EncoderProfiles contains invalid video profiles, use CamcorderProfile to create EncoderProfilesProxy.");
            } else {
                try {
                    return EncoderProfilesProxyCompat.from((EncoderProfiles)profiles);
                }
                catch (NullPointerException e) {
                    Logger.w((String)TAG, (String)"Failed to create EncoderProfilesProxy, EncoderProfiles might  contain invalid video profiles. Use CamcorderProfile instead.", (Throwable)e);
                }
            }
        }
        return this.createProfilesFromCamcorderProfile(quality);
    }

    @Nullable
    private EncoderProfilesProxy createProfilesFromCamcorderProfile(int quality) {
        CamcorderProfile profile = null;
        try {
            profile = CamcorderProfile.get((int)this.mIntCameraId, (int)quality);
        }
        catch (RuntimeException e) {
            Logger.w((String)TAG, (String)("Unable to get CamcorderProfile by quality: " + quality), (Throwable)e);
        }
        return profile != null ? EncoderProfilesProxyCompat.from((CamcorderProfile)profile) : null;
    }

    @RequiresApi(value=31)
    static class Api31Impl {
        @DoNotInline
        static EncoderProfiles getAll(String cameraId, int quality) {
            return CamcorderProfile.getAll((String)cameraId, (int)quality);
        }

        private Api31Impl() {
        }
    }
}

