/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.params;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.InputConfiguration;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.SessionConfiguration;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.internal.compat.params.InputConfigurationCompat;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public final class SessionConfigurationCompat {
    public static final int SESSION_REGULAR = 0;
    public static final int SESSION_HIGH_SPEED = 1;
    private final SessionConfigurationCompatImpl mImpl;

    public SessionConfigurationCompat(int sessionType, @NonNull List<OutputConfigurationCompat> outputsCompat, @NonNull Executor executor, @NonNull CameraCaptureSession.StateCallback cb) {
        this.mImpl = Build.VERSION.SDK_INT < 28 ? new SessionConfigurationCompatBaseImpl(sessionType, outputsCompat, executor, cb) : new SessionConfigurationCompatApi28Impl(sessionType, outputsCompat, executor, cb);
    }

    private SessionConfigurationCompat(@NonNull SessionConfigurationCompatImpl impl) {
        this.mImpl = impl;
    }

    @Nullable
    public static SessionConfigurationCompat wrap(@Nullable Object sessionConfiguration) {
        if (sessionConfiguration == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 28) {
            return null;
        }
        return new SessionConfigurationCompat(new SessionConfigurationCompatApi28Impl(sessionConfiguration));
    }

    @RequiresApi(value=24)
    static List<OutputConfigurationCompat> transformToCompat(@NonNull List<OutputConfiguration> outputConfigurations) {
        ArrayList<OutputConfigurationCompat> outList = new ArrayList<OutputConfigurationCompat>(outputConfigurations.size());
        for (OutputConfiguration outputConfiguration : outputConfigurations) {
            outList.add(OutputConfigurationCompat.wrap(outputConfiguration));
        }
        return outList;
    }

    @NonNull
    @RequiresApi(value=24)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static List<OutputConfiguration> transformFromCompat(@NonNull List<OutputConfigurationCompat> outputConfigurations) {
        ArrayList<OutputConfiguration> outList = new ArrayList<OutputConfiguration>(outputConfigurations.size());
        for (OutputConfigurationCompat outputConfiguration : outputConfigurations) {
            outList.add((OutputConfiguration)outputConfiguration.unwrap());
        }
        return outList;
    }

    public int getSessionType() {
        return this.mImpl.getSessionType();
    }

    @NonNull
    public List<OutputConfigurationCompat> getOutputConfigurations() {
        return this.mImpl.getOutputConfigurations();
    }

    @NonNull
    public CameraCaptureSession.StateCallback getStateCallback() {
        return this.mImpl.getStateCallback();
    }

    @NonNull
    public Executor getExecutor() {
        return this.mImpl.getExecutor();
    }

    @Nullable
    public InputConfigurationCompat getInputConfiguration() {
        return this.mImpl.getInputConfiguration();
    }

    public void setInputConfiguration(@NonNull InputConfigurationCompat input) {
        this.mImpl.setInputConfiguration(input);
    }

    @Nullable
    public CaptureRequest getSessionParameters() {
        return this.mImpl.getSessionParameters();
    }

    public void setSessionParameters(@NonNull CaptureRequest params) {
        this.mImpl.setSessionParameters(params);
    }

    @Nullable
    public Object unwrap() {
        return this.mImpl.getSessionConfiguration();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof SessionConfigurationCompat)) {
            return false;
        }
        return this.mImpl.equals(((SessionConfigurationCompat)obj).mImpl);
    }

    public int hashCode() {
        return this.mImpl.hashCode();
    }

    @RequiresApi(value=21)
    private static final class SessionConfigurationCompatBaseImpl
    implements SessionConfigurationCompatImpl {
        private final List<OutputConfigurationCompat> mOutputConfigurations;
        private final CameraCaptureSession.StateCallback mStateCallback;
        private final Executor mExecutor;
        private final int mSessionType;
        private InputConfigurationCompat mInputConfig = null;
        private CaptureRequest mSessionParameters = null;

        SessionConfigurationCompatBaseImpl(int sessionType, @NonNull List<OutputConfigurationCompat> outputs, @NonNull Executor executor, @NonNull CameraCaptureSession.StateCallback cb) {
            this.mSessionType = sessionType;
            this.mOutputConfigurations = Collections.unmodifiableList(new ArrayList<OutputConfigurationCompat>(outputs));
            this.mStateCallback = cb;
            this.mExecutor = executor;
        }

        @Override
        public int getSessionType() {
            return this.mSessionType;
        }

        @Override
        @NonNull
        public List<OutputConfigurationCompat> getOutputConfigurations() {
            return this.mOutputConfigurations;
        }

        @Override
        @NonNull
        public CameraCaptureSession.StateCallback getStateCallback() {
            return this.mStateCallback;
        }

        @Override
        @NonNull
        public Executor getExecutor() {
            return this.mExecutor;
        }

        @Override
        @Nullable
        public InputConfigurationCompat getInputConfiguration() {
            return this.mInputConfig;
        }

        @Override
        public void setInputConfiguration(@NonNull InputConfigurationCompat input) {
            if (this.mSessionType == 1) {
                throw new UnsupportedOperationException("Method not supported for high speed session types");
            }
            this.mInputConfig = input;
        }

        @Override
        public CaptureRequest getSessionParameters() {
            return this.mSessionParameters;
        }

        @Override
        public void setSessionParameters(@NonNull CaptureRequest params) {
            this.mSessionParameters = params;
        }

        @Override
        @Nullable
        public Object getSessionConfiguration() {
            return null;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof SessionConfigurationCompatBaseImpl) {
                SessionConfigurationCompatBaseImpl other = (SessionConfigurationCompatBaseImpl)obj;
                if (!Objects.equals(this.mInputConfig, other.mInputConfig) || this.mSessionType != other.mSessionType || this.mOutputConfigurations.size() != other.mOutputConfigurations.size()) {
                    return false;
                }
                for (int i = 0; i < this.mOutputConfigurations.size(); ++i) {
                    if (this.mOutputConfigurations.get(i).equals(other.mOutputConfigurations.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int h = 1;
            h = (h << 5) - h ^ this.mOutputConfigurations.hashCode();
            h = (h << 5) - h ^ (this.mInputConfig == null ? 0 : this.mInputConfig.hashCode());
            h = (h << 5) - h ^ this.mSessionType;
            return h;
        }
    }

    private static interface SessionConfigurationCompatImpl {
        public int getSessionType();

        @NonNull
        public List<OutputConfigurationCompat> getOutputConfigurations();

        @NonNull
        public CameraCaptureSession.StateCallback getStateCallback();

        @NonNull
        public Executor getExecutor();

        @Nullable
        public InputConfigurationCompat getInputConfiguration();

        public void setInputConfiguration(@NonNull InputConfigurationCompat var1);

        @Nullable
        public CaptureRequest getSessionParameters();

        public void setSessionParameters(@NonNull CaptureRequest var1);

        @Nullable
        public Object getSessionConfiguration();
    }

    @RequiresApi(value=28)
    private static final class SessionConfigurationCompatApi28Impl
    implements SessionConfigurationCompatImpl {
        private final SessionConfiguration mObject;
        private final List<OutputConfigurationCompat> mOutputConfigurations;

        SessionConfigurationCompatApi28Impl(@NonNull Object sessionConfiguration) {
            this.mObject = (SessionConfiguration)sessionConfiguration;
            this.mOutputConfigurations = Collections.unmodifiableList(SessionConfigurationCompat.transformToCompat(((SessionConfiguration)sessionConfiguration).getOutputConfigurations()));
        }

        SessionConfigurationCompatApi28Impl(int sessionType, @NonNull List<OutputConfigurationCompat> outputs, @NonNull Executor executor, @NonNull CameraCaptureSession.StateCallback cb) {
            this(new SessionConfiguration(sessionType, SessionConfigurationCompat.transformFromCompat(outputs), executor, cb));
        }

        @Override
        public int getSessionType() {
            return this.mObject.getSessionType();
        }

        @Override
        @NonNull
        public List<OutputConfigurationCompat> getOutputConfigurations() {
            return this.mOutputConfigurations;
        }

        @Override
        @NonNull
        public CameraCaptureSession.StateCallback getStateCallback() {
            return this.mObject.getStateCallback();
        }

        @Override
        @NonNull
        public Executor getExecutor() {
            return this.mObject.getExecutor();
        }

        @Override
        public InputConfigurationCompat getInputConfiguration() {
            return InputConfigurationCompat.wrap(this.mObject.getInputConfiguration());
        }

        @Override
        public void setInputConfiguration(@NonNull InputConfigurationCompat input) {
            this.mObject.setInputConfiguration((InputConfiguration)input.unwrap());
        }

        @Override
        public CaptureRequest getSessionParameters() {
            return this.mObject.getSessionParameters();
        }

        @Override
        public void setSessionParameters(@NonNull CaptureRequest params) {
            this.mObject.setSessionParameters(params);
        }

        @Override
        @Nullable
        public Object getSessionConfiguration() {
            return this.mObject;
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof SessionConfigurationCompatApi28Impl)) {
                return false;
            }
            return Objects.equals(this.mObject, ((SessionConfigurationCompatApi28Impl)obj).mObject);
        }

        public int hashCode() {
            return this.mObject.hashCode();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface SessionMode {
    }
}

