/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.quirk;

import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.Quirk;

@RequiresApi(value=21)
public class ExtraSupportedOutputSizeQuirk
implements Quirk {
    static boolean load() {
        return ExtraSupportedOutputSizeQuirk.isMotoE5Play();
    }

    private static boolean isMotoE5Play() {
        return "motorola".equalsIgnoreCase(Build.BRAND) && "moto e5 play".equalsIgnoreCase(Build.MODEL);
    }

    @NonNull
    public Size[] getExtraSupportedResolutions(int format) {
        if (format == 34 && ExtraSupportedOutputSizeQuirk.isMotoE5Play()) {
            return this.getMotoE5PlayExtraSupportedResolutions();
        }
        return new Size[0];
    }

    @NonNull
    public <T> Size[] getExtraSupportedResolutions(@NonNull Class<T> klass) {
        if (StreamConfigurationMap.isOutputSupportedFor(klass) && ExtraSupportedOutputSizeQuirk.isMotoE5Play()) {
            return this.getMotoE5PlayExtraSupportedResolutions();
        }
        return new Size[0];
    }

    @NonNull
    private Size[] getMotoE5PlayExtraSupportedResolutions() {
        return new Size[]{new Size(1920, 1080), new Size(1440, 1080), new Size(1280, 720), new Size(960, 720), new Size(864, 480), new Size(720, 480)};
    }
}

