/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CameraCaptureResult;
import androidx.camera.camera2.internal.Camera2CameraControlImpl;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.workaround.FlashAvailabilityChecker;
import androidx.camera.camera2.internal.compat.workaround.OverrideAeModeForStillCapture;
import androidx.camera.camera2.internal.compat.workaround.UseFlashModeTorchFor3aUpdate;
import androidx.camera.camera2.internal.compat.workaround.UseTorchAsFlash;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureMetaData;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraCaptureResults;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@RequiresApi(value=21)
class Camera2CapturePipeline {
    private static final String TAG = "Camera2CapturePipeline";
    private static final Set<CameraCaptureMetaData.AfState> AF_CONVERGED_STATE_SET = Collections.unmodifiableSet(EnumSet.of(CameraCaptureMetaData.AfState.PASSIVE_FOCUSED, CameraCaptureMetaData.AfState.PASSIVE_NOT_FOCUSED, CameraCaptureMetaData.AfState.LOCKED_FOCUSED, CameraCaptureMetaData.AfState.LOCKED_NOT_FOCUSED));
    private static final Set<CameraCaptureMetaData.AwbState> AWB_CONVERGED_STATE_SET = Collections.unmodifiableSet(EnumSet.of(CameraCaptureMetaData.AwbState.CONVERGED, CameraCaptureMetaData.AwbState.UNKNOWN));
    private static final Set<CameraCaptureMetaData.AeState> AE_CONVERGED_STATE_SET = Collections.unmodifiableSet(EnumSet.of(CameraCaptureMetaData.AeState.CONVERGED, CameraCaptureMetaData.AeState.FLASH_REQUIRED, CameraCaptureMetaData.AeState.UNKNOWN));
    private static final Set<CameraCaptureMetaData.AeState> AE_TORCH_AS_FLASH_CONVERGED_STATE_SET;
    @NonNull
    private final Camera2CameraControlImpl mCameraControl;
    @NonNull
    private final UseTorchAsFlash mUseTorchAsFlash;
    private final boolean mHasFlashUnit;
    @NonNull
    private final Quirks mCameraQuirk;
    @NonNull
    private final Executor mExecutor;
    @NonNull
    private final ScheduledExecutorService mScheduler;
    private final boolean mIsLegacyDevice;
    private int mTemplate = 1;

    Camera2CapturePipeline(@NonNull Camera2CameraControlImpl cameraControl, @NonNull CameraCharacteristicsCompat cameraCharacteristics, @NonNull Quirks cameraQuirks, @NonNull Executor executor, @NonNull ScheduledExecutorService scheduler) {
        this.mCameraControl = cameraControl;
        Integer level = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        this.mIsLegacyDevice = level != null && level == 2;
        this.mExecutor = executor;
        this.mScheduler = scheduler;
        this.mCameraQuirk = cameraQuirks;
        this.mUseTorchAsFlash = new UseTorchAsFlash(cameraQuirks);
        this.mHasFlashUnit = FlashAvailabilityChecker.isFlashAvailable(cameraCharacteristics::get);
    }

    public void setTemplate(int template) {
        this.mTemplate = template;
    }

    @NonNull
    public ListenableFuture<List<Void>> submitStillCaptures(@NonNull List<CaptureConfig> captureConfigs, int captureMode, int flashMode, int flashType) {
        OverrideAeModeForStillCapture aeQuirk = new OverrideAeModeForStillCapture(this.mCameraQuirk);
        Pipeline pipeline = new Pipeline(this.mTemplate, this.mExecutor, this.mCameraControl, this.mIsLegacyDevice, aeQuirk);
        if (captureMode == 0) {
            pipeline.addTask(new AfTask(this.mCameraControl));
        }
        if (flashMode == 3) {
            pipeline.addTask(new ScreenFlashTask(this.mCameraControl, this.mExecutor, this.mScheduler, new UseFlashModeTorchFor3aUpdate(this.mCameraQuirk)));
        } else if (this.mHasFlashUnit) {
            if (this.isTorchAsFlash(flashType)) {
                pipeline.addTask(new TorchTask(this.mCameraControl, flashMode, this.mExecutor));
            } else {
                pipeline.addTask(new AePreCaptureTask(this.mCameraControl, flashMode, aeQuirk));
            }
        }
        return Futures.nonCancellationPropagating(pipeline.executeCapture(captureConfigs, flashMode));
    }

    @NonNull
    static ListenableFuture<TotalCaptureResult> waitForResult(long waitTimeout, @NonNull Camera2CameraControlImpl cameraControl, @Nullable ResultListener.Checker checker) {
        ResultListener resultListener = new ResultListener(waitTimeout, checker);
        cameraControl.addCaptureResultListener(resultListener);
        return resultListener.getFuture();
    }

    static boolean is3AConverged(@Nullable TotalCaptureResult totalCaptureResult, boolean isTorchAsFlash) {
        boolean isAeModeOff;
        if (totalCaptureResult == null) {
            return false;
        }
        Camera2CameraCaptureResult captureResult = new Camera2CameraCaptureResult((CaptureResult)totalCaptureResult);
        boolean isAfReady = captureResult.getAfMode() == CameraCaptureMetaData.AfMode.OFF || captureResult.getAfMode() == CameraCaptureMetaData.AfMode.UNKNOWN || AF_CONVERGED_STATE_SET.contains(captureResult.getAfState());
        boolean bl = isAeModeOff = (Integer)totalCaptureResult.get(CaptureResult.CONTROL_AE_MODE) == 0;
        boolean isAeReady = isTorchAsFlash ? isAeModeOff || AE_TORCH_AS_FLASH_CONVERGED_STATE_SET.contains(captureResult.getAeState()) : isAeModeOff || AE_CONVERGED_STATE_SET.contains(captureResult.getAeState());
        boolean isAwbModeOff = (Integer)totalCaptureResult.get(CaptureResult.CONTROL_AWB_MODE) == 0;
        boolean isAwbReady = isAwbModeOff || AWB_CONVERGED_STATE_SET.contains(captureResult.getAwbState());
        Logger.d((String)TAG, (String)("checkCaptureResult, AE=" + captureResult.getAeState() + " AF =" + captureResult.getAfState() + " AWB=" + captureResult.getAwbState()));
        return isAfReady && isAeReady && isAwbReady;
    }

    static boolean isFlashRequired(int flashMode, @Nullable TotalCaptureResult result) {
        switch (flashMode) {
            case 1: 
            case 3: {
                return true;
            }
            case 0: {
                Integer aeState = result != null ? (Integer)result.get(CaptureResult.CONTROL_AE_STATE) : null;
                return aeState != null && aeState == 4;
            }
            case 2: {
                return false;
            }
        }
        throw new AssertionError(flashMode);
    }

    private boolean isTorchAsFlash(int flashType) {
        return this.mUseTorchAsFlash.shouldUseTorchAsFlash() || this.mTemplate == 3 || flashType == 1;
    }

    static {
        EnumSet<CameraCaptureMetaData.AeState> aeStateSet = EnumSet.copyOf(AE_CONVERGED_STATE_SET);
        aeStateSet.remove(CameraCaptureMetaData.AeState.FLASH_REQUIRED);
        aeStateSet.remove(CameraCaptureMetaData.AeState.UNKNOWN);
        AE_TORCH_AS_FLASH_CONVERGED_STATE_SET = Collections.unmodifiableSet(aeStateSet);
    }

    @VisibleForTesting
    static class Pipeline {
        private static final long CHECK_3A_TIMEOUT_IN_NS = TimeUnit.SECONDS.toNanos(1L);
        private static final long CHECK_3A_WITH_FLASH_TIMEOUT_IN_NS = TimeUnit.SECONDS.toNanos(5L);
        private final int mTemplate;
        private final Executor mExecutor;
        private final Camera2CameraControlImpl mCameraControl;
        private final OverrideAeModeForStillCapture mOverrideAeModeForStillCapture;
        private final boolean mIsLegacyDevice;
        private long mTimeout3A = CHECK_3A_TIMEOUT_IN_NS;
        final List<PipelineTask> mTasks = new ArrayList<PipelineTask>();
        private final PipelineTask mPipelineSubTask = new PipelineTask(){

            @Override
            @NonNull
            public ListenableFuture<Boolean> preCapture(@Nullable TotalCaptureResult captureResult) {
                ArrayList<ListenableFuture<Boolean>> futures = new ArrayList<ListenableFuture<Boolean>>();
                for (PipelineTask task : mTasks) {
                    futures.add(task.preCapture(captureResult));
                }
                return Futures.transform((ListenableFuture)Futures.allAsList(futures), results -> results.contains(true), (Executor)CameraXExecutors.directExecutor());
            }

            @Override
            public boolean isCaptureResultNeeded() {
                for (PipelineTask task : mTasks) {
                    if (!task.isCaptureResultNeeded()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void postCapture() {
                for (PipelineTask task : mTasks) {
                    task.postCapture();
                }
            }
        };

        Pipeline(int template, @NonNull Executor executor, @NonNull Camera2CameraControlImpl cameraControl, boolean isLegacyDevice, @NonNull OverrideAeModeForStillCapture overrideAeModeForStillCapture) {
            this.mTemplate = template;
            this.mExecutor = executor;
            this.mCameraControl = cameraControl;
            this.mIsLegacyDevice = isLegacyDevice;
            this.mOverrideAeModeForStillCapture = overrideAeModeForStillCapture;
        }

        void addTask(@NonNull PipelineTask task) {
            this.mTasks.add(task);
        }

        private void setTimeout3A(long timeout3A) {
            this.mTimeout3A = timeout3A;
        }

        @NonNull
        ListenableFuture<List<Void>> executeCapture(@NonNull List<CaptureConfig> captureConfigs, int flashMode) {
            ListenableFuture preCapture = Futures.immediateFuture(null);
            if (!this.mTasks.isEmpty()) {
                ListenableFuture<TotalCaptureResult> getResult = this.mPipelineSubTask.isCaptureResultNeeded() ? Camera2CapturePipeline.waitForResult(0L, this.mCameraControl, null) : Futures.immediateFuture(null);
                preCapture = FutureChain.from(getResult).transformAsync(captureResult -> {
                    if (Camera2CapturePipeline.isFlashRequired(flashMode, captureResult)) {
                        this.setTimeout3A(CHECK_3A_WITH_FLASH_TIMEOUT_IN_NS);
                    }
                    return this.mPipelineSubTask.preCapture((TotalCaptureResult)captureResult);
                }, this.mExecutor).transformAsync(is3aConvergeRequired -> {
                    if (Boolean.TRUE.equals(is3aConvergeRequired)) {
                        return Camera2CapturePipeline.waitForResult(this.mTimeout3A, this.mCameraControl, result -> Camera2CapturePipeline.is3AConverged(result, false));
                    }
                    return Futures.immediateFuture(null);
                }, this.mExecutor);
            }
            FutureChain future = FutureChain.from((ListenableFuture)preCapture).transformAsync(v -> this.submitConfigsInternal(captureConfigs, flashMode), this.mExecutor);
            future.addListener(this.mPipelineSubTask::postCapture, this.mExecutor);
            return future;
        }

        @NonNull
        ListenableFuture<List<Void>> submitConfigsInternal(@NonNull List<CaptureConfig> captureConfigs, int flashMode) {
            ArrayList<ListenableFuture> futureList = new ArrayList<ListenableFuture>();
            ArrayList<CaptureConfig> configsToSubmit = new ArrayList<CaptureConfig>();
            for (CaptureConfig captureConfig : captureConfigs) {
                CaptureConfig.Builder configBuilder = CaptureConfig.Builder.from((CaptureConfig)captureConfig);
                CameraCaptureResult cameraCaptureResult = null;
                if (captureConfig.getTemplateType() == 5 && !this.mCameraControl.getZslControl().isZslDisabledByFlashMode() && !this.mCameraControl.getZslControl().isZslDisabledByUserCaseConfig()) {
                    boolean isSuccess;
                    ImageProxy imageProxy = this.mCameraControl.getZslControl().dequeueImageFromBuffer();
                    boolean bl = isSuccess = imageProxy != null && this.mCameraControl.getZslControl().enqueueImageToImageWriter(imageProxy);
                    if (isSuccess) {
                        cameraCaptureResult = CameraCaptureResults.retrieveCameraCaptureResult((ImageInfo)imageProxy.getImageInfo());
                    }
                }
                if (cameraCaptureResult != null) {
                    configBuilder.setCameraCaptureResult(cameraCaptureResult);
                } else {
                    this.applyStillCaptureTemplate(configBuilder, captureConfig);
                }
                if (this.mOverrideAeModeForStillCapture.shouldSetAeModeAlwaysFlash(flashMode)) {
                    this.applyAeModeQuirk(configBuilder);
                }
                futureList.add(CallbackToFutureAdapter.getFuture(completer -> {
                    configBuilder.addCameraCaptureCallback(new CameraCaptureCallback(){

                        public void onCaptureCompleted(@NonNull CameraCaptureResult result) {
                            completer.set(null);
                        }

                        public void onCaptureFailed(@NonNull CameraCaptureFailure failure) {
                            String msg = "Capture request failed with reason " + failure.getReason();
                            completer.setException((Throwable)new ImageCaptureException(2, msg, null));
                        }

                        public void onCaptureCancelled() {
                            String msg = "Capture request is cancelled because camera is closed";
                            completer.setException((Throwable)new ImageCaptureException(3, msg, null));
                        }
                    });
                    return "submitStillCapture";
                }));
                configsToSubmit.add(configBuilder.build());
            }
            this.mCameraControl.submitCaptureRequestsInternal(configsToSubmit);
            return Futures.allAsList(futureList);
        }

        private void applyStillCaptureTemplate(@NonNull CaptureConfig.Builder configBuilder, @NonNull CaptureConfig captureConfig) {
            int templateToModify = -1;
            if (this.mTemplate == 3 && !this.mIsLegacyDevice) {
                templateToModify = 4;
            } else if (captureConfig.getTemplateType() == -1 || captureConfig.getTemplateType() == 5) {
                templateToModify = 2;
            }
            if (templateToModify != -1) {
                configBuilder.setTemplateType(templateToModify);
            }
        }

        @OptIn(markerClass={ExperimentalCamera2Interop.class})
        private void applyAeModeQuirk(@NonNull CaptureConfig.Builder configBuilder) {
            Camera2ImplConfig.Builder impBuilder = new Camera2ImplConfig.Builder();
            impBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_MODE, 3);
            configBuilder.addImplementationOptions((Config)impBuilder.build());
        }
    }

    static class AfTask
    implements PipelineTask {
        private final Camera2CameraControlImpl mCameraControl;
        private boolean mIsExecuted = false;

        AfTask(@NonNull Camera2CameraControlImpl cameraControl) {
            this.mCameraControl = cameraControl;
        }

        @Override
        @NonNull
        public ListenableFuture<Boolean> preCapture(@Nullable TotalCaptureResult captureResult) {
            ListenableFuture ret = Futures.immediateFuture((Object)true);
            if (captureResult == null) {
                return ret;
            }
            Integer afMode = (Integer)captureResult.get(CaptureResult.CONTROL_AF_MODE);
            if (afMode == null) {
                return ret;
            }
            switch (afMode) {
                case 1: 
                case 2: {
                    Logger.d((String)Camera2CapturePipeline.TAG, (String)"TriggerAf? AF mode auto");
                    Integer afState = (Integer)captureResult.get(CaptureResult.CONTROL_AF_STATE);
                    if (afState == null || afState != 0) break;
                    Logger.d((String)Camera2CapturePipeline.TAG, (String)"Trigger AF");
                    this.mIsExecuted = true;
                    this.mCameraControl.getFocusMeteringControl().triggerAf(null, false);
                    return ret;
                }
            }
            return ret;
        }

        @Override
        public boolean isCaptureResultNeeded() {
            return true;
        }

        @Override
        public void postCapture() {
            if (this.mIsExecuted) {
                Logger.d((String)Camera2CapturePipeline.TAG, (String)"cancel TriggerAF");
                this.mCameraControl.getFocusMeteringControl().cancelAfAeTrigger(true, false);
            }
        }
    }

    static interface PipelineTask {
        @NonNull
        public ListenableFuture<Boolean> preCapture(@Nullable TotalCaptureResult var1);

        public boolean isCaptureResultNeeded();

        public void postCapture();
    }

    static class ScreenFlashTask
    implements PipelineTask {
        private static final long CHECK_3A_WITH_SCREEN_FLASH_TIMEOUT_IN_NS = TimeUnit.SECONDS.toNanos(2L);
        private final Camera2CameraControlImpl mCameraControl;
        private final Executor mExecutor;
        private final ScheduledExecutorService mScheduler;
        private final ImageCapture.ScreenFlashUiControl mScreenFlashUiControl;
        private final UseFlashModeTorchFor3aUpdate mUseFlashModeTorchFor3aUpdate;

        ScreenFlashTask(@NonNull Camera2CameraControlImpl cameraControl, @NonNull Executor executor, @NonNull ScheduledExecutorService scheduler, @NonNull UseFlashModeTorchFor3aUpdate useFlashModeTorchFor3aUpdate) {
            this.mCameraControl = cameraControl;
            this.mExecutor = executor;
            this.mScheduler = scheduler;
            this.mUseFlashModeTorchFor3aUpdate = useFlashModeTorchFor3aUpdate;
            this.mScreenFlashUiControl = Objects.requireNonNull(this.mCameraControl.getScreenFlashUiControl());
        }

        @Override
        @NonNull
        public ListenableFuture<Boolean> preCapture(@Nullable TotalCaptureResult captureResult) {
            Logger.d((String)Camera2CapturePipeline.TAG, (String)"ScreenFlashTask#preCapture");
            AtomicReference screenFlashUiCompleter = new AtomicReference();
            ListenableFuture uiAppliedFuture = CallbackToFutureAdapter.getFuture(completer -> {
                screenFlashUiCompleter.set(() -> {
                    Logger.d((String)Camera2CapturePipeline.TAG, (String)"ScreenFlashTask#preCapture: UI change applied");
                    completer.set(null);
                });
                return "OnScreenFlashUiApplied";
            });
            ListenableFuture future = CallbackToFutureAdapter.getFuture(completer -> {
                CameraXExecutors.mainThreadExecutor().execute(() -> {
                    Logger.d((String)Camera2CapturePipeline.TAG, (String)"ScreenFlashTask#preCapture: invoking applyScreenFlashUi");
                    this.mScreenFlashUiControl.applyScreenFlashUi((ImageCapture.ScreenFlashUiCompleter)screenFlashUiCompleter.get());
                    completer.set(null);
                });
                return "OnScreenFlashStart";
            });
            return FutureChain.from((ListenableFuture)future).transformAsync(input -> this.mCameraControl.getFocusMeteringControl().enableExternalFlashAeMode(true), this.mExecutor).transformAsync(input -> CallbackToFutureAdapter.getFuture(completer -> {
                if (!this.mUseFlashModeTorchFor3aUpdate.shouldUseFlashModeTorch()) {
                    completer.set(null);
                    return "EnableTorchInternal";
                }
                Logger.d((String)Camera2CapturePipeline.TAG, (String)"ScreenFlashTask#preCapture: enable torch");
                this.mCameraControl.enableTorchInternal(true);
                completer.set(null);
                return "EnableTorchInternal";
            }), this.mExecutor).transformAsync(input -> Futures.makeTimeoutFuture((long)TimeUnit.SECONDS.toMillis(3L), (ScheduledExecutorService)this.mScheduler, null, (ListenableFuture)uiAppliedFuture), this.mExecutor).transformAsync(input -> this.mCameraControl.getFocusMeteringControl().triggerAePrecapture(), this.mExecutor).transformAsync(input -> Camera2CapturePipeline.waitForResult(CHECK_3A_WITH_SCREEN_FLASH_TIMEOUT_IN_NS, this.mCameraControl, result -> Camera2CapturePipeline.is3AConverged(result, false)), this.mExecutor).transform(input -> false, CameraXExecutors.directExecutor());
        }

        @Override
        public boolean isCaptureResultNeeded() {
            return false;
        }

        @Override
        public void postCapture() {
            Logger.d((String)Camera2CapturePipeline.TAG, (String)"ScreenFlashTask#postCapture");
            if (this.mUseFlashModeTorchFor3aUpdate.shouldUseFlashModeTorch()) {
                this.mCameraControl.enableTorchInternal(false);
            }
            this.mCameraControl.getFocusMeteringControl().enableExternalFlashAeMode(false).addListener(() -> Log.d((String)Camera2CapturePipeline.TAG, (String)"enableExternalFlashAeMode disabled"), this.mExecutor);
            this.mCameraControl.getFocusMeteringControl().cancelAfAeTrigger(false, true);
            CameraXExecutors.mainThreadExecutor().execute(() -> ((ImageCapture.ScreenFlashUiControl)this.mScreenFlashUiControl).clearScreenFlashUi());
        }
    }

    static class TorchTask
    implements PipelineTask {
        private static final long CHECK_3A_WITH_TORCH_TIMEOUT_IN_NS = TimeUnit.SECONDS.toNanos(2L);
        private final Camera2CameraControlImpl mCameraControl;
        private final int mFlashMode;
        private boolean mIsExecuted = false;
        private final Executor mExecutor;

        TorchTask(@NonNull Camera2CameraControlImpl cameraControl, int flashMode, @NonNull Executor executor) {
            this.mCameraControl = cameraControl;
            this.mFlashMode = flashMode;
            this.mExecutor = executor;
        }

        @Override
        @NonNull
        public ListenableFuture<Boolean> preCapture(@Nullable TotalCaptureResult captureResult) {
            if (Camera2CapturePipeline.isFlashRequired(this.mFlashMode, captureResult)) {
                if (this.mCameraControl.isTorchOn()) {
                    Logger.d((String)Camera2CapturePipeline.TAG, (String)"Torch already on, not turn on");
                } else {
                    Logger.d((String)Camera2CapturePipeline.TAG, (String)"Turn on torch");
                    this.mIsExecuted = true;
                    ListenableFuture future = CallbackToFutureAdapter.getFuture(completer -> {
                        this.mCameraControl.getTorchControl().enableTorchInternal((CallbackToFutureAdapter.Completer<Void>)completer, true);
                        return "TorchOn";
                    });
                    return FutureChain.from((ListenableFuture)future).transformAsync(input -> Camera2CapturePipeline.waitForResult(CHECK_3A_WITH_TORCH_TIMEOUT_IN_NS, this.mCameraControl, result -> Camera2CapturePipeline.is3AConverged(result, true)), this.mExecutor).transform(input -> false, CameraXExecutors.directExecutor());
                }
            }
            return Futures.immediateFuture((Object)false);
        }

        @Override
        public boolean isCaptureResultNeeded() {
            return this.mFlashMode == 0;
        }

        @Override
        public void postCapture() {
            if (this.mIsExecuted) {
                this.mCameraControl.getTorchControl().enableTorchInternal(null, false);
                Logger.d((String)Camera2CapturePipeline.TAG, (String)"Turn off torch");
            }
        }
    }

    static class AePreCaptureTask
    implements PipelineTask {
        private final Camera2CameraControlImpl mCameraControl;
        private final OverrideAeModeForStillCapture mOverrideAeModeForStillCapture;
        private final int mFlashMode;
        private boolean mIsExecuted = false;

        AePreCaptureTask(@NonNull Camera2CameraControlImpl cameraControl, int flashMode, @NonNull OverrideAeModeForStillCapture overrideAeModeForStillCapture) {
            this.mCameraControl = cameraControl;
            this.mFlashMode = flashMode;
            this.mOverrideAeModeForStillCapture = overrideAeModeForStillCapture;
        }

        @Override
        @NonNull
        public ListenableFuture<Boolean> preCapture(@Nullable TotalCaptureResult captureResult) {
            if (Camera2CapturePipeline.isFlashRequired(this.mFlashMode, captureResult)) {
                Logger.d((String)Camera2CapturePipeline.TAG, (String)"Trigger AE");
                this.mIsExecuted = true;
                ListenableFuture future = CallbackToFutureAdapter.getFuture(completer -> {
                    this.mCameraControl.getFocusMeteringControl().triggerAePrecapture((CallbackToFutureAdapter.Completer<Void>)completer);
                    this.mOverrideAeModeForStillCapture.onAePrecaptureStarted();
                    return "AePreCapture";
                });
                return FutureChain.from((ListenableFuture)future).transform(input -> true, CameraXExecutors.directExecutor());
            }
            return Futures.immediateFuture((Object)false);
        }

        @Override
        public boolean isCaptureResultNeeded() {
            return this.mFlashMode == 0;
        }

        @Override
        public void postCapture() {
            if (this.mIsExecuted) {
                Logger.d((String)Camera2CapturePipeline.TAG, (String)"cancel TriggerAePreCapture");
                this.mCameraControl.getFocusMeteringControl().cancelAfAeTrigger(false, true);
                this.mOverrideAeModeForStillCapture.onAePrecaptureFinished();
            }
        }
    }

    static class ResultListener
    implements Camera2CameraControlImpl.CaptureResultListener {
        static final long NO_TIMEOUT = 0L;
        private CallbackToFutureAdapter.Completer<TotalCaptureResult> mCompleter;
        private final ListenableFuture<TotalCaptureResult> mFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mCompleter = completer;
            return "waitFor3AResult";
        });
        private final long mTimeLimitNs;
        private final Checker mChecker;
        private volatile Long mTimestampOfFirstUpdateNs = null;

        ResultListener(long timeLimitNs, @Nullable Checker checker) {
            this.mTimeLimitNs = timeLimitNs;
            this.mChecker = checker;
        }

        @NonNull
        public ListenableFuture<TotalCaptureResult> getFuture() {
            return this.mFuture;
        }

        @Override
        public boolean onCaptureResult(@NonNull TotalCaptureResult captureResult) {
            Long currentTimestampNs = (Long)captureResult.get(CaptureResult.SENSOR_TIMESTAMP);
            if (currentTimestampNs != null && this.mTimestampOfFirstUpdateNs == null) {
                this.mTimestampOfFirstUpdateNs = currentTimestampNs;
            }
            Long timestampOfFirstUpdateNs = this.mTimestampOfFirstUpdateNs;
            if (0L != this.mTimeLimitNs && timestampOfFirstUpdateNs != null && currentTimestampNs != null && currentTimestampNs - timestampOfFirstUpdateNs > this.mTimeLimitNs) {
                this.mCompleter.set(null);
                Logger.d((String)Camera2CapturePipeline.TAG, (String)("Wait for capture result timeout, current:" + currentTimestampNs + " first: " + timestampOfFirstUpdateNs));
                return true;
            }
            if (this.mChecker != null && !this.mChecker.check(captureResult)) {
                return false;
            }
            this.mCompleter.set((Object)captureResult);
            return true;
        }

        static interface Checker {
            public boolean check(@NonNull TotalCaptureResult var1);
        }
    }
}

