/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CaptureCallbacks;
import androidx.camera.camera2.internal.CameraCaptureSessionStateCallbacks;
import androidx.camera.camera2.internal.CameraDeviceStateCallbacks;
import androidx.camera.camera2.internal.CaptureCallbackContainer;
import androidx.camera.camera2.internal.compat.workaround.PreviewPixelHDRnet;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.PreviewConfig;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import java.util.Collection;

@RequiresApi(value=21)
final class Camera2SessionOptionUnpacker
implements SessionConfig.OptionUnpacker {
    static final Camera2SessionOptionUnpacker INSTANCE = new Camera2SessionOptionUnpacker();

    Camera2SessionOptionUnpacker() {
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public void unpack(@NonNull Size resolution, @NonNull UseCaseConfig<?> config, @NonNull SessionConfig.Builder builder) {
        SessionConfig defaultSessionConfig = config.getDefaultSessionConfig(null);
        OptionsBundle implOptions = OptionsBundle.emptyBundle();
        int templateType = SessionConfig.defaultEmptySessionConfig().getTemplateType();
        if (defaultSessionConfig != null) {
            templateType = defaultSessionConfig.getTemplateType();
            builder.addAllDeviceStateCallbacks((Collection)defaultSessionConfig.getDeviceStateCallbacks());
            builder.addAllSessionStateCallbacks(defaultSessionConfig.getSessionStateCallbacks());
            builder.addAllRepeatingCameraCaptureCallbacks((Collection)defaultSessionConfig.getRepeatingCameraCaptureCallbacks());
            implOptions = defaultSessionConfig.getImplementationOptions();
        }
        builder.setImplementationOptions((Config)implOptions);
        if (config instanceof PreviewConfig) {
            PreviewPixelHDRnet.setHDRnet(resolution, builder);
        }
        Camera2ImplConfig camera2Config = new Camera2ImplConfig((Config)config);
        builder.setTemplateType(camera2Config.getCaptureRequestTemplate(templateType));
        builder.addDeviceStateCallback(camera2Config.getDeviceStateCallback(CameraDeviceStateCallbacks.createNoOpCallback()));
        builder.addSessionStateCallback(camera2Config.getSessionStateCallback(CameraCaptureSessionStateCallbacks.createNoOpCallback()));
        builder.addCameraCaptureCallback((CameraCaptureCallback)CaptureCallbackContainer.create(camera2Config.getSessionCaptureCallback(Camera2CaptureCallbacks.createNoOpCallback())));
        builder.setVideoStabilization(config.getVideoStabilizationMode());
        builder.setPreviewStabilization(config.getPreviewStabilizationMode());
        MutableOptionsBundle extendedConfig = MutableOptionsBundle.create();
        extendedConfig.insertOption(Camera2ImplConfig.SESSION_PHYSICAL_CAMERA_ID_OPTION, (Object)camera2Config.getPhysicalCameraId(null));
        extendedConfig.insertOption(Camera2ImplConfig.STREAM_USE_CASE_OPTION, (Object)camera2Config.getStreamUseCase(-1L));
        builder.addImplementationOptions((Config)extendedConfig);
        builder.addImplementationOptions((Config)camera2Config.getCaptureRequestOptions());
    }
}

