/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.DynamicRangeProfiles;
import android.os.Build;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CaptureCallbacks;
import androidx.camera.camera2.internal.Camera2CaptureRequestBuilder;
import androidx.camera.camera2.internal.CameraBurstCaptureCallback;
import androidx.camera.camera2.internal.CaptureCallbackConverter;
import androidx.camera.camera2.internal.CaptureSessionInterface;
import androidx.camera.camera2.internal.SynchronizedCaptureSession;
import androidx.camera.camera2.internal.SynchronizedCaptureSessionStateCallbacks;
import androidx.camera.camera2.internal.compat.params.DynamicRangeConversions;
import androidx.camera.camera2.internal.compat.params.DynamicRangesCompat;
import androidx.camera.camera2.internal.compat.params.InputConfigurationCompat;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompat;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.camera.camera2.internal.compat.workaround.StillCaptureFlow;
import androidx.camera.camera2.internal.compat.workaround.TorchStateReset;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
final class CaptureSession
implements CaptureSessionInterface {
    private static final String TAG = "CaptureSession";
    private static final long TIMEOUT_GET_SURFACE_IN_MS = 5000L;
    final Object mSessionLock = new Object();
    @GuardedBy(value="mSessionLock")
    private final List<CaptureConfig> mCaptureConfigs = new ArrayList<CaptureConfig>();
    private final CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        }
    };
    @GuardedBy(value="mSessionLock")
    private final StateCallback mCaptureSessionStateCallback;
    @Nullable
    @GuardedBy(value="mSessionLock")
    SynchronizedCaptureSession.Opener mSessionOpener;
    @Nullable
    @GuardedBy(value="mSessionLock")
    SynchronizedCaptureSession mSynchronizedCaptureSession;
    @Nullable
    @GuardedBy(value="mSessionLock")
    SessionConfig mSessionConfig;
    @GuardedBy(value="mSessionLock")
    private final Map<DeferrableSurface, Surface> mConfiguredSurfaceMap = new HashMap<DeferrableSurface, Surface>();
    @GuardedBy(value="mSessionLock")
    List<DeferrableSurface> mConfiguredDeferrableSurfaces = Collections.emptyList();
    @GuardedBy(value="mSessionLock")
    State mState = State.UNINITIALIZED;
    @GuardedBy(value="mSessionLock")
    ListenableFuture<Void> mReleaseFuture;
    @GuardedBy(value="mSessionLock")
    CallbackToFutureAdapter.Completer<Void> mReleaseCompleter;
    @NonNull
    @GuardedBy(value="mSessionLock")
    Map<DeferrableSurface, Long> mStreamUseCaseMap = new HashMap<DeferrableSurface, Long>();
    final StillCaptureFlow mStillCaptureFlow = new StillCaptureFlow();
    final TorchStateReset mTorchStateReset = new TorchStateReset();
    private final DynamicRangesCompat mDynamicRangesCompat;

    CaptureSession(@NonNull DynamicRangesCompat dynamicRangesCompat) {
        this.mState = State.INITIALIZED;
        this.mDynamicRangesCompat = dynamicRangesCompat;
        this.mCaptureSessionStateCallback = new StateCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStreamUseCaseMap(@NonNull Map<DeferrableSurface, Long> streamUseCaseMap) {
        Object object = this.mSessionLock;
        synchronized (object) {
            this.mStreamUseCaseMap = streamUseCaseMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SessionConfig getSessionConfig() {
        Object object = this.mSessionLock;
        synchronized (object) {
            return this.mSessionConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionConfig(@Nullable SessionConfig sessionConfig) {
        Object object = this.mSessionLock;
        synchronized (object) {
            switch (this.mState) {
                case UNINITIALIZED: {
                    throw new IllegalStateException("setSessionConfig() should not be possible in state: " + (Object)((Object)this.mState));
                }
                case INITIALIZED: 
                case GET_SURFACE: 
                case OPENING: {
                    this.mSessionConfig = sessionConfig;
                    break;
                }
                case OPENED: {
                    this.mSessionConfig = sessionConfig;
                    if (sessionConfig == null) {
                        return;
                    }
                    if (!this.mConfiguredSurfaceMap.keySet().containsAll(sessionConfig.getSurfaces())) {
                        Logger.e((String)TAG, (String)"Does not have the proper configured lists");
                        return;
                    }
                    Logger.d((String)TAG, (String)"Attempting to submit CaptureRequest after setting");
                    this.issueRepeatingCaptureRequests(this.mSessionConfig);
                    break;
                }
                case CLOSED: 
                case RELEASING: 
                case RELEASED: {
                    throw new IllegalStateException("Session configuration cannot be set on a closed/released session.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ListenableFuture<Void> open(@NonNull SessionConfig sessionConfig, @NonNull CameraDevice cameraDevice, @NonNull SynchronizedCaptureSession.Opener opener) {
        Object object = this.mSessionLock;
        synchronized (object) {
            switch (this.mState) {
                case INITIALIZED: {
                    this.mState = State.GET_SURFACE;
                    this.mConfiguredDeferrableSurfaces = new ArrayList<DeferrableSurface>(sessionConfig.getSurfaces());
                    this.mSessionOpener = opener;
                    FutureChain openFuture = FutureChain.from(this.mSessionOpener.startWithDeferrableSurface(this.mConfiguredDeferrableSurfaces, 5000L)).transformAsync(surfaces -> this.openCaptureSession((List<Surface>)surfaces, sessionConfig, cameraDevice), this.mSessionOpener.getExecutor());
                    Futures.addCallback((ListenableFuture)openFuture, (FutureCallback)new FutureCallback<Void>(){

                        public void onSuccess(@Nullable Void result) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onFailure(@NonNull Throwable t) {
                            Object object = CaptureSession.this.mSessionLock;
                            synchronized (object) {
                                CaptureSession.this.mSessionOpener.stop();
                                switch (CaptureSession.this.mState) {
                                    case OPENING: 
                                    case CLOSED: 
                                    case RELEASING: {
                                        if (t instanceof CancellationException) break;
                                        Logger.w((String)CaptureSession.TAG, (String)("Opening session with fail " + (Object)((Object)CaptureSession.this.mState)), (Throwable)t);
                                        CaptureSession.this.finishClose();
                                        break;
                                    }
                                }
                            }
                        }
                    }, (Executor)this.mSessionOpener.getExecutor());
                    return Futures.nonCancellationPropagating((ListenableFuture)openFuture);
                }
            }
            Logger.e((String)TAG, (String)("Open not allowed in state: " + (Object)((Object)this.mState)));
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("open() should not allow the state: " + (Object)((Object)this.mState)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    @NonNull
    private ListenableFuture<Void> openCaptureSession(@NonNull List<Surface> configuredSurfaces, @NonNull SessionConfig sessionConfig, @NonNull CameraDevice cameraDevice) {
        Object object = this.mSessionLock;
        synchronized (object) {
            switch (this.mState) {
                case UNINITIALIZED: 
                case INITIALIZED: 
                case OPENED: {
                    return Futures.immediateFailedFuture((Throwable)new IllegalStateException("openCaptureSession() should not be possible in state: " + (Object)((Object)this.mState)));
                }
                case GET_SURFACE: {
                    this.mConfiguredSurfaceMap.clear();
                    for (int i = 0; i < configuredSurfaces.size(); ++i) {
                        this.mConfiguredSurfaceMap.put(this.mConfiguredDeferrableSurfaces.get(i), configuredSurfaces.get(i));
                    }
                    this.mState = State.OPENING;
                    Logger.d((String)TAG, (String)"Opening capture session.");
                    SynchronizedCaptureSession.StateCallback callbacks = SynchronizedCaptureSessionStateCallbacks.createComboCallback(this.mCaptureSessionStateCallback, new SynchronizedCaptureSessionStateCallbacks.Adapter(sessionConfig.getSessionStateCallbacks()));
                    Camera2ImplConfig camera2Config = new Camera2ImplConfig(sessionConfig.getImplementationOptions());
                    CaptureConfig.Builder sessionParameterConfigBuilder = CaptureConfig.Builder.from((CaptureConfig)sessionConfig.getRepeatingCaptureConfig());
                    List<OutputConfigurationCompat> outputConfigList = new ArrayList<OutputConfigurationCompat>();
                    String physicalCameraIdForAllStreams = camera2Config.getPhysicalCameraId(null);
                    for (SessionConfig.OutputConfig outputConfig : sessionConfig.getOutputConfigs()) {
                        OutputConfigurationCompat outputConfiguration = this.getOutputConfigurationCompat(outputConfig, this.mConfiguredSurfaceMap, physicalCameraIdForAllStreams);
                        if (this.mStreamUseCaseMap.containsKey(outputConfig.getSurface())) {
                            outputConfiguration.setStreamUseCase(this.mStreamUseCaseMap.get(outputConfig.getSurface()));
                        }
                        outputConfigList.add(outputConfiguration);
                    }
                    outputConfigList = this.getUniqueOutputConfigurations(outputConfigList);
                    SessionConfigurationCompat sessionConfigCompat = this.mSessionOpener.createSessionConfigurationCompat(sessionConfig.getSessionType(), outputConfigList, callbacks);
                    if (sessionConfig.getTemplateType() == 5 && sessionConfig.getInputConfiguration() != null) {
                        sessionConfigCompat.setInputConfiguration(InputConfigurationCompat.wrap(sessionConfig.getInputConfiguration()));
                    }
                    try {
                        CaptureRequest captureRequest = Camera2CaptureRequestBuilder.buildWithoutTarget(sessionParameterConfigBuilder.build(), cameraDevice);
                        if (captureRequest != null) {
                            sessionConfigCompat.setSessionParameters(captureRequest);
                        }
                    }
                    catch (CameraAccessException e) {
                        return Futures.immediateFailedFuture((Throwable)e);
                    }
                    return this.mSessionOpener.openCaptureSession(cameraDevice, sessionConfigCompat, this.mConfiguredDeferrableSurfaces);
                }
            }
            return Futures.immediateFailedFuture((Throwable)new CancellationException("openCaptureSession() not execute in state: " + (Object)((Object)this.mState)));
        }
    }

    @NonNull
    private List<OutputConfigurationCompat> getUniqueOutputConfigurations(@NonNull List<OutputConfigurationCompat> outputConfigurations) {
        ArrayList<Surface> addedSurfaces = new ArrayList<Surface>();
        ArrayList<OutputConfigurationCompat> results = new ArrayList<OutputConfigurationCompat>();
        for (OutputConfigurationCompat outputConfiguration : outputConfigurations) {
            if (addedSurfaces.contains(outputConfiguration.getSurface())) continue;
            addedSurfaces.add(outputConfiguration.getSurface());
            results.add(outputConfiguration);
        }
        return results;
    }

    @NonNull
    private OutputConfigurationCompat getOutputConfigurationCompat(@NonNull SessionConfig.OutputConfig outputConfig, @NonNull Map<DeferrableSurface, Surface> configuredSurfaceMap, @Nullable String physicalCameraIdForAllStreams) {
        DynamicRangeProfiles dynamicRangeProfiles;
        Surface surface = configuredSurfaceMap.get(outputConfig.getSurface());
        Preconditions.checkNotNull((Object)surface, (Object)"Surface in OutputConfig not found in configuredSurfaceMap.");
        OutputConfigurationCompat outputConfiguration = new OutputConfigurationCompat(outputConfig.getSurfaceGroupId(), surface);
        if (physicalCameraIdForAllStreams != null) {
            outputConfiguration.setPhysicalCameraId(physicalCameraIdForAllStreams);
        } else {
            outputConfiguration.setPhysicalCameraId(outputConfig.getPhysicalCameraId());
        }
        if (!outputConfig.getSharedSurfaces().isEmpty()) {
            outputConfiguration.enableSurfaceSharing();
            for (DeferrableSurface sharedDeferSurface : outputConfig.getSharedSurfaces()) {
                Surface sharedSurface = configuredSurfaceMap.get(sharedDeferSurface);
                Preconditions.checkNotNull((Object)sharedSurface, (Object)"Surface in OutputConfig not found in configuredSurfaceMap.");
                outputConfiguration.addSurface(sharedSurface);
            }
        }
        long dynamicRangeProfile = 1L;
        if (Build.VERSION.SDK_INT >= 33 && (dynamicRangeProfiles = this.mDynamicRangesCompat.toDynamicRangeProfiles()) != null) {
            DynamicRange requestedDynamicRange = outputConfig.getDynamicRange();
            Long dynamicRangeProfileOrNull = DynamicRangeConversions.dynamicRangeToFirstSupportedProfile(requestedDynamicRange, dynamicRangeProfiles);
            if (dynamicRangeProfileOrNull == null) {
                Logger.e((String)TAG, (String)("Requested dynamic range is not supported. Defaulting to STANDARD dynamic range profile.\nRequested dynamic range:\n  " + requestedDynamicRange));
            } else {
                dynamicRangeProfile = dynamicRangeProfileOrNull;
            }
        }
        outputConfiguration.setDynamicRangeProfile(dynamicRangeProfile);
        return outputConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mSessionLock;
        synchronized (object) {
            switch (this.mState) {
                case UNINITIALIZED: {
                    throw new IllegalStateException("close() should not be possible in state: " + (Object)((Object)this.mState));
                }
                case GET_SURFACE: {
                    Preconditions.checkNotNull((Object)this.mSessionOpener, (Object)("The Opener shouldn't null in state:" + (Object)((Object)this.mState)));
                    this.mSessionOpener.stop();
                }
                case INITIALIZED: {
                    this.mState = State.RELEASED;
                    break;
                }
                case OPENING: 
                case OPENED: {
                    Preconditions.checkNotNull((Object)this.mSessionOpener, (Object)("The Opener shouldn't null in state:" + (Object)((Object)this.mState)));
                    this.mSessionOpener.stop();
                    this.mState = State.CLOSED;
                    this.mSessionConfig = null;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ListenableFuture<Void> release(boolean abortInFlightCaptures) {
        Object object = this.mSessionLock;
        synchronized (object) {
            switch (this.mState) {
                case UNINITIALIZED: {
                    throw new IllegalStateException("release() should not be possible in state: " + (Object)((Object)this.mState));
                }
                case OPENED: 
                case CLOSED: {
                    if (this.mSynchronizedCaptureSession != null) {
                        if (abortInFlightCaptures) {
                            try {
                                this.mSynchronizedCaptureSession.abortCaptures();
                            }
                            catch (CameraAccessException e) {
                                Logger.e((String)TAG, (String)"Unable to abort captures.", (Throwable)e);
                            }
                        }
                        this.mSynchronizedCaptureSession.close();
                    }
                }
                case OPENING: {
                    this.mState = State.RELEASING;
                    Preconditions.checkNotNull((Object)this.mSessionOpener, (Object)("The Opener shouldn't null in state:" + (Object)((Object)this.mState)));
                    if (this.mSessionOpener.stop()) {
                        this.finishClose();
                        break;
                    }
                }
                case RELEASING: {
                    if (this.mReleaseFuture == null) {
                        this.mReleaseFuture = CallbackToFutureAdapter.getFuture(completer -> {
                            Object object = this.mSessionLock;
                            synchronized (object) {
                                Preconditions.checkState((this.mReleaseCompleter == null ? 1 : 0) != 0, (String)"Release completer expected to be null");
                                this.mReleaseCompleter = completer;
                                return "Release[session=" + this + "]";
                            }
                        });
                    }
                    return this.mReleaseFuture;
                }
                case GET_SURFACE: {
                    Preconditions.checkNotNull((Object)this.mSessionOpener, (Object)("The Opener shouldn't null in state:" + (Object)((Object)this.mState)));
                    this.mSessionOpener.stop();
                }
                case INITIALIZED: {
                    this.mState = State.RELEASED;
                }
            }
        }
        return Futures.immediateFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void issueCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
        Object object = this.mSessionLock;
        synchronized (object) {
            switch (this.mState) {
                case UNINITIALIZED: {
                    throw new IllegalStateException("issueCaptureRequests() should not be possible in state: " + (Object)((Object)this.mState));
                }
                case INITIALIZED: 
                case GET_SURFACE: 
                case OPENING: {
                    this.mCaptureConfigs.addAll(captureConfigs);
                    break;
                }
                case OPENED: {
                    this.mCaptureConfigs.addAll(captureConfigs);
                    this.issuePendingCaptureRequest();
                    break;
                }
                case CLOSED: 
                case RELEASING: 
                case RELEASED: {
                    throw new IllegalStateException("Cannot issue capture request on a closed/released session.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public List<CaptureConfig> getCaptureConfigs() {
        Object object = this.mSessionLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.mCaptureConfigs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State getState() {
        Object object = this.mSessionLock;
        synchronized (object) {
            return this.mState;
        }
    }

    @GuardedBy(value="mSessionLock")
    void finishClose() {
        if (this.mState == State.RELEASED) {
            Logger.d((String)TAG, (String)"Skipping finishClose due to being state RELEASED.");
            return;
        }
        this.mState = State.RELEASED;
        this.mSynchronizedCaptureSession = null;
        if (this.mReleaseCompleter != null) {
            this.mReleaseCompleter.set(null);
            this.mReleaseCompleter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int issueRepeatingCaptureRequests(@Nullable SessionConfig sessionConfig) {
        Object object = this.mSessionLock;
        synchronized (object) {
            if (sessionConfig == null) {
                Logger.d((String)TAG, (String)"Skipping issueRepeatingCaptureRequests for no configuration case.");
                return -1;
            }
            if (this.mState != State.OPENED) {
                Logger.d((String)TAG, (String)"Skipping issueRepeatingCaptureRequests due to session closed");
                return -1;
            }
            CaptureConfig captureConfig = sessionConfig.getRepeatingCaptureConfig();
            if (captureConfig.getSurfaces().isEmpty()) {
                Logger.d((String)TAG, (String)"Skipping issueRepeatingCaptureRequests for no surface.");
                try {
                    this.mSynchronizedCaptureSession.stopRepeating();
                }
                catch (CameraAccessException e) {
                    Logger.e((String)TAG, (String)("Unable to access camera: " + e.getMessage()));
                    Thread.dumpStack();
                }
                return -1;
            }
            try {
                Logger.d((String)TAG, (String)"Issuing request for session.");
                CaptureRequest captureRequest = Camera2CaptureRequestBuilder.build(captureConfig, this.mSynchronizedCaptureSession.getDevice(), this.mConfiguredSurfaceMap);
                if (captureRequest == null) {
                    Logger.d((String)TAG, (String)"Skipping issuing empty request for session.");
                    return -1;
                }
                CameraCaptureSession.CaptureCallback comboCaptureCallback = this.createCamera2CaptureCallback(captureConfig.getCameraCaptureCallbacks(), this.mCaptureCallback);
                return this.mSynchronizedCaptureSession.setSingleRepeatingRequest(captureRequest, comboCaptureCallback);
            }
            catch (CameraAccessException e) {
                Logger.e((String)TAG, (String)("Unable to access camera: " + e.getMessage()));
                Thread.dumpStack();
                return -1;
            }
        }
    }

    @GuardedBy(value="mSessionLock")
    void issuePendingCaptureRequest() {
        if (this.mCaptureConfigs.isEmpty()) {
            return;
        }
        try {
            this.issueBurstCaptureRequest(this.mCaptureConfigs);
        }
        finally {
            this.mCaptureConfigs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int issueBurstCaptureRequest(List<CaptureConfig> captureConfigs) {
        Object object = this.mSessionLock;
        synchronized (object) {
            if (this.mState != State.OPENED) {
                Logger.d((String)TAG, (String)"Skipping issueBurstCaptureRequest due to session closed");
                return -1;
            }
            if (captureConfigs.isEmpty()) {
                return -1;
            }
            try {
                CameraBurstCaptureCallback callbackAggregator = new CameraBurstCaptureCallback();
                ArrayList<CaptureRequest> captureRequests = new ArrayList<CaptureRequest>();
                boolean isStillCapture = false;
                Logger.d((String)TAG, (String)"Issuing capture request.");
                for (CaptureConfig captureConfig : captureConfigs) {
                    if (captureConfig.getSurfaces().isEmpty()) {
                        Logger.d((String)TAG, (String)"Skipping issuing empty capture request.");
                        continue;
                    }
                    boolean surfacesValid = true;
                    for (DeferrableSurface surface : captureConfig.getSurfaces()) {
                        if (this.mConfiguredSurfaceMap.containsKey(surface)) continue;
                        Logger.d((String)TAG, (String)("Skipping capture request with invalid surface: " + surface));
                        surfacesValid = false;
                        break;
                    }
                    if (!surfacesValid) continue;
                    if (captureConfig.getTemplateType() == 2) {
                        isStillCapture = true;
                    }
                    CaptureConfig.Builder captureConfigBuilder = CaptureConfig.Builder.from((CaptureConfig)captureConfig);
                    if (captureConfig.getTemplateType() == 5 && captureConfig.getCameraCaptureResult() != null) {
                        captureConfigBuilder.setCameraCaptureResult(captureConfig.getCameraCaptureResult());
                    }
                    if (this.mSessionConfig != null) {
                        captureConfigBuilder.addImplementationOptions(this.mSessionConfig.getRepeatingCaptureConfig().getImplementationOptions());
                    }
                    captureConfigBuilder.addImplementationOptions(captureConfig.getImplementationOptions());
                    CaptureRequest captureRequest = Camera2CaptureRequestBuilder.build(captureConfigBuilder.build(), this.mSynchronizedCaptureSession.getDevice(), this.mConfiguredSurfaceMap);
                    if (captureRequest == null) {
                        Logger.d((String)TAG, (String)"Skipping issuing request without surface.");
                        return -1;
                    }
                    ArrayList<CameraCaptureSession.CaptureCallback> cameraCallbacks = new ArrayList<CameraCaptureSession.CaptureCallback>();
                    for (CameraCaptureCallback callback : captureConfig.getCameraCaptureCallbacks()) {
                        CaptureCallbackConverter.toCaptureCallback(callback, cameraCallbacks);
                    }
                    callbackAggregator.addCamera2Callbacks(captureRequest, cameraCallbacks);
                    captureRequests.add(captureRequest);
                }
                if (!captureRequests.isEmpty()) {
                    if (this.mStillCaptureFlow.shouldStopRepeatingBeforeCapture(captureRequests, isStillCapture)) {
                        this.mSynchronizedCaptureSession.stopRepeating();
                        callbackAggregator.setCaptureSequenceCallback((session, sequenceId, isAborted) -> {
                            Object object = this.mSessionLock;
                            synchronized (object) {
                                if (this.mState == State.OPENED) {
                                    this.issueRepeatingCaptureRequests(this.mSessionConfig);
                                }
                            }
                        });
                    }
                    if (this.mTorchStateReset.isTorchResetRequired(captureRequests, isStillCapture)) {
                        callbackAggregator.addCamera2Callbacks((CaptureRequest)captureRequests.get(captureRequests.size() - 1), Collections.singletonList(new CameraCaptureSession.CaptureCallback(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
                                Object object = CaptureSession.this.mSessionLock;
                                synchronized (object) {
                                    if (CaptureSession.this.mSessionConfig == null) {
                                        return;
                                    }
                                    CaptureConfig repeatingConfig = CaptureSession.this.mSessionConfig.getRepeatingCaptureConfig();
                                    Logger.d((String)CaptureSession.TAG, (String)"Submit FLASH_MODE_OFF request");
                                    CaptureSession.this.issueCaptureRequests(Collections.singletonList(CaptureSession.this.mTorchStateReset.createTorchResetRequest(repeatingConfig)));
                                }
                            }
                        }));
                    }
                    return this.mSynchronizedCaptureSession.captureBurstRequests(captureRequests, callbackAggregator);
                }
                Logger.d((String)TAG, (String)"Skipping issuing burst request due to no valid request elements");
            }
            catch (CameraAccessException e) {
                Logger.e((String)TAG, (String)("Unable to access camera: " + e.getMessage()));
                Thread.dumpStack();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortCaptures() {
        Object object = this.mSessionLock;
        synchronized (object) {
            if (this.mState != State.OPENED) {
                Logger.e((String)TAG, (String)("Unable to abort captures. Incorrect state:" + (Object)((Object)this.mState)));
                return;
            }
            try {
                this.mSynchronizedCaptureSession.abortCaptures();
            }
            catch (CameraAccessException e) {
                Logger.e((String)TAG, (String)"Unable to abort captures.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopRepeating() {
        Object object = this.mSessionLock;
        synchronized (object) {
            if (this.mState != State.OPENED) {
                Logger.e((String)TAG, (String)("Unable to stop repeating. Incorrect state:" + (Object)((Object)this.mState)));
                return;
            }
            try {
                this.mSynchronizedCaptureSession.stopRepeating();
            }
            catch (CameraAccessException e) {
                Logger.e((String)TAG, (String)"Unable to stop repeating.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelIssuedCaptureRequests() {
        ArrayList<CaptureConfig> captureConfigs = null;
        Iterator iterator = this.mSessionLock;
        synchronized (iterator) {
            if (!this.mCaptureConfigs.isEmpty()) {
                captureConfigs = new ArrayList<CaptureConfig>(this.mCaptureConfigs);
                this.mCaptureConfigs.clear();
            }
        }
        if (captureConfigs != null) {
            for (CaptureConfig captureConfig : captureConfigs) {
                for (CameraCaptureCallback cameraCaptureCallback : captureConfig.getCameraCaptureCallbacks()) {
                    cameraCaptureCallback.onCaptureCancelled();
                }
            }
        }
    }

    @GuardedBy(value="mSessionLock")
    private CameraCaptureSession.CaptureCallback createCamera2CaptureCallback(List<CameraCaptureCallback> cameraCaptureCallbacks, CameraCaptureSession.CaptureCallback ... additionalCallbacks) {
        ArrayList<CameraCaptureSession.CaptureCallback> camera2Callbacks = new ArrayList<CameraCaptureSession.CaptureCallback>(cameraCaptureCallbacks.size() + additionalCallbacks.length);
        for (CameraCaptureCallback callback : cameraCaptureCallbacks) {
            camera2Callbacks.add(CaptureCallbackConverter.toCaptureCallback(callback));
        }
        Collections.addAll(camera2Callbacks, additionalCallbacks);
        return Camera2CaptureCallbacks.createComboCallback(camera2Callbacks);
    }

    @GuardedBy(value="mSessionLock")
    List<CaptureConfig> setupConfiguredSurface(List<CaptureConfig> list) {
        ArrayList<CaptureConfig> ret = new ArrayList<CaptureConfig>();
        for (CaptureConfig c : list) {
            CaptureConfig.Builder builder = CaptureConfig.Builder.from((CaptureConfig)c);
            builder.setTemplateType(1);
            for (DeferrableSurface deferrableSurface : this.mSessionConfig.getRepeatingCaptureConfig().getSurfaces()) {
                builder.addSurface(deferrableSurface);
            }
            ret.add(builder.build());
        }
        return ret;
    }

    static enum State {
        UNINITIALIZED,
        INITIALIZED,
        GET_SURFACE,
        OPENING,
        OPENED,
        CLOSED,
        RELEASING,
        RELEASED;

    }

    final class StateCallback
    extends SynchronizedCaptureSession.StateCallback {
        StateCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConfigured(@NonNull SynchronizedCaptureSession session) {
            Object object = CaptureSession.this.mSessionLock;
            synchronized (object) {
                switch (CaptureSession.this.mState) {
                    case UNINITIALIZED: 
                    case INITIALIZED: 
                    case GET_SURFACE: 
                    case OPENED: 
                    case RELEASED: {
                        throw new IllegalStateException("onConfigured() should not be possible in state: " + (Object)((Object)CaptureSession.this.mState));
                    }
                    case OPENING: {
                        CaptureSession.this.mState = State.OPENED;
                        CaptureSession.this.mSynchronizedCaptureSession = session;
                        Logger.d((String)CaptureSession.TAG, (String)"Attempting to send capture request onConfigured");
                        CaptureSession.this.issueRepeatingCaptureRequests(CaptureSession.this.mSessionConfig);
                        CaptureSession.this.issuePendingCaptureRequest();
                        break;
                    }
                    case CLOSED: {
                        CaptureSession.this.mSynchronizedCaptureSession = session;
                        break;
                    }
                    case RELEASING: {
                        session.close();
                    }
                }
                Logger.d((String)CaptureSession.TAG, (String)("CameraCaptureSession.onConfigured() mState=" + (Object)((Object)CaptureSession.this.mState)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReady(@NonNull SynchronizedCaptureSession session) {
            Object object = CaptureSession.this.mSessionLock;
            synchronized (object) {
                switch (CaptureSession.this.mState) {
                    case UNINITIALIZED: {
                        throw new IllegalStateException("onReady() should not be possible in state: " + (Object)((Object)CaptureSession.this.mState));
                    }
                }
                Logger.d((String)CaptureSession.TAG, (String)("CameraCaptureSession.onReady() " + (Object)((Object)CaptureSession.this.mState)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionFinished(@NonNull SynchronizedCaptureSession session) {
            Object object = CaptureSession.this.mSessionLock;
            synchronized (object) {
                if (CaptureSession.this.mState == State.UNINITIALIZED) {
                    throw new IllegalStateException("onSessionFinished() should not be possible in state: " + (Object)((Object)CaptureSession.this.mState));
                }
                Logger.d((String)CaptureSession.TAG, (String)"onSessionFinished()");
                CaptureSession.this.finishClose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConfigureFailed(@NonNull SynchronizedCaptureSession session) {
            Object object = CaptureSession.this.mSessionLock;
            synchronized (object) {
                switch (CaptureSession.this.mState) {
                    case UNINITIALIZED: 
                    case INITIALIZED: 
                    case GET_SURFACE: 
                    case OPENED: {
                        throw new IllegalStateException("onConfigureFailed() should not be possible in state: " + (Object)((Object)CaptureSession.this.mState));
                    }
                    case OPENING: 
                    case CLOSED: 
                    case RELEASING: {
                        CaptureSession.this.finishClose();
                        break;
                    }
                    case RELEASED: {
                        Logger.d((String)CaptureSession.TAG, (String)"ConfigureFailed callback after change to RELEASED state");
                    }
                }
                Logger.e((String)CaptureSession.TAG, (String)("CameraCaptureSession.onConfigureFailed() " + (Object)((Object)CaptureSession.this.mState)));
            }
        }
    }
}

